/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class TableScan<Row>
implements Iterable<Row>,
AutoCloseable {
    private final GridCacheContext<?, ?> cctx;
    private final Predicate<Row> filters;
    private final ExecutionContext<Row> ectx;
    private final CacheTableDescriptor desc;
    private final RowHandler.RowFactory<Row> factory;
    private final AffinityTopologyVersion topVer;
    private final int[] parts;
    private final MvccSnapshot mvccSnapshot;
    private volatile List<GridDhtLocalPartition> reserved;
    private final Function<Row, Row> rowTransformer;
    private final ImmutableBitSet requiredColunms;

    public TableScan(ExecutionContext<Row> ectx, CacheTableDescriptor desc, int[] parts, Predicate<Row> filters, Function<Row, Row> rowTransformer, @Nullable ImmutableBitSet requiredColunms) {
        this.ectx = ectx;
        this.cctx = desc.cacheContext();
        this.desc = desc;
        this.parts = parts;
        this.filters = filters;
        this.rowTransformer = rowTransformer;
        this.requiredColunms = requiredColunms;
        RelDataType rowType = desc.rowType(this.ectx.getTypeFactory(), requiredColunms);
        this.factory = this.ectx.rowHandler().factory(this.ectx.getTypeFactory(), rowType);
        this.topVer = ectx.topologyVersion();
        this.mvccSnapshot = ectx.mvccSnapshot();
    }

    @Override
    public Iterator<Row> iterator() {
        this.reserve();
        try {
            return new IteratorImpl();
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
    }

    @Override
    public void close() {
        this.release();
    }

    private synchronized void reserve() {
        List<GridDhtLocalPartition> toReserve;
        if (this.reserved != null) {
            return;
        }
        GridDhtPartitionTopology top = this.cctx.topology();
        top.readLock();
        GridDhtTopologyFuture topFut = top.topologyVersionFuture();
        boolean done = topFut.isDone();
        if (!done || topFut.topologyVersion().compareTo(this.topVer) < 0 || this.cctx.shared().exchange().lastAffinityChangedTopologyVersion(topFut.initialVersion()).compareTo(this.topVer) > 0) {
            top.readUnlock();
            throw new ClusterTopologyException("Topology was changed. Please retry on stable topology.");
        }
        if (this.cctx.isReplicated()) {
            int partsCnt = this.cctx.affinity().partitions();
            toReserve = new ArrayList<GridDhtLocalPartition>(partsCnt);
            for (int i = 0; i < partsCnt; ++i) {
                toReserve.add(top.localPartition(i));
            }
        } else if (this.cctx.isPartitioned()) {
            assert (this.parts != null);
            toReserve = new ArrayList<GridDhtLocalPartition>(this.parts.length);
            for (int i = 0; i < this.parts.length; ++i) {
                toReserve.add(top.localPartition(this.parts[i]));
            }
        } else {
            assert (this.cctx.isLocal());
            toReserve = Collections.emptyList();
        }
        this.reserved = new ArrayList<GridDhtLocalPartition>(toReserve.size());
        try {
            for (GridDhtLocalPartition part : toReserve) {
                if (part == null || !part.reserve()) {
                    throw new ClusterTopologyException("Failed to reserve partition for query execution. Retry on stable topology.");
                }
                if (part.state() != GridDhtPartitionState.OWNING) {
                    part.release();
                    throw new ClusterTopologyException("Failed to reserve partition for query execution. Retry on stable topology.");
                }
                this.reserved.add(part);
            }
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
        finally {
            top.readUnlock();
        }
    }

    private synchronized void release() {
        if (F.isEmpty(this.reserved)) {
            return;
        }
        this.reserved.forEach(GridDhtLocalPartition::release);
        this.reserved = null;
    }

    private class IteratorImpl
    extends GridIteratorAdapter<Row> {
        private final Queue<GridDhtLocalPartition> parts;
        private GridCursor<? extends CacheDataRow> cur;
        private Row next;

        private IteratorImpl() {
            assert (TableScan.this.reserved != null);
            this.parts = new ArrayDeque<GridDhtLocalPartition>(TableScan.this.reserved);
        }

        public boolean hasNextX() throws IgniteCheckedException {
            this.advance();
            return this.next != null;
        }

        public Row nextX() throws IgniteCheckedException {
            this.advance();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object next = this.next;
            this.next = null;
            return next;
        }

        public void removeX() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        private void advance() throws IgniteCheckedException {
            assert (this.parts != null);
            if (this.next != null) {
                return;
            }
            while (true) {
                if (this.cur == null) {
                    GridDhtLocalPartition part = this.parts.poll();
                    if (part == null) break;
                    this.cur = part.dataStore().cursor(TableScan.this.cctx.cacheId(), TableScan.this.mvccSnapshot);
                }
                if (this.cur.next()) {
                    CacheDataRow row = (CacheDataRow)this.cur.get();
                    if (!TableScan.this.desc.match(row)) continue;
                    Object r = TableScan.this.desc.toRow(TableScan.this.ectx, row, TableScan.this.factory, TableScan.this.requiredColunms);
                    if (TableScan.this.filters != null && !TableScan.this.filters.test(r)) continue;
                    if (TableScan.this.rowTransformer != null) {
                        r = TableScan.this.rowTransformer.apply(r);
                    }
                    this.next = r;
                    break;
                }
                this.cur = null;
            }
        }
    }
}

