/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ClosableIteratorsHolder {
    private final ReferenceQueue refQueue;
    private final Map<Reference, Object> refMap;
    private final IgniteLogger log;
    private volatile boolean stopped;
    private Thread cleanWorker;

    public ClosableIteratorsHolder(IgniteLogger log) {
        this.log = log;
        this.refQueue = new ReferenceQueue();
        this.refMap = new ConcurrentHashMap<Reference, Object>();
    }

    public <T> Iterator<T> iterator(Iterator<T> src) {
        this.cleanUp(false);
        return new DelegatingIterator(src);
    }

    public void init() {
        this.cleanWorker = new Thread(() -> this.cleanUp(true), "ignite-calcite-iterators-cleanup");
        this.cleanWorker.setDaemon(true);
        this.cleanWorker.start();
    }

    public void tearDown() {
        this.stopped = true;
        this.refMap.clear();
        U.interrupt((Thread)this.cleanWorker);
    }

    private void cleanUp(boolean blocking) {
        Reference ref = this.nextRef(blocking);
        while (!this.stopped && ref != null) {
            Commons.close(this.refMap.remove(ref), this.log);
            ref = this.nextRef(blocking);
        }
    }

    private Reference nextRef(boolean blocking) {
        try {
            return !blocking ? this.refQueue.poll() : this.refQueue.remove();
        }
        catch (InterruptedException ignored) {
            return null;
        }
    }

    private AutoCloseable closeable(Object referent, Object resource) {
        if (!(resource instanceof AutoCloseable)) {
            return null;
        }
        return new CloseableReference(referent, resource);
    }

    private final class CloseableReference
    extends WeakReference
    implements AutoCloseable {
        private CloseableReference(Object referent, Object resource) {
            super(referent, ClosableIteratorsHolder.this.refQueue);
            ClosableIteratorsHolder.this.refMap.put(this, resource);
        }

        @Override
        public void close() throws Exception {
            try {
                Commons.close(ClosableIteratorsHolder.this.refMap.remove(this));
            }
            finally {
                this.clear();
            }
        }
    }

    private final class DelegatingIterator<T>
    implements Iterator<T>,
    AutoCloseable {
        private final Iterator<T> delegate;
        private final AutoCloseable closeable;

        private DelegatingIterator(Iterator<T> delegate) {
            this.delegate = delegate;
            this.closeable = ClosableIteratorsHolder.this.closeable(this, this.delegate);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.delegate.forEachRemaining(action);
        }

        @Override
        public void close() throws Exception {
            Commons.close(this.closeable);
        }
    }
}

