/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Context;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.CancelFlag;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryContext;
import org.apache.ignite.internal.processors.query.QueryState;
import org.apache.ignite.internal.processors.query.calcite.CalciteQueryProcessor;
import org.apache.ignite.internal.processors.query.calcite.Query;
import org.apache.ignite.internal.processors.query.calcite.RemoteFragmentKey;
import org.apache.ignite.internal.processors.query.calcite.RunningFragment;
import org.apache.ignite.internal.processors.query.calcite.exec.ExchangeService;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.RootNode;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.prepare.MultiStepPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlanningContext;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class RootQuery<RowT>
extends Query<RowT> {
    private final String sql;
    private final Object[] params;
    private final Map<UUID, AtomicInteger> remoteFragments;
    private final Set<RemoteFragmentKey> waiting;
    private volatile RootNode<RowT> root;
    private volatile PlanningContext pctx;
    private final BaseQueryContext ctx;
    private final long plannerTimeout;
    private volatile long locQryId;

    public RootQuery(String sql, SchemaPlus schema, Object[] params, QueryContext qryCtx, ExchangeService exch, Consumer<Query<RowT>> unregister, IgniteLogger log, long plannerTimeout) {
        super(UUID.randomUUID(), null, qryCtx != null ? (GridQueryCancel)qryCtx.unwrap(GridQueryCancel.class) : null, exch, unregister, log, 0);
        this.sql = sql;
        this.params = params;
        this.remoteFragments = new HashMap<UUID, AtomicInteger>();
        this.waiting = new HashSet<RemoteFragmentKey>();
        this.plannerTimeout = plannerTimeout;
        Context parent = Commons.convert(qryCtx);
        this.ctx = BaseQueryContext.builder().parentContext(parent).frameworkConfig(Frameworks.newConfigBuilder((FrameworkConfig)CalciteQueryProcessor.FRAMEWORK_CONFIG).defaultSchema(schema).build()).logger(log).build();
    }

    public RootQuery<RowT> childQuery(SchemaPlus schema) {
        return new RootQuery<RowT>(this.sql, schema, this.params, QueryContext.of((Object[])new Object[]{this.cancel}), this.exch, this.unregister, this.log, this.plannerTimeout);
    }

    public BaseQueryContext context() {
        return this.ctx;
    }

    public String sql() {
        return this.sql;
    }

    public Object[] parameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapping() {
        Object object = this.mux;
        synchronized (object) {
            if (this.state == QueryState.CLOSED) {
                throw new IgniteSQLException("The query was cancelled while executing.", 3014);
            }
            this.state = QueryState.MAPPING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ExecutionContext<RowT> ctx, MultiStepPlan plan, Node<RowT> root) {
        Object object = this.mux;
        synchronized (object) {
            if (this.state == QueryState.CLOSED) {
                throw new IgniteSQLException("The query was cancelled while executing.", 3014);
            }
            RootNode<RowT> rootNode = new RootNode<RowT>(ctx, plan.fieldsMetadata().rowType(), this::tryClose);
            rootNode.register(root);
            this.addFragment(new RunningFragment<RowT>(((Fragment)F.first(plan.fragments())).root(), rootNode, ctx));
            this.root = rootNode;
            for (int i = 1; i < plan.fragments().size(); ++i) {
                Fragment fragment = plan.fragments().get(i);
                List<UUID> nodes = plan.mapping(fragment).nodeIds();
                nodes.forEach(n -> this.remoteFragments.compute((UUID)n, (id, cnt) -> {
                    if (cnt == null) {
                        return new AtomicInteger(1);
                    }
                    cnt.incrementAndGet();
                    return cnt;
                }));
                for (UUID node : nodes) {
                    this.waiting.add(new RemoteFragmentKey(node, fragment.fragmentId()));
                }
            }
            this.state = QueryState.EXECUTING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tryClose() {
        QueryState state0 = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.state == QueryState.CLOSED) {
                return;
            }
            if (this.state == QueryState.INITED || this.state == QueryState.PLANNING || this.state == QueryState.MAPPING) {
                this.state = QueryState.CLOSED;
                return;
            }
            if (this.state == QueryState.EXECUTING) {
                state0 = this.state = QueryState.CLOSING;
                this.root.closeInternal();
            }
            if (this.state == QueryState.CLOSING && this.waiting.isEmpty()) {
                state0 = this.state = QueryState.CLOSED;
            }
        }
        if (state0 == QueryState.CLOSED) {
            try {
                IgniteException wrpEx = null;
                for (Map.Entry<UUID, AtomicInteger> entry : this.remoteFragments.entrySet()) {
                    try {
                        if (entry.getKey().equals(this.root.context().localNodeId()) || entry.getValue().get() <= 0) continue;
                        this.exch.closeQuery(entry.getKey(), this.id());
                    }
                    catch (IgniteCheckedException e) {
                        if (wrpEx == null) {
                            wrpEx = new IgniteException("Failed to send cancel message. [nodeId=" + entry.getKey() + ']', (Throwable)e);
                            continue;
                        }
                        wrpEx.addSuppressed((Throwable)e);
                    }
                }
                if (wrpEx != null) {
                    this.log.warning("An exception occures during the query cancel", wrpEx);
                }
            }
            finally {
                super.tryClose();
            }
        }
    }

    @Override
    public void cancel() {
        this.cancel.cancel();
        this.tryClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanningContext planningContext() {
        Object object = this.mux;
        synchronized (object) {
            if (this.state == QueryState.CLOSED || this.state == QueryState.CLOSING) {
                throw new IgniteSQLException("The query was cancelled while executing.", 3014);
            }
            if (this.state == QueryState.EXECUTING || this.state == QueryState.MAPPING) {
                throw new IgniteSQLException("Invalid query flow", 1);
            }
            if (this.pctx == null) {
                this.state = QueryState.PLANNING;
                this.pctx = PlanningContext.builder().parentContext(this.ctx).query(this.sql).parameters(this.params).plannerTimeout(this.plannerTimeout).build();
                try {
                    this.cancel.add(() -> this.pctx.unwrap(CancelFlag.class).requestCancel());
                }
                catch (QueryCancelledException e) {
                    throw new IgniteSQLException(e.getMessage(), 3014, (Throwable)e);
                }
            }
            return this.pctx;
        }
    }

    public Iterator<RowT> iterator() {
        return this.root;
    }

    public long localQueryId() {
        return this.locQryId;
    }

    public void localQueryId(long locQryId) {
        this.locQryId = locQryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNodeLeft(UUID nodeId) {
        List fragments = null;
        Object object = this.mux;
        synchronized (object) {
            fragments = this.waiting.stream().filter(f -> f.nodeId().equals(nodeId)).collect(Collectors.toList());
        }
        if (!F.isEmpty(fragments)) {
            ClusterTopologyCheckedException ex = new ClusterTopologyCheckedException("Failed to start query, node left. nodeId=" + nodeId);
            for (RemoteFragmentKey fragment : fragments) {
                this.onResponse(fragment, (Throwable)ex);
            }
        }
    }

    public void onResponse(UUID nodeId, long fragmentId, Throwable error) {
        this.onResponse(new RemoteFragmentKey(nodeId, fragmentId), error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponse(RemoteFragmentKey fragment, Throwable error) {
        QueryState state;
        Object object = this.mux;
        synchronized (object) {
            this.waiting.remove(fragment);
            state = this.state;
        }
        if (error != null) {
            this.onError(error);
        } else if (state == QueryState.CLOSING) {
            this.tryClose();
        }
    }

    public void onError(Throwable error) {
        this.root.onError(error);
        this.tryClose();
    }

    @Override
    public void onInboundExchangeStarted(UUID nodeId, long exchangeId) {
        this.onResponse(nodeId, exchangeId, null);
    }

    @Override
    public void onInboundExchangeFinished(UUID nodeId, long exchangeId) {
        AtomicInteger cnt = this.remoteFragments.get(nodeId);
        assert (cnt != null) : nodeId;
        cnt.decrementAndGet();
    }

    @Override
    public void onOutboundExchangeStarted(UUID nodeId, long exchangeId) {
    }

    @Override
    public void onOutboundExchangeFinished(long exchangeId) {
    }

    @Override
    public String toString() {
        return S.toString(RootQuery.class, (Object)this);
    }
}

