/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.query.VisorQueryIndex;

public class VisorQueryEntity
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String keyType;
    private String valType;
    private Map<String, String> qryFlds;
    private List<String> keyFields;
    private Map<String, String> aliases;
    private String tblName;
    private String keyFieldName;
    private String valFieldName;
    private List<VisorQueryIndex> grps;

    public static List<VisorQueryEntity> list(Collection<QueryEntity> qryEntities) {
        ArrayList<VisorQueryEntity> entities = new ArrayList<VisorQueryEntity>();
        if (!F.isEmpty(qryEntities)) {
            for (QueryEntity qryEntity : qryEntities) {
                entities.add(new VisorQueryEntity(qryEntity));
            }
        }
        return entities;
    }

    public VisorQueryEntity() {
    }

    private VisorQueryEntity(QueryEntity q) {
        assert (q != null);
        this.keyType = q.getKeyType();
        this.valType = q.getValueType();
        this.keyFields = VisorQueryEntity.toList(q.getKeyFields());
        LinkedHashMap<String, String> qryFields = q.getFields();
        this.qryFlds = new LinkedHashMap<String, String>(qryFields);
        this.aliases = U.copyMap(q.getAliases());
        Collection<QueryIndex> qryIdxs = q.getIndexes();
        this.grps = new ArrayList<VisorQueryIndex>(qryIdxs.size());
        for (QueryIndex qryIdx : qryIdxs) {
            this.grps.add(new VisorQueryIndex(qryIdx));
        }
        this.tblName = q.getTableName();
        this.keyFieldName = q.getKeyFieldName();
        this.valFieldName = q.getValueFieldName();
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getValueType() {
        return this.valType;
    }

    public List<String> getKeyFields() {
        return this.keyFields;
    }

    public Map<String, String> getQueryFields() {
        return this.qryFlds;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public String getTableName() {
        return this.tblName;
    }

    public String getKeyFieldName() {
        return this.keyFieldName;
    }

    public String getValueFieldName() {
        return this.valFieldName;
    }

    public List<VisorQueryIndex> getGroups() {
        return this.grps;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.keyType);
        U.writeString(out, this.valType);
        U.writeCollection(out, this.keyFields);
        IgniteUtils.writeStringMap(out, this.qryFlds);
        U.writeMap(out, this.aliases);
        U.writeCollection(out, this.grps);
        U.writeString(out, this.tblName);
        U.writeString(out, this.keyFieldName);
        U.writeString(out, this.valFieldName);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.keyType = U.readString(in);
        this.valType = U.readString(in);
        this.keyFields = U.readList(in);
        this.qryFlds = IgniteUtils.readStringMap(in);
        this.aliases = U.readMap(in);
        this.grps = U.readList(in);
        this.tblName = U.readString(in);
        this.keyFieldName = U.readString(in);
        this.valFieldName = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorQueryEntity.class, this);
    }
}

