/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class StatisticsObjectConfiguration
implements Serializable,
Comparable<StatisticsObjectConfiguration> {
    public static final byte DEFAULT_OBSOLESCENCE_MAX_PERCENT = 15;
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final StatisticsKey key;
    @GridToStringInclude
    private final Map<String, StatisticsColumnConfiguration> cols;
    private final byte maxPartitionObsolescencePercent;

    public StatisticsObjectConfiguration(StatisticsKey key, Collection<StatisticsColumnConfiguration> cols, byte maxPartitionObsolescencePercent) {
        this.key = key;
        this.cols = cols.stream().collect(Collectors.toMap(StatisticsColumnConfiguration::name, Function.identity()));
        this.maxPartitionObsolescencePercent = maxPartitionObsolescencePercent;
    }

    public static StatisticsObjectConfiguration merge(@NotNull StatisticsObjectConfiguration oldCfg, @NotNull StatisticsObjectConfiguration newCfg) {
        assert (oldCfg.key.equals(newCfg.key)) : "Invalid stat config to merge: [oldKey=" + oldCfg.key + ", newKey=" + newCfg.key + ']';
        HashMap<String, StatisticsColumnConfiguration> cols = new HashMap<String, StatisticsColumnConfiguration>(oldCfg.cols);
        for (StatisticsColumnConfiguration c : newCfg.cols.values()) {
            cols.put(c.name(), StatisticsColumnConfiguration.merge((StatisticsColumnConfiguration)cols.get(c.name()), c));
        }
        for (StatisticsColumnConfiguration oldC : oldCfg.cols.values()) {
            if (cols.containsKey(oldC.name())) continue;
            cols.put(oldC.name(), oldC);
        }
        return new StatisticsObjectConfiguration(newCfg.key, cols.values(), newCfg.maxPartitionObsolescencePercent);
    }

    public StatisticsObjectConfiguration dropColumns(Set<String> dropColNames) {
        HashMap<String, StatisticsColumnConfiguration> newCols = new HashMap<String, StatisticsColumnConfiguration>();
        for (StatisticsColumnConfiguration col : this.cols.values()) {
            if (F.isEmpty(dropColNames) || dropColNames.contains(col.name())) {
                newCols.put(col.name(), col.createTombstone());
                continue;
            }
            newCols.put(col.name(), col);
        }
        return new StatisticsObjectConfiguration(this.key, newCols.values(), this.maxPartitionObsolescencePercent);
    }

    public StatisticsObjectConfiguration refresh(Set<String> refreshCols) {
        ArrayList<StatisticsColumnConfiguration> newCols;
        if (F.isEmpty(refreshCols)) {
            newCols = new ArrayList<StatisticsColumnConfiguration>(this.cols.values());
        } else {
            newCols = new ArrayList(this.cols.size());
            for (StatisticsColumnConfiguration col : this.cols.values()) {
                if (refreshCols.contains(col.name())) {
                    newCols.add(col.refresh());
                    continue;
                }
                newCols.add(col);
            }
        }
        return new StatisticsObjectConfiguration(this.key, newCols, this.maxPartitionObsolescencePercent);
    }

    public static Diff diff(StatisticsObjectConfiguration oldCfg, StatisticsObjectConfiguration newCfg) {
        if (oldCfg == null) {
            return new Diff(Collections.emptySet(), newCfg.cols);
        }
        HashSet<String> dropCols = new HashSet<String>();
        HashMap<String, StatisticsColumnConfiguration> updateCols = new HashMap<String, StatisticsColumnConfiguration>();
        for (StatisticsColumnConfiguration colNew : newCfg.cols.values()) {
            StatisticsColumnConfiguration colOld = oldCfg.cols.get(colNew.name());
            if (colOld == null || colNew.version() > colOld.version() && !colNew.tombstone() || !Objects.equals(colOld.overrides(), colNew.overrides())) {
                updateCols.put(colNew.name(), colNew);
                continue;
            }
            if (!colNew.tombstone() || colOld.tombstone()) continue;
            dropCols.add(colNew.name());
        }
        return new Diff(dropCols, updateCols);
    }

    public StatisticsKey key() {
        return this.key;
    }

    public Map<String, StatisticsColumnConfiguration> columnsAll() {
        return this.cols;
    }

    public Map<String, StatisticsColumnConfiguration> columns() {
        return this.cols == null ? Collections.emptyMap() : this.cols.entrySet().stream().filter(e -> !((StatisticsColumnConfiguration)e.getValue()).tombstone()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public byte maxPartitionObsolescencePercent() {
        return this.maxPartitionObsolescencePercent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsObjectConfiguration that = (StatisticsObjectConfiguration)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.cols, that.cols) && this.maxPartitionObsolescencePercent == that.maxPartitionObsolescencePercent;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.cols, this.maxPartitionObsolescencePercent);
    }

    public String toString() {
        return S.toString(StatisticsObjectConfiguration.class, this);
    }

    @Override
    public int compareTo(@NotNull StatisticsObjectConfiguration o) {
        if (this == o) {
            return 0;
        }
        if (this.cols.size() < o.cols.size()) {
            return -1;
        }
        if (this.cols.size() > o.cols.size()) {
            return 1;
        }
        for (StatisticsColumnConfiguration thisColCfg : this.cols.values()) {
            StatisticsColumnConfiguration oColCfg = o.cols.get(thisColCfg.name());
            if (oColCfg == null || thisColCfg.version() > oColCfg.version()) {
                return 1;
            }
            if (thisColCfg.version() >= oColCfg.version()) continue;
            return -1;
        }
        return 0;
    }

    public static class Diff {
        private final Set<String> dropCols;
        private final Map<String, StatisticsColumnConfiguration> updateCols;

        public Diff(Set<String> dropCols, Map<String, StatisticsColumnConfiguration> updateCols) {
            this.dropCols = dropCols;
            this.updateCols = updateCols;
        }

        public Set<String> dropCols() {
            return this.dropCols;
        }

        public Map<String, StatisticsColumnConfiguration> updateCols() {
            return this.updateCols;
        }
    }
}

