/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.affinity;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;

public class PlatformAffinityManager
extends PlatformAbstractTarget {
    public static final int OP_IS_ASSIGNMENT_VALID = 1;
    private final GridCacheAffinityManager affMgr;

    public PlatformAffinityManager(PlatformContext platformCtx, int cacheId) {
        super(platformCtx);
        GridCacheContext ctx = platformCtx.kernalContext().cache().context().cacheContext(cacheId);
        if (ctx == null) {
            throw new IgniteException("Cache doesn't exist: " + cacheId);
        }
        this.affMgr = ctx.affinity();
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        if (type == 1) {
            AffinityTopologyVersion endVer;
            AffinityTopologyVersion ver = new AffinityTopologyVersion(reader.readLong(), reader.readInt());
            int part = reader.readInt();
            if (!this.affMgr.primaryChanged(part, ver, endVer = this.affMgr.affinityTopologyVersion())) {
                return 1L;
            }
            if (!this.affMgr.partitionLocalNode(part, endVer)) {
                return 0L;
            }
            return ver.topologyVersion() == endVer.topologyVersion() ? 1L : 0L;
        }
        return super.processInStreamOutLong(type, reader);
    }
}

