/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.management.InstanceNotFoundException;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataRegionMetricsProvider;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WarmUpConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.systemview.walker.PagesListViewWalker;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.mem.IgniteOutOfMemoryException;
import org.apache.ignite.internal.mem.file.MappedFileMemoryProvider;
import org.apache.ignite.internal.mem.unsafe.UnsafeMemoryProvider;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.impl.PageMemoryNoStoreImpl;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointLockStateChecker;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.DataStructure;
import org.apache.ignite.internal.processors.cache.persistence.DatabaseLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.evict.FairFifoPageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.evict.NoOpPageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.evict.PageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.evict.Random2LruPageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.evict.RandomLruPageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.freelist.CacheFreeList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.PagesList;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageReadWriteManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.warmup.WarmUpStrategy;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.util.TimeBag;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.mxbean.DataRegionMetricsMXBean;
import org.apache.ignite.spi.systemview.view.PagesListView;
import org.jetbrains.annotations.Nullable;

public class IgniteCacheDatabaseSharedManager
extends GridCacheSharedManagerAdapter
implements IgniteChangeGlobalStateSupport,
CheckpointLockStateChecker {
    public static final String SYSTEM_DATA_REGION_NAME = "sysMemPlc";
    public static Set<String> INTERNAL_DATA_REGION_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("sysMemPlc", "TxLog", "metastoreMemPlc")));
    public static final String DATA_REGION_PAGE_LIST_VIEW = "dataRegionPageLists";
    public static final String DATA_REGION_PAGE_LIST_VIEW_DESC = "Data region page lists";
    private static final long MIN_PAGE_MEMORY_SIZE = 0xA00000L;
    private static final long MAX_PAGE_MEMORY_INIT_SIZE_32_BIT = 0x80000000L;
    protected final boolean reuseMemory = IgniteSystemProperties.getBoolean("IGNITE_REUSE_MEMORY_ON_DEACTIVATE");
    protected final Map<String, DataRegion> dataRegionMap = new ConcurrentHashMap<String, DataRegion>();
    private final Map<String, DirectMemoryProvider> memProviderMap = new ConcurrentHashMap<String, DirectMemoryProvider>();
    private static final String MBEAN_GROUP_NAME = "DataRegionMetrics";
    protected volatile boolean dataRegionsInitialized;
    private volatile boolean dataRegionsStarted;
    protected DataRegion dfltDataRegion;
    protected Map<String, CacheFreeList> freeListMap;
    private CacheFreeList dfltFreeList;
    private int pageSize;
    private volatile boolean firstEvictWarn;

    @Override
    protected void start0() throws IgniteCheckedException {
        if (this.cctx.kernalContext().clientNode() && this.cctx.kernalContext().config().getDataStorageConfiguration() == null) {
            return;
        }
        DataStorageConfiguration memCfg = this.cctx.kernalContext().config().getDataStorageConfiguration();
        assert (memCfg != null);
        this.validateConfiguration(memCfg);
        this.pageSize = memCfg.getPageSize();
        this.initDataRegions(memCfg);
        this.cctx.kernalContext().systemView().registerView(DATA_REGION_PAGE_LIST_VIEW, DATA_REGION_PAGE_LIST_VIEW_DESC, new PagesListViewWalker(), () -> {
            Map<String, CacheFreeList> freeLists = this.freeListMap;
            if (freeLists == null) {
                return Collections.emptyList();
            }
            return freeLists.values().stream().flatMap(fl -> IntStream.range(0, fl.bucketsCount()).mapToObj(bucket -> new PagesListView((PagesList)fl, bucket))).collect(Collectors.toList());
        }, Function.identity());
    }

    protected <T> void registerMetricsMBean(IgniteConfiguration cfg, String groupName, String dataRegionName, T impl2, Class<T> clazz) {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        try {
            U.registerMBean(cfg.getMBeanServer(), cfg.getIgniteInstanceName(), groupName, dataRegionName, impl2, clazz);
        }
        catch (Throwable e) {
            U.error(this.log, "Failed to register MBean with name: " + dataRegionName, e);
        }
    }

    protected void unregisterMetricsMBean(IgniteConfiguration cfg, String groupName, String name) {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        assert (cfg != null);
        try {
            cfg.getMBeanServer().unregisterMBean(U.makeMBeanName(cfg.getIgniteInstanceName(), groupName, name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Throwable e) {
            U.error(this.log, "Failed to unregister MBean for memory metrics: " + name, e);
        }
    }

    protected void registerMetricsMBeans(IgniteConfiguration cfg) {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        assert (cfg != null);
        for (DataRegion dataRegion : this.dataRegionMap.values()) {
            this.registerMetricsMBean(cfg, MBEAN_GROUP_NAME, dataRegion.config().getName(), new DataRegionMetricsMXBeanImpl(dataRegion), DataRegionMetricsMXBean.class);
        }
    }

    protected void initPageMemoryDataStructures(DataStorageConfiguration dbCfg) throws IgniteCheckedException {
        this.freeListMap = U.newHashMap(this.dataRegionMap.size());
        String dfltMemPlcName = dbCfg.getDefaultDataRegionConfiguration().getName();
        for (DataRegion memPlc : this.dataRegionMap.values()) {
            DataRegionConfiguration memPlcCfg = memPlc.config();
            boolean persistenceEnabled = memPlcCfg.isPersistenceEnabled();
            String freeListName = memPlcCfg.getName() + "##FreeList";
            CacheFreeList freeList = new CacheFreeList(0, freeListName, memPlc, persistenceEnabled ? this.cctx.wal() : null, 0L, true, this.cctx.diagnostic().pageLockTracker(), this.cctx.kernalContext(), null, 2);
            this.freeListMap.put(memPlcCfg.getName(), freeList);
        }
        this.dfltFreeList = this.freeListMap.get(dfltMemPlcName);
    }

    public int pageSize() {
        return this.pageSize;
    }

    private void startDataRegions() {
        for (DataRegion region : this.dataRegionMap.values()) {
            if (!this.cctx.isLazyMemoryAllocation(region)) {
                region.pageMemory().start();
            }
            region.evictionTracker().start();
        }
    }

    protected void initDataRegions(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        if (this.dataRegionsInitialized) {
            return;
        }
        this.initDataRegions0(memCfg);
        this.dataRegionsInitialized = true;
        U.log(this.log, "Configured data regions initialized successfully [total=" + this.dataRegionMap.size() + ']');
    }

    protected void initDataRegions0(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        DataRegionConfiguration[] dataRegionCfgs = memCfg.getDataRegionConfigurations();
        boolean persistenceEnabled = CU.isPersistenceEnabled(memCfg);
        if (dataRegionCfgs != null) {
            for (DataRegionConfiguration dataRegionCfg : dataRegionCfgs) {
                this.addDataRegion(memCfg, dataRegionCfg, dataRegionCfg.isPersistenceEnabled());
            }
        }
        this.addDataRegion(memCfg, memCfg.getDefaultDataRegionConfiguration(), memCfg.getDefaultDataRegionConfiguration().isPersistenceEnabled());
        this.addDataRegion(memCfg, this.createSystemDataRegion(memCfg.getSystemRegionInitialSize(), memCfg.getSystemRegionMaxSize(), persistenceEnabled), persistenceEnabled);
        this.addDataRegion(memCfg, this.createVolatileDataRegion(memCfg.getSystemRegionInitialSize(), memCfg.getSystemRegionMaxSize()), false);
        for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
            lsnr.onInitDataRegions(this);
        }
    }

    protected List<DatabaseLifecycleListener> getDatabaseListeners(GridKernalContext kctx) {
        return kctx.internalSubscriptionProcessor().getDatabaseListeners();
    }

    public DataRegion addDataRegion(DataStorageConfiguration dataStorageCfg, DataRegionConfiguration dataRegionCfg, boolean trackable) throws IgniteCheckedException {
        return this.addDataRegion(dataStorageCfg, dataRegionCfg, trackable, this.cctx.pageStore());
    }

    protected DataRegion addDataRegion(DataStorageConfiguration dataStorageCfg, DataRegionConfiguration dataRegionCfg, boolean trackable, PageReadWriteManager pmPageMgr) throws IgniteCheckedException {
        String dataRegionName = dataRegionCfg.getName();
        String dfltMemPlcName = dataStorageCfg.getDefaultDataRegionConfiguration().getName();
        if (dfltMemPlcName == null) {
            dfltMemPlcName = "default";
        }
        DataRegionMetricsImpl memMetrics = new DataRegionMetricsImpl(dataRegionCfg, this.cctx.kernalContext(), this.dataRegionMetricsProvider(dataRegionCfg));
        DataRegion region = this.initMemory(dataStorageCfg, dataRegionCfg, memMetrics, trackable, pmPageMgr);
        this.dataRegionMap.put(dataRegionName, region);
        if (dataRegionName.equals(dfltMemPlcName)) {
            this.dfltDataRegion = region;
        } else if (dataRegionName.equals("default")) {
            U.warn(this.log, "Data Region with name 'default' isn't used as a default. Please, check Data Region configuration.");
        }
        return region;
    }

    @Deprecated
    protected IgniteOutClosure<Long> freeSpaceProvider(DataRegionConfiguration dataRegCfg) {
        final String dataRegName = dataRegCfg.getName();
        return new IgniteOutClosure<Long>(){
            private CacheFreeList freeList;

            @Override
            public Long apply() {
                if (this.freeList == null) {
                    CacheFreeList freeList0 = IgniteCacheDatabaseSharedManager.this.freeListMap.get(dataRegName);
                    if (freeList0 == null) {
                        return 0L;
                    }
                    this.freeList = freeList0;
                }
                return this.freeList.freeSpace();
            }
        };
    }

    protected DataRegionMetricsProvider dataRegionMetricsProvider(DataRegionConfiguration dataRegCfg) {
        final String dataRegName = dataRegCfg.getName();
        return new DataRegionMetricsProvider(){
            private CacheFreeList freeList;

            private CacheFreeList getFreeList() {
                if (IgniteCacheDatabaseSharedManager.this.freeListMap == null) {
                    return null;
                }
                if (this.freeList == null) {
                    this.freeList = IgniteCacheDatabaseSharedManager.this.freeListMap.get(dataRegName);
                }
                return this.freeList;
            }

            @Override
            public long partiallyFilledPagesFreeSpace() {
                CacheFreeList freeList0 = this.getFreeList();
                return freeList0 == null ? 0L : freeList0.freeSpace();
            }

            @Override
            public long emptyDataPages() {
                CacheFreeList freeList0 = this.getFreeList();
                return freeList0 == null ? 0L : (long)freeList0.emptyDataPages();
            }
        };
    }

    private boolean hasCustomDefaultDataRegion(DataRegionConfiguration[] memPlcsCfgs) {
        for (DataRegionConfiguration memPlcsCfg : memPlcsCfgs) {
            if (!"default".equals(memPlcsCfg.getName())) continue;
            return true;
        }
        return false;
    }

    private DataRegionConfiguration createSystemDataRegion(long sysCacheInitSize, long sysCacheMaxSize, boolean persistenceEnabled) {
        DataRegionConfiguration res = new DataRegionConfiguration();
        res.setName(SYSTEM_DATA_REGION_NAME);
        res.setInitialSize(sysCacheInitSize);
        res.setMaxSize(sysCacheMaxSize);
        res.setPersistenceEnabled(persistenceEnabled);
        res.setLazyMemoryAllocation(false);
        return res;
    }

    private DataRegionConfiguration createVolatileDataRegion(long volatileCacheInitSize, long volatileCacheMaxSize) {
        DataRegionConfiguration res = new DataRegionConfiguration();
        res.setName("volatileDsMemPlc");
        res.setInitialSize(volatileCacheInitSize);
        res.setMaxSize(volatileCacheMaxSize);
        res.setPersistenceEnabled(false);
        res.setLazyMemoryAllocation(true);
        return res;
    }

    private void validateConfiguration(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        this.checkPageSize(memCfg);
        DataRegionConfiguration[] regCfgs = memCfg.getDataRegionConfigurations();
        HashSet<String> regNames = new HashSet<String>();
        IgniteCacheDatabaseSharedManager.checkSystemDataRegionSizeConfiguration(memCfg.getSystemRegionInitialSize(), memCfg.getSystemRegionMaxSize());
        Map<Class<? extends WarmUpConfiguration>, WarmUpStrategy> warmUpStrategies = CU.warmUpStrategies(this.cctx.kernalContext());
        if (regCfgs != null) {
            for (DataRegionConfiguration regCfg : regCfgs) {
                this.checkDataRegionConfiguration(memCfg, regNames, regCfg, warmUpStrategies);
            }
        }
        this.checkDataRegionConfiguration(memCfg, regNames, memCfg.getDefaultDataRegionConfiguration(), warmUpStrategies);
        IgniteCacheDatabaseSharedManager.checkWalArchiveSizeConfiguration(memCfg, this.log);
        this.checkExistenceWarmUpConfiguration(memCfg.getDefaultWarmUpConfiguration(), warmUpStrategies, warmUpCfg -> "Unknown default warm-up configuration: " + warmUpCfg);
    }

    static void checkWalArchiveSizeConfiguration(DataStorageConfiguration memCfg, IgniteLogger log) throws IgniteCheckedException {
        long max = memCfg.getMaxWalArchiveSize();
        if (!CU.isPersistenceEnabled(memCfg)) {
            if (max != 0x40000000L) {
                LT.info(log, "Maximum WAL archive size has been configured but this node has been launched in non-persistent mode, so this parameter will be ignored");
            }
            return;
        }
        if (memCfg.isWalHistorySizeParameterUsed()) {
            LT.warn(log, "DataRegionConfiguration.walHistorySize property is deprecated and is no longer supported. It will be ignored and DataRegionConfiguration.maxWalArchiveSize property will be used instead to control removal of archived WAL files");
        }
        if (max != -1L) {
            int walSegmentSize = memCfg.getWalSegmentSize();
            if (max < (long)walSegmentSize) {
                throw new IgniteCheckedException(String.format("DataRegionConfiguration.maxWalArchiveSize must be no less than DataRegionConfiguration.walSegmentSize or equal to %d (unlimited size), current settings:" + U.nl() + "DataRegionConfiguration.maxWalArchiveSize: %d bytes" + U.nl() + "DataRegionConfiguration.walSegmentSize: %d bytes", -1L, max, walSegmentSize));
            }
            long min = memCfg.getMinWalArchiveSize();
            double percentage = IgniteSystemProperties.getDouble("IGNITE_THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE", -1.0);
            if (min != -1L) {
                if (min > max) {
                    throw new IgniteCheckedException(String.format("DataRegionConfiguration.minWalArchiveSize must be less than or equal to DataRegionConfiguration.maxWalArchiveSize or equal to %d (to be half of maxWalArchiveSize), current settings:" + U.nl() + "DataRegionConfiguration.minWalArchiveSize: %d bytes" + U.nl() + "DataRegionConfiguration.maxWalArchiveSize: %d bytes", -1L, min, max));
                }
            } else if (percentage != -1.0) {
                log.warning(String.format("%s is deprecated, use DataRegionConfiguration.minWalArchiveSize instead", "IGNITE_THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE"));
                if ((long)((double)max * percentage) > max) {
                    throw new IgniteCheckedException(String.format("%s must be less than or equal to 1.0", "IGNITE_THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE"));
                }
            }
        }
    }

    private void checkDataRegionConfiguration(DataStorageConfiguration memCfg, Set<String> regNames, DataRegionConfiguration regCfg, Map<Class<? extends WarmUpConfiguration>, WarmUpStrategy> warmUpStrategies) throws IgniteCheckedException {
        assert (regCfg != null);
        IgniteCacheDatabaseSharedManager.checkDataRegionName(regCfg.getName(), regNames);
        this.checkDataRegionSize(regCfg);
        IgniteCacheDatabaseSharedManager.checkMetricsProperties(regCfg);
        this.checkRegionEvictionProperties(regCfg, memCfg);
        this.checkRegionMemoryStorageType(regCfg);
        this.checkRegionWarmUpConfiguration(regCfg, warmUpStrategies);
    }

    protected void checkPageSize(DataStorageConfiguration memCfg) {
        if (memCfg.getPageSize() == 0) {
            memCfg.setPageSize(4096);
        }
    }

    private static void checkMetricsProperties(DataRegionConfiguration regCfg) throws IgniteCheckedException {
        if (regCfg.getMetricsRateTimeInterval() <= 0L) {
            throw new IgniteCheckedException("Rate time interval must be greater than zero (use DataRegionConfiguration.rateTimeInterval property to adjust the interval) [name=" + regCfg.getName() + ", rateTimeInterval=" + regCfg.getMetricsRateTimeInterval() + "]");
        }
        if (regCfg.getMetricsSubIntervalCount() <= 0) {
            throw new IgniteCheckedException("Sub intervals must be greater than zero (use DataRegionConfiguration.subIntervals property to adjust the sub intervals) [name=" + regCfg.getName() + ", subIntervals=" + regCfg.getMetricsSubIntervalCount() + "]");
        }
        if (regCfg.getMetricsRateTimeInterval() < 1000L) {
            throw new IgniteCheckedException("Rate time interval must be longer that 1 second (1_000 milliseconds) (use DataRegionConfiguration.rateTimeInterval property to adjust the interval) [name=" + regCfg.getName() + ", rateTimeInterval=" + regCfg.getMetricsRateTimeInterval() + "]");
        }
    }

    private static void checkSystemDataRegionSizeConfiguration(long sysCacheInitSize, long sysCacheMaxSize) throws IgniteCheckedException {
        if (sysCacheInitSize < 0xA00000L) {
            throw new IgniteCheckedException("Initial size for system cache must have size more than 10MB (use DataStorageConfiguration.systemCacheInitialSize property to set correct size in bytes) [size=" + U.readableSize(sysCacheInitSize, true) + ']');
        }
        if (U.jvm32Bit() && sysCacheInitSize > 0x80000000L) {
            throw new IgniteCheckedException("Initial size for system cache exceeds 2GB on 32-bit JVM (use DataRegionConfiguration.systemCacheInitialSize property to set correct size in bytes or use 64-bit JVM) [size=" + U.readableSize(sysCacheInitSize, true) + ']');
        }
        if (sysCacheMaxSize < sysCacheInitSize) {
            throw new IgniteCheckedException("MaxSize of system cache must not be smaller than initialSize [initSize=" + U.readableSize(sysCacheInitSize, true) + ", maxSize=" + U.readableSize(sysCacheMaxSize, true) + "]. Use DataStorageConfiguration.systemCacheInitialSize/DataStorageConfiguration.systemCacheMaxSize properties to set correct sizes in bytes.");
        }
    }

    private void checkDataRegionSize(DataRegionConfiguration regCfg) throws IgniteCheckedException {
        if (regCfg.getInitialSize() < 0xA00000L || regCfg.getMaxSize() < 0xA00000L) {
            throw new IgniteCheckedException("DataRegion must have size more than 10MB (use DataRegionConfiguration.initialSize and .maxSize properties to set correct size in bytes) [name=" + regCfg.getName() + ", initialSize=" + U.readableSize(regCfg.getInitialSize(), true) + ", maxSize=" + U.readableSize(regCfg.getMaxSize(), true) + "]");
        }
        if (regCfg.getMaxSize() < regCfg.getInitialSize()) {
            if (regCfg.getInitialSize() != Math.min(DataStorageConfiguration.DFLT_DATA_REGION_MAX_SIZE, 0x10000000L)) {
                throw new IgniteCheckedException("DataRegion maxSize must not be smaller than initialSize[name=" + regCfg.getName() + ", initialSize=" + U.readableSize(regCfg.getInitialSize(), true) + ", maxSize=" + U.readableSize(regCfg.getMaxSize(), true) + "]");
            }
            regCfg.setInitialSize(regCfg.getMaxSize());
            LT.warn(this.log, "DataRegion maxSize=" + U.readableSize(regCfg.getMaxSize(), true) + " is smaller than defaultInitialSize=" + U.readableSize(0x10000000L, true) + ", setting initialSize to " + U.readableSize(regCfg.getMaxSize(), true));
        }
        if (U.jvm32Bit() && regCfg.getInitialSize() > 0x80000000L) {
            throw new IgniteCheckedException("DataRegion initialSize exceeds 2GB on 32-bit JVM (use DataRegionConfiguration.initialSize property to set correct size in bytes or use 64-bit JVM) [name=" + regCfg.getName() + ", size=" + U.readableSize(regCfg.getInitialSize(), true) + "]");
        }
    }

    private void checkRegionMemoryStorageType(DataRegionConfiguration regCfg) throws IgniteCheckedException {
        if (regCfg.isPersistenceEnabled() && regCfg.getSwapPath() != null) {
            throw new IgniteCheckedException("DataRegionConfiguration must not have both persistence storage and swap space enabled at the same time (Use DataRegionConfiguration.setSwapPath(null)  to disable the swap space usage or DataRegionConfiguration.setPersistenceEnabled(false) to disable the persistence) [name=" + regCfg.getName() + ", swapPath=" + regCfg.getSwapPath() + ", persistenceEnabled=" + regCfg.isPersistenceEnabled() + "]");
        }
    }

    protected void checkRegionEvictionProperties(DataRegionConfiguration regCfg, DataStorageConfiguration dbCfg) throws IgniteCheckedException {
        if (regCfg.getPageEvictionMode() == DataPageEvictionMode.DISABLED) {
            return;
        }
        if (regCfg.getEvictionThreshold() < 0.5 || regCfg.getEvictionThreshold() > 0.999) {
            throw new IgniteCheckedException("Page eviction threshold must be between 0.5 and 0.999: " + regCfg.getName());
        }
        if (regCfg.getEmptyPagesPoolSize() <= 10) {
            throw new IgniteCheckedException("Evicted pages pool size should be greater than 10: " + regCfg.getName());
        }
        long maxPoolSize = regCfg.getMaxSize() / (long)dbCfg.getPageSize() / 10L;
        if ((long)regCfg.getEmptyPagesPoolSize() >= maxPoolSize) {
            throw new IgniteCheckedException("Evicted pages pool size should be lesser than " + maxPoolSize + ": " + regCfg.getName());
        }
    }

    private static void checkDataRegionName(String regName, Collection<String> observedNames) throws IgniteCheckedException {
        if (regName == null || regName.isEmpty()) {
            throw new IgniteCheckedException("User-defined DataRegionConfiguration must have non-null and non-empty name.");
        }
        if (observedNames.contains(regName)) {
            throw new IgniteCheckedException("Two MemoryPolicies have the same name: " + regName);
        }
        if (INTERNAL_DATA_REGION_NAMES.contains(regName)) {
            throw new IgniteCheckedException("'" + regName + "' policy name is reserved for internal use.");
        }
        observedNames.add(regName);
    }

    public void dumpStatistics(IgniteLogger log) {
        if (this.freeListMap != null) {
            for (CacheFreeList freeList : this.freeListMap.values()) {
                freeList.dumpStatistics(log);
            }
        }
    }

    public Collection<DataRegion> dataRegions() {
        return this.dataRegionMap.values();
    }

    public Collection<DataRegionMetrics> memoryMetrics() {
        return this.dataRegionMap.values().stream().map(DataRegion::metrics).map(DataRegionMetricsSnapshot::new).collect(Collectors.toList());
    }

    public DataStorageMetrics persistentStoreMetrics() {
        return null;
    }

    @Nullable
    public DataRegionMetrics memoryMetrics(String dataRegionName) {
        DataRegion dataRegion = this.dataRegionMap.get(dataRegionName);
        return dataRegion == null ? null : new DataRegionMetricsSnapshot(dataRegion.metrics());
    }

    @Nullable
    public DataRegion dataRegion(@Nullable String memPlcName) throws IgniteCheckedException {
        if (memPlcName == null) {
            return this.dfltDataRegion;
        }
        if (this.dataRegionMap.isEmpty()) {
            return null;
        }
        DataRegion plc = this.dataRegionMap.get(memPlcName);
        if (plc == null) {
            throw new IgniteCheckedException("Requested DataRegion is not configured: " + memPlcName);
        }
        return plc;
    }

    public FreeList freeList(String memPlcName) {
        if (memPlcName == null) {
            return this.dfltFreeList;
        }
        return this.freeListMap != null ? (FreeList)this.freeListMap.get(memPlcName) : null;
    }

    public ReuseList reuseList(String memPlcName) {
        if (memPlcName == null) {
            return this.dfltFreeList;
        }
        return this.freeListMap != null ? (ReuseList)this.freeListMap.get(memPlcName) : null;
    }

    @Override
    protected void stop0(boolean cancel) {
        this.onDeActivate(true);
    }

    @Override
    public boolean checkpointLockIsHeldByThread() {
        return true;
    }

    public void checkpointReadLock() {
    }

    public void checkpointReadUnlock() {
    }

    public long checkpointReadLockTimeout() {
        return 0L;
    }

    public void checkpointReadLockTimeout(long val) {
    }

    public void cleanupRestoredCaches() {
    }

    public void cleanupCheckpointDirectory() throws IgniteCheckedException {
    }

    public void cleanupTempCheckpointDirectory() throws IgniteCheckedException {
    }

    @Nullable
    public IgniteInternalFuture wakeupForCheckpoint(String reason) {
        return null;
    }

    @Nullable
    public WALPointer lastCheckpointMarkWalPointer() {
        return null;
    }

    @Nullable
    public CheckpointProgress forceCheckpoint(String reason) {
        return null;
    }

    @Nullable
    public <R> CheckpointProgress forceNewCheckpoint(String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        return null;
    }

    public void waitForCheckpoint(String reason) throws IgniteCheckedException {
        this.waitForCheckpoint(reason, null);
    }

    public <R> void waitForCheckpoint(String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) throws IgniteCheckedException {
    }

    public void beforeExchange(GridDhtPartitionsExchangeFuture discoEvt) throws IgniteCheckedException {
    }

    public void startMemoryRestore(GridKernalContext kctx, TimeBag startTimer) throws IgniteCheckedException {
    }

    public void onStateRestored(AffinityTopologyVersion topVer) throws IgniteCheckedException {
    }

    public void rebuildIndexesIfNeeded(GridDhtPartitionsExchangeFuture fut) {
    }

    public Collection<GridCacheContext> forceRebuildIndexes(Collection<GridCacheContext> contexts) {
        return Collections.emptyList();
    }

    public void prepareCachesStop() {
    }

    public void onCacheGroupsStopped(Collection<IgniteBiTuple<CacheGroupContext, Boolean>> stoppedGrps) {
    }

    public Map<Integer, Map<Integer, Long>> reserveHistoryForExchange() {
        return Collections.emptyMap();
    }

    public void releaseHistoryForExchange() {
    }

    public boolean reserveHistoryForPreloading(Map<T2<Integer, Integer>, Long> reservationMap) {
        return false;
    }

    public void releaseHistoryForPreloading() {
    }

    public WALPointer latestWalPointerReservedForPreloading() {
        return null;
    }

    public void ensureFreeSpaceForInsert(DataRegion region, int dataRowSize) throws IgniteOutOfMemoryException {
        boolean oomThreshold;
        if (region == null) {
            return;
        }
        DataRegionConfiguration regCfg = region.config();
        if (regCfg.getPageEvictionMode() != DataPageEvictionMode.DISABLED || regCfg.isPersistenceEnabled()) {
            return;
        }
        long memorySize = regCfg.getMaxSize();
        PageMemory pageMem = region.pageMemory();
        CacheFreeList freeList = this.freeListMap.get(regCfg.getName());
        long nonEmptyPages = pageMem.loadedPages() - (long)freeList.emptyDataPages();
        boolean bl = oomThreshold = (double)(memorySize / (long)pageMem.systemPageSize()) < (double)dataRowSize / (double)pageMem.pageSize() + (double)nonEmptyPages * (12.0 / (double)pageMem.pageSize() + 1.0) + 256.0;
        if (oomThreshold) {
            IgniteOutOfMemoryException oom = new IgniteOutOfMemoryException("Out of memory in data region [name=" + regCfg.getName() + ", initSize=" + U.readableSize(regCfg.getInitialSize(), false) + ", maxSize=" + U.readableSize(regCfg.getMaxSize(), false) + ", persistenceEnabled=" + regCfg.isPersistenceEnabled() + "] Try the following:" + U.nl() + "  ^-- Increase maximum off-heap memory size (DataRegionConfiguration.maxSize)" + U.nl() + "  ^-- Enable Ignite persistence (DataRegionConfiguration.persistenceEnabled)" + U.nl() + "  ^-- Enable eviction or expiration policies");
            if (this.cctx.kernalContext() != null) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, oom));
            }
            throw oom;
        }
    }

    public void ensureFreeSpace(DataRegion memPlc) throws IgniteCheckedException {
        if (memPlc == null) {
            return;
        }
        while (memPlc.evictionTracker().evictionRequired()) {
            this.warnFirstEvict(memPlc.config());
            memPlc.evictionTracker().evictDataPage();
            memPlc.metrics().updateEvictionRate();
        }
    }

    private DataRegion initMemory(DataStorageConfiguration memCfg, DataRegionConfiguration plcCfg, DataRegionMetricsImpl memMetrics, boolean trackable, PageReadWriteManager pmPageMgr) throws IgniteCheckedException {
        PageMemory pageMem = this.createPageMemory(this.createOrReuseMemoryProvider(plcCfg), memCfg, plcCfg, memMetrics, trackable, pmPageMgr);
        return new DataRegion(pageMem, plcCfg, memMetrics, this.createPageEvictionTracker(plcCfg, pageMem));
    }

    private DirectMemoryProvider createOrReuseMemoryProvider(DataRegionConfiguration plcCfg) throws IgniteCheckedException {
        if (!this.supportsMemoryReuse(plcCfg)) {
            return this.createMemoryProvider(plcCfg);
        }
        DirectMemoryProvider memProvider = this.memProviderMap.get(plcCfg.getName());
        if (memProvider == null) {
            memProvider = this.createMemoryProvider(plcCfg);
            this.memProviderMap.put(plcCfg.getName(), memProvider);
        }
        return memProvider;
    }

    public boolean supportsMemoryReuse(DataRegionConfiguration plcCfg) {
        return this.reuseMemory && plcCfg.getSwapPath() == null;
    }

    private DirectMemoryProvider createMemoryProvider(DataRegionConfiguration plcCfg) throws IgniteCheckedException {
        File allocPath = this.buildAllocPath(plcCfg);
        return allocPath == null ? new UnsafeMemoryProvider(this.log) : new MappedFileMemoryProvider(this.log, allocPath);
    }

    protected PageEvictionTracker createPageEvictionTracker(DataRegionConfiguration plc, PageMemory pageMem) {
        if (plc.getPageEvictionMode() == DataPageEvictionMode.DISABLED || plc.isPersistenceEnabled()) {
            return new NoOpPageEvictionTracker();
        }
        assert (pageMem instanceof PageMemoryNoStoreImpl) : pageMem.getClass();
        PageMemoryNoStoreImpl pageMem0 = (PageMemoryNoStoreImpl)pageMem;
        if (Boolean.getBoolean("override.fair.fifo.page.eviction.tracker")) {
            return new FairFifoPageEvictionTracker(pageMem0, plc, this.cctx);
        }
        switch (plc.getPageEvictionMode()) {
            case RANDOM_LRU: {
                return new RandomLruPageEvictionTracker((PageMemory)pageMem0, plc, this.cctx);
            }
            case RANDOM_2_LRU: {
                return new Random2LruPageEvictionTracker(pageMem0, plc, this.cctx);
            }
        }
        return new NoOpPageEvictionTracker();
    }

    @Nullable
    protected File buildAllocPath(DataRegionConfiguration plc) throws IgniteCheckedException {
        String path = plc.getSwapPath();
        if (path == null) {
            return null;
        }
        PdsFolderSettings<GridCacheDatabaseSharedManager.NodeFileLockHolder> folderSettings = this.cctx.kernalContext().pdsFolderResolver().resolveFolders();
        String folderName = folderSettings.isCompatible() ? String.valueOf(folderSettings.consistentId()).replaceAll("[:,\\.]", "_") : folderSettings.folderName();
        return this.buildPath(path, folderName);
    }

    protected PageMemory createPageMemory(DirectMemoryProvider memProvider, DataStorageConfiguration memCfg, DataRegionConfiguration memPlcCfg, DataRegionMetricsImpl memMetrics, boolean trackable, PageReadWriteManager pmPageMgr) {
        memMetrics.persistenceEnabled(false);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(this.cctx, this.wrapMetricsMemoryProvider(memProvider, memMetrics), memCfg.getPageSize(), memPlcCfg, memMetrics);
        memMetrics.pageMemory(pageMem);
        return pageMem;
    }

    private DirectMemoryProvider wrapMetricsMemoryProvider(final DirectMemoryProvider memoryProvider0, final DataRegionMetricsImpl memMetrics) {
        return new DirectMemoryProvider(){
            private final DirectMemoryProvider memProvider;
            {
                this.memProvider = memoryProvider0;
            }

            @Override
            public void initialize(long[] chunkSizes) {
                this.memProvider.initialize(chunkSizes);
            }

            @Override
            public void shutdown(boolean deallocate) {
                this.memProvider.shutdown(deallocate);
            }

            @Override
            public DirectMemoryRegion nextRegion() {
                DirectMemoryRegion nextMemoryRegion = this.memProvider.nextRegion();
                if (nextMemoryRegion == null) {
                    return null;
                }
                memMetrics.updateOffHeapSize(nextMemoryRegion.size());
                return nextMemoryRegion;
            }
        };
    }

    protected File buildPath(String path, String consId) throws IgniteCheckedException {
        String igniteHomeStr = U.getIgniteHome();
        File workDir = igniteHomeStr == null ? new File(path) : U.resolveWorkDirectory(igniteHomeStr, path, false);
        return new File(workDir, consId);
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (kctx.clientNode() && kctx.config().getDataStorageConfiguration() == null) {
            return;
        }
        this.initAndStartRegions(kctx.config().getDataStorageConfiguration());
        for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(kctx)) {
            lsnr.afterInitialise(this);
        }
    }

    protected void initAndStartRegions(DataStorageConfiguration cfg) throws IgniteCheckedException {
        assert (cfg != null);
        this.initDataRegions(cfg);
        this.startDataRegions(cfg);
    }

    private void startDataRegions(DataStorageConfiguration cfg) throws IgniteCheckedException {
        if (this.dataRegionsStarted) {
            return;
        }
        assert (cfg != null);
        this.registerMetricsMBeans(this.cctx.gridConfig());
        this.startDataRegions();
        this.initPageMemoryDataStructures(cfg);
        this.dataRegionsStarted = true;
        if (this.log.isQuiet()) {
            U.quiet(false, "Data Regions Started: " + this.dataRegionMap.size());
            U.quietMultipleLines(false, IgniteKernal.dataStorageReport(this, false));
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Data Regions Started: " + this.dataRegionMap.size());
            this.log.info(IgniteKernal.dataStorageReport(this, false));
        }
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        this.onDeActivate(!this.reuseMemory);
    }

    private void onDeActivate(boolean shutdown) {
        if (this.freeListMap != null) {
            this.freeListMap.values().forEach(DataStructure::close);
        }
        for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
            lsnr.beforeStop(this);
        }
        for (DataRegion region : this.dataRegionMap.values()) {
            region.pageMemory().stop(shutdown);
            region.evictionTracker().stop();
            this.unregisterMetricsMBean(this.cctx.gridConfig(), MBEAN_GROUP_NAME, region.metrics().getName());
            region.metrics().remove();
        }
        this.dataRegionMap.clear();
        if (shutdown && this.memProviderMap != null) {
            this.memProviderMap.clear();
        }
        this.dataRegionsInitialized = false;
        this.dataRegionsStarted = false;
    }

    public String systemDateRegionName() {
        return SYSTEM_DATA_REGION_NAME;
    }

    protected void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public MetaStorage metaStorage() {
        return null;
    }

    public void notifyMetaStorageSubscribersOnReadyForRead() throws IgniteCheckedException {
    }

    public boolean walEnabled(int grpId, boolean local) {
        return false;
    }

    public void walEnabled(int grpId, boolean enabled, boolean local) {
    }

    public void lastCheckpointInapplicableForWalRebalance(int grpId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warnFirstEvict(DataRegionConfiguration regCfg) {
        if (this.firstEvictWarn) {
            return;
        }
        IgniteCacheDatabaseSharedManager igniteCacheDatabaseSharedManager = this;
        synchronized (igniteCacheDatabaseSharedManager) {
            if (this.firstEvictWarn) {
                return;
            }
            this.firstEvictWarn = true;
        }
        U.warn(this.log, "Page-based evictions started. Consider increasing 'maxSize' on Data Region configuration: " + regCfg.getName());
    }

    private void checkExistenceWarmUpConfiguration(@Nullable WarmUpConfiguration warmUpCfg, Map<Class<? extends WarmUpConfiguration>, WarmUpStrategy> warmUpStrategies, IgniteClosure<WarmUpConfiguration, String> errMsgSupplier) throws IgniteCheckedException {
        if (Objects.nonNull(warmUpCfg) && !warmUpStrategies.containsKey(warmUpCfg.getClass())) {
            throw new IgniteCheckedException(errMsgSupplier.apply(warmUpCfg));
        }
    }

    private void checkRegionWarmUpConfiguration(DataRegionConfiguration regCfg, Map<Class<? extends WarmUpConfiguration>, WarmUpStrategy> warmUpStrategies) throws IgniteCheckedException {
        WarmUpConfiguration warmUpCfg = regCfg.getWarmUpConfiguration();
        if (Objects.isNull(warmUpCfg)) {
            return;
        }
        Supplier<String> errPostfix = () -> "[name=" + regCfg.getName() + ", warmUpConfig=" + warmUpCfg + ']';
        if (!regCfg.isPersistenceEnabled()) {
            throw new IgniteCheckedException("Warm-up setting is not expected for a non-persistent data region: " + errPostfix.get());
        }
        this.checkExistenceWarmUpConfiguration(regCfg.getWarmUpConfiguration(), warmUpStrategies, warmUpConfig -> "Unknown data region warm-up configuration: " + (String)errPostfix.get());
    }
}

