/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.CorruptedPersistenceException;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTreeRuntimeException;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCorruptedPersistenceException
extends IgniteCheckedException
implements CorruptedPersistenceException {
    protected final T2<Integer, Long>[] pages;

    protected AbstractCorruptedPersistenceException(String msg, @Nullable Throwable cause, T2<Integer, Long>[] pages) {
        super(msg, cause);
        this.pages = this.expandPagesArray(pages, cause);
    }

    protected static T2<Integer, Long>[] toPagesArray(int grpId, long[] pageIds) {
        T2[] res = new T2[pageIds.length];
        for (int i = 0; i < pageIds.length; ++i) {
            res[i] = new T2<Integer, Long>(grpId, pageIds[i]);
        }
        return res;
    }

    protected T2<Integer, Long>[] expandPagesArray(T2<Integer, Long>[] pages, Throwable cause) {
        HashSet<T2<Integer, Long>> res = new HashSet<T2<Integer, Long>>(Arrays.asList(pages));
        BPlusTreeRuntimeException treeRuntimeException = X.cause(cause, BPlusTreeRuntimeException.class);
        if (treeRuntimeException != null) {
            res.addAll(treeRuntimeException.pages());
        }
        Set<T2<Integer, Long>> partMetaPages = this.partitionMetaPages(res);
        res.addAll(partMetaPages);
        return res.toArray(new T2[0]);
    }

    protected Set<T2<Integer, Long>> partitionMetaPages(Set<T2<Integer, Long>> pages) {
        return pages.stream().map(page -> {
            int grpId = (Integer)page.get1();
            int partId = PageIdUtils.partId((Long)page.get2());
            long partMetaPageId = PageIdUtils.pageId(partId, (byte)1, 0);
            return new T2<Integer, Long>(grpId, partMetaPageId);
        }).collect(Collectors.toSet());
    }

    @Override
    public T2<Integer, Long>[] pages() {
        return this.pages;
    }
}

