/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridLocalCacheEntry
extends GridCacheMapEntry {
    GridLocalCacheEntry(GridCacheContext ctx, KeyCacheObject key) {
        super(ctx, key);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    GridCacheMvccCandidate addLocal(long threadId, GridCacheVersion ver, @Nullable GridCacheVersion serOrder, @Nullable GridCacheVersion serReadVer, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) throws GridCacheEntryRemovedException {
        CacheObject val;
        GridCacheMvccCandidate cand;
        CacheLockCandidates prev;
        assert (serReadVer == null || serOrder != null);
        CacheLockCandidates owner = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            if (serReadVer != null && !this.checkSerializableReadVersion(serReadVer)) {
                GridCacheMvccCandidate gridCacheMvccCandidate = null;
                return gridCacheMvccCandidate;
            }
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null) {
                mvcc = new GridCacheMvcc(this.cctx);
                this.mvccExtras(mvcc);
            }
            prev = mvcc.localOwners();
            cand = mvcc.addLocal(this, null, null, threadId, ver, timeout, serOrder, reenter, tx, implicitSingle, false, read);
            if (mvcc.isEmpty(new GridCacheVersion[0])) {
                this.mvccExtras(null);
            } else {
                owner = mvcc.localOwners();
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        if (cand != null && !cand.reentry()) {
            this.cctx.mvcc().addNext(this.cctx, cand);
        }
        this.checkOwnerChanged(prev, owner, val);
        return cand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readyLocal(GridCacheMvccCandidate cand) {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.localOwners();
                owner = mvcc.readyLocal(cand);
                if (mvcc.isEmpty(new GridCacheVersion[0])) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        this.checkOwnerChanged(prev, owner, val);
    }

    @Override
    public boolean tmLock(IgniteInternalTx tx, long timeout, @Nullable GridCacheVersion serOrder, GridCacheVersion serReadVer, boolean read) throws GridCacheEntryRemovedException {
        GridCacheMvccCandidate cand = this.addLocal(tx.threadId(), tx.xidVersion(), serOrder, serReadVer, timeout, false, true, tx.implicitSingle(), read);
        if (cand != null) {
            this.readyLocal(cand);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recheck(GridCacheVersion ver) {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                owner = mvcc.recheck();
                if (mvcc.isEmpty(new GridCacheVersion[0])) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        boolean lockedByThreadChainVer = owner != null && owner.hasCandidate(ver);
        this.checkOwnerChanged(prev, owner, val, lockedByThreadChainVer);
        return !lockedByThreadChainVer;
    }

    @Override
    protected void checkThreadChain(GridCacheMvccCandidate owner) {
        assert (!this.lockedByCurrentThread());
        assert (owner != null);
        assert (owner.owner() || owner.used()) : "Neither owner or used flags are set on ready local candidate: " + owner;
        if (owner.next() != null) {
            for (GridCacheMvccCandidate cand = owner.next(); cand != null; cand = cand.next()) {
                GridCacheContext cctx0;
                GridLocalCacheEntry e;
                assert (cand.local());
                if (!cand.used() && ((e = (GridLocalCacheEntry)(cctx0 = cand.parent().context()).cache().peekEx(cand.parent().key())) == null || e.recheck(owner.version()))) break;
            }
        }
    }

    void releaseLocal() {
        this.releaseLocal(Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLocal(long threadId) {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.localOwners();
                mvcc.releaseLocal(threadId);
                if (mvcc.isEmpty(new GridCacheVersion[0])) {
                    this.mvccExtras(null);
                } else {
                    owner = mvcc.allOwners();
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        if (prev != null) {
            for (int i = 0; i < prev.size(); ++i) {
                boolean unlocked;
                GridCacheMvccCandidate cand = prev.candidate(i);
                boolean bl = unlocked = owner == null || !owner.hasCandidate(cand.version());
                if (!unlocked) continue;
                this.checkThreadChain(cand);
            }
        }
        this.checkOwnerChanged(prev, owner, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLock(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        GridCacheVersion deferredDelVer;
        CacheObject val;
        GridCacheMvccCandidate doomed;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.lockEntry();
        try {
            GridCacheMvcc mvcc;
            GridCacheVersion obsoleteVer = this.obsoleteVersionExtras();
            if (obsoleteVer != null && !obsoleteVer.equals(ver)) {
                this.checkObsolete();
            }
            GridCacheMvccCandidate gridCacheMvccCandidate = doomed = (mvcc = this.mvccExtras()) == null ? null : mvcc.candidate(ver);
            if (doomed != null) {
                prev = mvcc.allOwners();
                mvcc.remove(ver);
                if (mvcc.isEmpty(new GridCacheVersion[0])) {
                    this.mvccExtras(null);
                } else {
                    owner = mvcc.allOwners();
                }
            }
            val = this.val;
            deferredDelVer = this.ver;
        }
        finally {
            this.unlockEntry();
        }
        if (val == null) {
            boolean deferred;
            boolean bl = deferred = this.cctx.deferredDelete() && !this.detached() && !this.isInternal();
            if (deferred && deferredDelVer != null) {
                this.cctx.onDeferredDelete(this, deferredDelVer);
            }
        }
        if (doomed != null) {
            this.checkThreadChain(doomed);
        }
        this.checkOwnerChanged(prev, owner, val);
        return doomed != null;
    }

    @Override
    public String toString() {
        return this.toStringWithTryLock(() -> S.toString(GridLocalCacheEntry.class, this, super.toString()));
    }
}

