/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDistributedGetFutureAdapter<K, V>
extends GridCacheCompoundIdentityFuture<Map<K, V>>
implements CacheGetFuture {
    protected static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    protected static IgniteLogger log;
    public static final int DFLT_MAX_REMAP_CNT = 3;
    protected static final int MAX_REMAP_CNT;
    protected static final AtomicIntegerFieldUpdater<CacheDistributedGetFutureAdapter> REMAP_CNT_UPD;
    protected final GridCacheContext<K, V> cctx;
    protected Collection<KeyCacheObject> keys;
    protected boolean readThrough;
    protected boolean forcePrimary;
    protected IgniteUuid futId;
    protected boolean trackable;
    protected volatile int remapCnt;
    protected String taskName;
    protected boolean deserializeBinary;
    protected boolean skipVals;
    protected IgniteCacheExpiryPolicy expiryPlc;
    protected boolean canRemap = true;
    protected final boolean needVer;
    protected final boolean keepCacheObjects;
    protected final boolean recovery;
    @GridToStringExclude
    protected final IgniteUuid deploymentLdrId;
    protected Map<AffinityTopologyVersion, Map<Integer, Set<ClusterNode>>> invalidNodes = Collections.emptyMap();

    protected CacheDistributedGetFutureAdapter(GridCacheContext<K, V> cctx, Collection<KeyCacheObject> keys, boolean readThrough, boolean forcePrimary, String taskName, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, boolean recovery) {
        super(CU.mapsReducer(keys.size()));
        assert (!F.isEmpty(keys));
        this.cctx = cctx;
        this.keys = keys;
        this.readThrough = readThrough;
        this.forcePrimary = forcePrimary;
        this.taskName = taskName;
        this.deserializeBinary = deserializeBinary;
        this.expiryPlc = expiryPlc;
        this.skipVals = skipVals;
        this.needVer = needVer;
        this.keepCacheObjects = keepCacheObjects;
        this.recovery = recovery;
        this.deploymentLdrId = U.contextDeploymentClassLoaderId(cctx.kernalContext());
        this.futId = IgniteUuid.randomUuid();
    }

    protected void initLogger(Class<?> aclass) {
        if (log == null) {
            log = U.logger(this.cctx.kernalContext(), logRef, aclass);
        }
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    protected final boolean partitionOwned(int part) {
        return this.cctx.topology().partitionState(this.cctx.localNodeId(), part) == GridDhtPartitionState.OWNING;
    }

    protected void registrateFutureInMvccManager(GridCacheFuture<?> fut) {
        if (!this.trackable) {
            this.trackable = true;
            this.cctx.mvcc().addFuture(fut, this.futId);
        }
    }

    protected synchronized void addNodeAsInvalid(ClusterNode node, int part, AffinityTopologyVersion topVer) {
        Set<ClusterNode> invalidNodeSet;
        Map<Integer, Set<ClusterNode>> invalidNodeMap;
        if (this.invalidNodes == Collections.emptyMap()) {
            this.invalidNodes = new HashMap<AffinityTopologyVersion, Map<Integer, Set<ClusterNode>>>();
        }
        if ((invalidNodeMap = this.invalidNodes.get(topVer)) == null) {
            invalidNodeMap = new HashMap<Integer, Set<ClusterNode>>();
            this.invalidNodes.put(topVer, invalidNodeMap);
        }
        if ((invalidNodeSet = invalidNodeMap.get(part)) == null) {
            invalidNodeSet = new HashSet<ClusterNode>();
            invalidNodeMap.put(part, invalidNodeSet);
        }
        invalidNodeSet.add(node);
    }

    protected synchronized Set<ClusterNode> getInvalidNodes(int part, AffinityTopologyVersion topVer) {
        Set<ClusterNode> nodes;
        Set<ClusterNode> invalidNodeSet = Collections.emptySet();
        Map<Integer, Set<ClusterNode>> invalidNodesMap = this.invalidNodes.get(topVer);
        if (invalidNodesMap != null && (nodes = invalidNodesMap.get(part)) != null) {
            invalidNodeSet = nodes;
        }
        return invalidNodeSet;
    }

    protected boolean checkRetryPermits(KeyCacheObject key, ClusterNode node, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> missedNodesToKeysMapping) {
        LinkedHashMap<KeyCacheObject, Boolean> keys = missedNodesToKeysMapping.get(node);
        if (keys != null && keys.containsKey(key) && REMAP_CNT_UPD.incrementAndGet(this) > MAX_REMAP_CNT) {
            this.onDone(new ClusterTopologyCheckedException("Failed to remap key to a new node after " + MAX_REMAP_CNT + " attempts (key got remapped to the same node) [key=" + key + ", node=" + U.toShortString(node) + ", mappings=" + missedNodesToKeysMapping + ']'));
            return false;
        }
        return true;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            AbstractMiniFuture f;
            if (!this.isMini(fut) || !(f = (AbstractMiniFuture)fut).node().id().equals(nodeId)) continue;
            found = true;
            f.onNodeLeft(new ClusterTopologyCheckedException("Remote node left grid (will retry): " + nodeId));
        }
        return found;
    }

    @Override
    public void onResult(UUID nodeId, GridNearGetResponse res) {
        for (IgniteInternalFuture fut : this.futures()) {
            AbstractMiniFuture f;
            if (!this.isMini(fut) || !(f = (AbstractMiniFuture)fut).futureId().equals(res.miniId())) continue;
            assert (f.node().id().equals(nodeId));
            f.onResult(res);
        }
    }

    protected final ClusterTopologyServerNotFoundException serverNotFoundError(int part, AffinityTopologyVersion topVer) {
        return new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topVer + ", part" + part + ", cache=" + this.cctx.name() + ", localNodeId=" + this.cctx.localNodeId() + ']');
    }

    protected abstract boolean isMini(IgniteInternalFuture<?> var1);

    protected abstract void map(Collection<KeyCacheObject> var1, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> var2, AffinityTopologyVersion var3);

    @Override
    public String toString() {
        Collection futuresStrings = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (CacheDistributedGetFutureAdapter.this.isMini(f)) {
                    AbstractMiniFuture mini = (AbstractMiniFuture)f;
                    return "miniFuture([futId=" + mini.futureId() + ", node=" + mini.node().id() + ", loc=" + mini.node().isLocal() + ", done=" + f.isDone() + "])";
                }
                return f.getClass().getSimpleName() + " [loc=true, done=" + f.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(CacheDistributedGetFutureAdapter.class, this, "innerFuts", futuresStrings, "super", (Object)super.toString());
    }

    static {
        MAX_REMAP_CNT = IgniteSystemProperties.getInteger("IGNITE_NEAR_GET_MAX_REMAPS", 3);
        REMAP_CNT_UPD = AtomicIntegerFieldUpdater.newUpdater(CacheDistributedGetFutureAdapter.class, "remapCnt");
    }

    protected abstract class AbstractMiniFuture
    extends GridFutureAdapter<Map<K, V>> {
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        protected final ClusterNode node;
        @GridToStringInclude
        protected final LinkedHashMap<KeyCacheObject, Boolean> keys;
        protected final AffinityTopologyVersion topVer;
        private final IgniteInClosure<Collection<GridCacheEntryInfo>> postProcessingClos;
        private boolean remapped;

        protected AbstractMiniFuture(ClusterNode node, LinkedHashMap<KeyCacheObject, Boolean> keys, AffinityTopologyVersion topVer) {
            this.node = node;
            this.keys = keys;
            this.topVer = topVer;
            this.postProcessingClos = CU.createBackupPostProcessingClosure(topVer, log, CacheDistributedGetFutureAdapter.this.cctx, null, CacheDistributedGetFutureAdapter.this.expiryPlc, CacheDistributedGetFutureAdapter.this.readThrough && CacheDistributedGetFutureAdapter.this.cctx.readThroughConfigured(), CacheDistributedGetFutureAdapter.this.skipVals);
        }

        public IgniteUuid futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.node;
        }

        public Collection<KeyCacheObject> keys() {
            return this.keys.keySet();
        }

        public GridNearGetRequest createGetRequest(IgniteUuid rootFutId) {
            return this.createGetRequest0(rootFutId, this.futureId());
        }

        protected abstract GridNearGetRequest createGetRequest0(IgniteUuid var1, IgniteUuid var2);

        protected abstract Map<K, V> createResultMap(Collection<GridCacheEntryInfo> var1);

        public void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        public synchronized void onNodeLeft(ClusterTopologyCheckedException e) {
            if (this.remapped) {
                return;
            }
            this.remapped = true;
            if (log.isDebugEnabled()) {
                log.debug("Remote node left grid while sending or waiting for reply (will retry): " + this);
            }
            if (!CacheDistributedGetFutureAdapter.this.canRemap) {
                CacheDistributedGetFutureAdapter.this.map(this.keys.keySet(), F.t(this.node, this.keys), this.topVer);
                this.onDone(Collections.emptyMap());
            } else {
                long maxTopVer = Math.max(this.topVer.topologyVersion() + 1L, CacheDistributedGetFutureAdapter.this.cctx.discovery().topologyVersion());
                AffinityTopologyVersion awaitTopVer = new AffinityTopologyVersion(maxTopVer);
                CacheDistributedGetFutureAdapter.this.cctx.shared().exchange().affinityReadyFuture(awaitTopVer).listen(f -> {
                    try {
                        CacheDistributedGetFutureAdapter.this.map(this.keys.keySet(), F.t(this.node, this.keys), (AffinityTopologyVersion)f.get());
                        this.onDone(Collections.emptyMap());
                    }
                    catch (IgniteCheckedException ex) {
                        CacheDistributedGetFutureAdapter.this.onDone(ex);
                    }
                });
            }
        }

        public void onResult(final GridNearGetResponse res) {
            if (res.error() != null) {
                this.onDone(res.error());
                return;
            }
            final Collection<Integer> invalidParts = res.invalidPartitions();
            if (!F.isEmpty(invalidParts)) {
                AffinityTopologyVersion rmtTopVer = res.topologyVersion();
                for (Integer part : invalidParts) {
                    CacheDistributedGetFutureAdapter.this.addNodeAsInvalid(this.node, part, this.topVer);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Remapping mini get future [invalidParts=" + invalidParts + ", fut=" + this + ']');
                }
                if (!CacheDistributedGetFutureAdapter.this.canRemap) {
                    CacheDistributedGetFutureAdapter.this.map(F.view(this.keys.keySet(), new P1<KeyCacheObject>(){

                        @Override
                        public boolean apply(KeyCacheObject key) {
                            return invalidParts.contains(CacheDistributedGetFutureAdapter.this.cctx.affinity().partition(key));
                        }
                    }), F.t(this.node, this.keys), this.topVer);
                    this.postProcessResult(res);
                    this.onDone(this.createResultMap(res.entries()));
                    return;
                }
                CacheDistributedGetFutureAdapter.this.cctx.shared().exchange().affinityReadyFuture(rmtTopVer).listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CIX1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void applyx(IgniteInternalFuture<AffinityTopologyVersion> fut) throws IgniteCheckedException {
                        AffinityTopologyVersion topVer = fut.get();
                        CacheDistributedGetFutureAdapter.this.map(F.view(AbstractMiniFuture.this.keys.keySet(), new P1<KeyCacheObject>(){

                            @Override
                            public boolean apply(KeyCacheObject key) {
                                return invalidParts.contains(CacheDistributedGetFutureAdapter.this.cctx.affinity().partition(key));
                            }
                        }), F.t(AbstractMiniFuture.this.node, AbstractMiniFuture.this.keys), topVer);
                        AbstractMiniFuture.this.postProcessResult(res);
                        AbstractMiniFuture.this.onDone(AbstractMiniFuture.this.createResultMap(res.entries()));
                    }
                });
            } else {
                try {
                    this.postProcessResult(res);
                    this.onDone(this.createResultMap(res.entries()));
                }
                catch (Exception e) {
                    this.onDone(e);
                }
            }
        }

        protected void postProcessResult(GridNearGetResponse res) {
            if (this.postProcessingClos != null) {
                this.postProcessingClos.apply(res.entries());
            }
        }

        @Override
        public String toString() {
            return S.toString(AbstractMiniFuture.class, this);
        }
    }
}

