/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;

public class CacheConfigurationOverride {
    private CacheMode mode;
    private Integer backups;
    private String cacheGroup;
    private String dataRegion;
    private CacheWriteSynchronizationMode writeSync;

    public CacheMode mode() {
        return this.mode;
    }

    public CacheConfigurationOverride mode(CacheMode mode) {
        this.mode = mode;
        return this;
    }

    public Integer backups() {
        return this.backups;
    }

    public CacheConfigurationOverride backups(Integer backups) {
        this.backups = backups;
        return this;
    }

    public String cacheGroup() {
        return this.cacheGroup;
    }

    public CacheConfigurationOverride cacheGroup(String grpName) {
        this.cacheGroup = grpName;
        return this;
    }

    public String dataRegion() {
        return this.dataRegion;
    }

    public CacheConfigurationOverride dataRegion(String dataRegName) {
        this.dataRegion = dataRegName;
        return this;
    }

    public CacheWriteSynchronizationMode writeSynchronizationMode() {
        return this.writeSync;
    }

    public CacheConfigurationOverride writeSynchronizationMode(CacheWriteSynchronizationMode writeSync) {
        this.writeSync = writeSync;
        return this;
    }

    public CacheConfiguration apply(CacheConfiguration ccfg) {
        assert (ccfg != null);
        if (this.mode != null) {
            ccfg.setCacheMode(this.mode);
        }
        if (this.backups != null) {
            ccfg.setBackups(this.backups);
        }
        if (this.cacheGroup != null) {
            ccfg.setGroupName(this.cacheGroup);
        }
        if (this.dataRegion != null) {
            ccfg.setDataRegionName(this.dataRegion);
        }
        if (this.writeSync != null) {
            ccfg.setWriteSynchronizationMode(this.writeSync);
        }
        return ccfg;
    }

    public boolean isEmpty() {
        return this.mode == null && this.backups == null && this.cacheGroup == null && this.dataRegion == null && this.writeSync == null;
    }
}

