/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DoubleIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class DoubleInlineIndexKeyType
extends NullableInlineIndexKeyType<DoubleIndexKey> {
    public DoubleInlineIndexKeyType() {
        super(7, (short)8);
    }

    @Override
    public int compare0(long pageAddr, int off, DoubleIndexKey v) {
        double val1 = Double.longBitsToDouble(PageUtils.getLong(pageAddr, off + 1));
        return Integer.signum(Double.compare(val1, (Double)v.key()));
    }

    @Override
    protected int put0(long pageAddr, int off, DoubleIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        PageUtils.putLong(pageAddr, off + 1, Double.doubleToLongBits((Double)key.key()));
        return this.keySize + 1;
    }

    @Override
    protected DoubleIndexKey get0(long pageAddr, int off) {
        double key = Double.longBitsToDouble(PageUtils.getLong(pageAddr, off + 1));
        return new DoubleIndexKey(key);
    }

    @Override
    protected int inlineSize0(DoubleIndexKey val) {
        return this.keySize + 1;
    }
}

