/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.BooleanIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class BooleanInlineIndexKeyType
extends NullableInlineIndexKeyType<BooleanIndexKey> {
    public BooleanInlineIndexKeyType() {
        super(1, (short)1);
    }

    @Override
    protected int put0(long pageAddr, int off, BooleanIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        PageUtils.putByte(pageAddr, off + 1, (byte)((Boolean)key.key() != false ? 1 : 0));
        return this.keySize + 1;
    }

    @Override
    protected BooleanIndexKey get0(long pageAddr, int off) {
        boolean key = PageUtils.getByte(pageAddr, off + 1) != 0;
        return new BooleanIndexKey(key);
    }

    @Override
    public int compare0(long pageAddr, int off, BooleanIndexKey key) {
        boolean bool1 = PageUtils.getByte(pageAddr, off + 1) != 0;
        return Integer.signum(Boolean.compare(bool1, (Boolean)key.key()));
    }

    @Override
    protected int inlineSize0(BooleanIndexKey key) {
        return this.keySize + 1;
    }
}

