/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.cache.query.index.Order;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IndexKeyDefinition
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private int idxType;
    private Order order;
    private int precision;

    public IndexKeyDefinition() {
    }

    public IndexKeyDefinition(int idxType, Order order, long precision) {
        this.idxType = idxType;
        this.order = order;
        this.precision = precision >= Integer.MAX_VALUE ? -1 : (int)precision;
    }

    public Order order() {
        return this.order;
    }

    public int idxType() {
        return this.idxType;
    }

    public int precision() {
        return this.precision;
    }

    public boolean validate(IndexKey key) {
        if (key == NullIndexKey.INSTANCE) {
            return true;
        }
        return this.idxType == key.type();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.idxType);
        U.writeEnum(out, this.order.sortOrder());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.idxType = in.readInt();
        this.order = new Order(U.readEnum(in, SortOrder.class), null);
    }
}

