/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cdc;

import java.net.URL;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cdc.CdcConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.cdc.CdcMain;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class CdcLoader {
    public static CdcMain loadCdc(String springXmlPath) throws IgniteCheckedException {
        URL cfgUrl = U.resolveSpringUrl(springXmlPath);
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgTuple = spring.loadConfigurations(cfgUrl, new String[0]);
        if (cfgTuple.get1().size() > 1) {
            throw new IgniteCheckedException("Exact 1 IgniteConfiguration should be defined. Found " + cfgTuple.get1().size());
        }
        IgniteBiTuple<Collection<CdcConfiguration>, GridSpringResourceContext> cdcCfgs = spring.loadConfigurations(cfgUrl, CdcConfiguration.class, new String[0]);
        if (cdcCfgs.get1().size() > 1) {
            throw new IgniteCheckedException("Exact 1 CaptureDataChangeConfiguration configuration should be defined. Found " + cdcCfgs.get1().size());
        }
        return new CdcMain(cfgTuple.get1().iterator().next(), cfgTuple.get2(), cdcCfgs.get1().iterator().next());
    }
}

