/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.metric.opencensus;

import io.opencensus.common.Scope;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.Measure;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.stats.View;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagMetadata;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tags;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metric.PushMetricsExporterAdapter;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.metric.BooleanMetric;
import org.apache.ignite.spi.metric.DoubleMetric;
import org.apache.ignite.spi.metric.HistogramMetric;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.ObjectMetric;
import org.jetbrains.annotations.Nullable;

public class OpenCensusMetricExporterSpi
extends PushMetricsExporterAdapter {
    private boolean sendInstanceName;
    private boolean sendNodeId;
    private boolean sendConsistentId;
    public static final TagKey INSTANCE_NAME_TAG = TagKey.create((String)"iin");
    public static final TagKey NODE_ID_TAG = TagKey.create((String)"ini");
    public static final TagKey CONSISTENT_ID_TAG = TagKey.create((String)"inci");
    public static final TagMetadata METADATA = TagMetadata.create((TagMetadata.TagTtl)TagMetadata.TagTtl.UNLIMITED_PROPAGATION);
    private TagValue instanceNameValue;
    private TagValue nodeIdValue;
    private TagValue consistenIdValue;
    private List<TagKey> tags = new ArrayList<TagKey>();
    private Map<String, Measure> measures = new HashMap<String, Measure>();
    private final Map<String, T2<long[], String[]>> histogramNames = new HashMap<String, T2<long[], String[]>>();
    private static final Function<Metric, Measure> CREATE_LONG = m -> Measure.MeasureLong.create((String)m.name(), (String)(m.description() == null ? m.name() : m.description()), (String)"");
    private static final Function<Metric, Measure> CREATE_DOUBLE = m -> Measure.MeasureDouble.create((String)m.name(), (String)(m.description() == null ? m.name() : m.description()), (String)"");

    public void export() {
        StatsRecorder recorder = Stats.getStatsRecorder();
        try (Scope globalScope = this.tagScope();){
            MeasureMap mmap = recorder.newMeasureMap();
            this.mreg.forEach(mreg -> {
                if (this.filter != null && !this.filter.test(mreg)) {
                    return;
                }
                mreg.forEach(metric -> {
                    if (metric instanceof LongMetric || metric instanceof IntMetric || metric instanceof BooleanMetric || metric instanceof ObjectMetric && ((ObjectMetric)metric).type() == Date.class || metric instanceof ObjectMetric && ((ObjectMetric)metric).type() == OffsetDateTime.class) {
                        long val = metric instanceof LongMetric ? ((LongMetric)metric).value() : (metric instanceof IntMetric ? (long)((IntMetric)metric).value() : (metric instanceof BooleanMetric ? (((BooleanMetric)metric).value() ? 1L : 0L) : (metric instanceof ObjectMetric && ((ObjectMetric)metric).type() == Date.class ? ((Date)((ObjectMetric)metric).value()).getTime() : ((OffsetDateTime)((ObjectMetric)metric).value()).toInstant().toEpochMilli())));
                        if (val < 0L) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("OpenCensus doesn't support negative values. Skip record of " + metric.name());
                            }
                            return;
                        }
                        Measure.MeasureLong msr = (Measure.MeasureLong)this.measures.computeIfAbsent(metric.name(), k -> this.createMeasure((Metric)metric, CREATE_LONG));
                        mmap.put(msr, val);
                    } else if (metric instanceof DoubleMetric) {
                        double val = ((DoubleMetric)metric).value();
                        if (val < 0.0) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("OpenCensus doesn't support negative values. Skip record of " + metric.name());
                            }
                            return;
                        }
                        Measure.MeasureDouble msr = (Measure.MeasureDouble)this.measures.computeIfAbsent(metric.name(), k -> this.createMeasure((Metric)metric, CREATE_DOUBLE));
                        mmap.put(msr, val);
                    } else if (metric instanceof HistogramMetric) {
                        String[] names = this.histogramBucketNames((HistogramMetric)metric);
                        long[] vals = (long[])((HistogramMetric)metric).value();
                        assert (names.length == vals.length);
                        for (int i = 0; i < vals.length; ++i) {
                            String name = names[i];
                            Measure.MeasureLong msr = (Measure.MeasureLong)this.measures.computeIfAbsent(name, k -> this.createMeasureLong(name, metric.description()));
                            mmap.put(msr, vals[i]);
                        }
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug(metric.name() + "[" + metric.getClass() + "] not supported by Opencensus exporter");
                    }
                });
            });
            mmap.record();
        }
    }

    private Scope tagScope() {
        TagContextBuilder builder = Tags.getTagger().currentBuilder();
        if (this.sendInstanceName) {
            builder.put(INSTANCE_NAME_TAG, this.instanceNameValue, METADATA);
        }
        if (this.sendNodeId) {
            builder.put(NODE_ID_TAG, this.nodeIdValue, METADATA);
        }
        if (this.sendConsistentId) {
            builder.put(CONSISTENT_ID_TAG, this.consistenIdValue, METADATA);
        }
        return builder.buildScoped();
    }

    private Measure createMeasure(Metric m, Function<Metric, Measure> factory) {
        Measure msr = factory.apply(m);
        this.addView(msr);
        return msr;
    }

    private Measure.MeasureLong createMeasureLong(String name, String desc) {
        Measure.MeasureLong msr = Measure.MeasureLong.create((String)name, (String)(desc == null ? name : desc), (String)"");
        this.addView((Measure)msr);
        return msr;
    }

    private void addView(Measure msr) {
        View v = View.create((View.Name)View.Name.create((String)msr.getName()), (String)msr.getDescription(), (Measure)msr, (Aggregation)Aggregation.LastValue.create(), this.tags);
        Stats.getViewManager().registerView(v);
    }

    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        super.spiStart(igniteInstanceName);
        if (this.sendInstanceName) {
            this.tags.add(INSTANCE_NAME_TAG);
            this.instanceNameValue = TagValue.create((String)igniteInstanceName);
        }
        if (this.sendNodeId) {
            this.tags.add(NODE_ID_TAG);
            this.nodeIdValue = TagValue.create((String)((IgniteEx)this.ignite()).context().localNodeId().toString());
        }
        if (this.sendConsistentId) {
            this.tags.add(CONSISTENT_ID_TAG);
            this.consistenIdValue = TagValue.create((String)"unknown");
        }
        this.mreg.addMetricRegistryRemoveListener(mreg -> mreg.forEach(metric -> this.histogramNames.remove(metric.name())));
    }

    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        super.onContextInitialized0(spiCtx);
        this.consistenIdValue = TagValue.create((String)((IgniteEx)this.ignite()).context().discovery().localNode().consistentId().toString());
    }

    private String[] histogramBucketNames(HistogramMetric metric) {
        String name = metric.name();
        long[] bounds = metric.bounds();
        T2<long[], String[]> tuple = this.histogramNames.get(name);
        if (tuple != null && tuple.get1() == bounds) {
            return (String[])tuple.get2();
        }
        String[] names = MetricUtils.histogramBucketNames((HistogramMetric)metric);
        this.histogramNames.put(name, (T2<long[], String[]>)new T2((Object)bounds, (Object)names));
        return names;
    }

    public void setSendInstanceName(boolean sendInstanceName) {
        this.sendInstanceName = sendInstanceName;
    }

    public void setSendNodeId(boolean sendNodeId) {
        this.sendNodeId = sendNodeId;
    }

    public void setSendConsistentId(boolean sendConsistentId) {
        this.sendConsistentId = sendConsistentId;
    }
}

