/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.cache.verify.GridNotIdleException;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyUtility;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.IgniteThrowableSupplier;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.IndexIntegrityCheckIssue;
import org.apache.ignite.internal.visor.verify.IndexValidationIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeResult;
import org.apache.ignite.internal.visor.verify.ValidateIndexesContext;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.jetbrains.annotations.Nullable;

public class ValidateIndexesClosure
implements IgniteCallable<VisorValidateIndexesJobResult> {
    private static final long serialVersionUID = 0L;
    public static final String CANCELLED_MSG = "Closure of index validation was cancelled.";
    @IgniteInstanceResource
    private transient IgniteEx ignite;
    @LoggerResource
    private IgniteLogger log;
    private final Set<String> cacheNames;
    private final int checkFirst;
    private final int checkThrough;
    private final boolean checkCrc;
    private final boolean checkSizes;
    private final AtomicInteger processedPartitions = new AtomicInteger(0);
    private volatile int totalPartitions;
    private final AtomicInteger processedIndexes = new AtomicInteger(0);
    private final AtomicInteger integrityCheckedIndexes = new AtomicInteger(0);
    private final AtomicInteger processedCacheSizePartitions = new AtomicInteger(0);
    private final AtomicInteger processedIdxSizes = new AtomicInteger(0);
    private volatile int totalIndexes;
    private volatile int totalCacheGrps;
    private final AtomicLong lastProgressPrintTs = new AtomicLong(0L);
    private volatile ExecutorService calcExecutor;
    private final Set<Integer> failCalcCacheSizeGrpIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ValidateIndexesContext validateCtx;

    public ValidateIndexesClosure(ValidateIndexesContext validateCtx, Set<String> cacheNames, int checkFirst, int checkThrough, boolean checkCrc, boolean checkSizes) {
        this.validateCtx = validateCtx;
        this.cacheNames = cacheNames;
        this.checkFirst = checkFirst;
        this.checkThrough = checkThrough;
        this.checkCrc = checkCrc;
        this.checkSizes = checkSizes;
    }

    public VisorValidateIndexesJobResult call() throws Exception {
        this.calcExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            VisorValidateIndexesJobResult visorValidateIndexesJobResult = this.call0();
            return visorValidateIndexesJobResult;
        }
        finally {
            this.calcExecutor.shutdown();
        }
    }

    private Set<Integer> collectGroupIds() {
        HashSet<Integer> grpIds = new HashSet<Integer>();
        HashSet<String> missingCaches = new HashSet<String>();
        if (this.cacheNames != null) {
            for (String cacheName : this.cacheNames) {
                DynamicCacheDescriptor desc = this.ignite.context().cache().cacheDescriptor(cacheName);
                if (desc == null) {
                    missingCaches.add(cacheName);
                    continue;
                }
                if (!this.ignite.context().cache().cacheGroup(desc.groupId()).affinityNode()) continue;
                grpIds.add(desc.groupId());
            }
            if (!missingCaches.isEmpty()) {
                String errStr = "The following caches do not exist: " + String.join((CharSequence)", ", missingCaches);
                throw new IgniteException(errStr);
            }
        } else {
            Collection groups = this.ignite.context().cache().cacheGroups();
            for (CacheGroupContext grp : groups) {
                if (grp.systemCache() || grp.isLocal() || !grp.affinityNode()) continue;
                grpIds.add(grp.groupId());
            }
        }
        return grpIds;
    }

    private VisorValidateIndexesJobResult call0() {
        if (this.validateCtx.isCancelled()) {
            throw new IgniteException(CANCELLED_MSG);
        }
        Set<Integer> grpIds = this.collectGroupIds();
        Map partsWithCntrsPerGrp = IdleVerifyUtility.getUpdateCountersSnapshot((IgniteEx)this.ignite, grpIds);
        IdleVerifyUtility.IdleChecker idleChecker = new IdleVerifyUtility.IdleChecker(this.ignite, partsWithCntrsPerGrp);
        ArrayList<T2> partArgs = new ArrayList<T2>();
        ArrayList<T2> idxArgs = new ArrayList<T2>();
        this.totalCacheGrps = grpIds.size();
        Map<Integer, IndexIntegrityCheckIssue> integrityCheckResults = this.integrityCheckIndexesPartitions(grpIds, (IgniteInClosure<Integer>)idleChecker);
        GridQueryProcessor qryProcessor = this.ignite.context().query();
        IgniteH2Indexing h2Indexing = (IgniteH2Indexing)qryProcessor.getIndexing();
        for (Integer grpId : grpIds) {
            CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(grpId.intValue());
            if (Objects.isNull(grpCtx) || integrityCheckResults.containsKey(grpId)) continue;
            for (GridDhtLocalPartition part : grpCtx.topology().localPartitions()) {
                partArgs.add(new T2((Object)grpCtx, (Object)part));
            }
            for (Object ctx : grpCtx.caches()) {
                Collection types;
                String cacheName = ctx.name();
                if (this.cacheNames != null && !this.cacheNames.contains(cacheName) || F.isEmpty((Collection)(types = qryProcessor.types(cacheName)))) continue;
                for (GridQueryTypeDescriptor type : types) {
                    GridH2Table gridH2Tbl = h2Indexing.schemaManager().dataTable(cacheName, type.tableName());
                    if (Objects.isNull((Object)gridH2Tbl)) continue;
                    for (Index idx : gridH2Tbl.getIndexes()) {
                        if (!(idx instanceof H2TreeIndexBase)) continue;
                        idxArgs.add(new T2(ctx, (Object)idx));
                    }
                }
            }
        }
        Collections.shuffle(partArgs);
        Collections.shuffle(idxArgs);
        this.totalPartitions = partArgs.size();
        this.totalIndexes = idxArgs.size();
        ArrayList procPartFutures = new ArrayList(partArgs.size());
        ArrayList procIdxFutures = new ArrayList(idxArgs.size());
        ArrayList<T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>>> cacheSizeFutures = new ArrayList<T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>>>(partArgs.size());
        ArrayList<T3<GridCacheContext, Index, Future<T2<Throwable, Long>>>> idxSizeFutures = new ArrayList<T3<GridCacheContext, Index, Future<T2<Throwable, Long>>>>(idxArgs.size());
        partArgs.forEach(k -> procPartFutures.add(this.processPartitionAsync((CacheGroupContext)k.get1(), (GridDhtLocalPartition)k.get2())));
        idxArgs.forEach(k -> procIdxFutures.add(this.processIndexAsync((T2<GridCacheContext, Index>)k, (IgniteInClosure<Integer>)idleChecker)));
        if (this.checkSizes) {
            for (T2 partArg : partArgs) {
                CacheGroupContext cacheGrpCtx = (CacheGroupContext)partArg.get1();
                GridDhtLocalPartition locPart = (GridDhtLocalPartition)partArg.get2();
                cacheSizeFutures.add(new T3((Object)cacheGrpCtx, (Object)locPart, this.calcCacheSizeAsync(cacheGrpCtx, locPart)));
            }
            for (T2 idxArg : idxArgs) {
                GridCacheContext cacheCtx = (GridCacheContext)idxArg.get1();
                Index idx = (Index)idxArg.get2();
                idxSizeFutures.add(new T3((Object)cacheCtx, (Object)idx, this.calcIndexSizeAsync(cacheCtx, idx, (IgniteInClosure<Integer>)idleChecker)));
            }
        }
        HashMap partResults = new HashMap();
        HashMap idxResults = new HashMap();
        HashMap<String, ValidateIndexesCheckSizeResult> checkSizeResults = new HashMap<String, ValidateIndexesCheckSizeResult>();
        int curIdx = 0;
        int curCacheSize = 0;
        int curIdxSize = 0;
        try {
            Future fut;
            for (int curPart = 0; curPart < procPartFutures.size(); ++curPart) {
                fut = (Future)procPartFutures.get(curPart);
                Map partRes = (Map)fut.get();
                if (partRes.isEmpty() || !partRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty())) continue;
                partResults.putAll(partRes);
            }
            while (curIdx < procIdxFutures.size()) {
                fut = (Future)procIdxFutures.get(curIdx);
                Map idxRes = (Map)fut.get();
                if (!idxRes.isEmpty() && idxRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty())) {
                    idxResults.putAll(idxRes);
                }
                ++curIdx;
            }
            if (this.checkSizes) {
                String res;
                while (curCacheSize < cacheSizeFutures.size()) {
                    ((Future)((T3)cacheSizeFutures.get(curCacheSize)).get3()).get();
                    ++curCacheSize;
                }
                while (curIdxSize < idxSizeFutures.size()) {
                    ((Future)((T3)idxSizeFutures.get(curIdxSize)).get3()).get();
                    ++curIdxSize;
                }
                this.checkSizes(cacheSizeFutures, idxSizeFutures, checkSizeResults);
                Map partsWithCntrsPerGrpAfterChecks = IdleVerifyUtility.getUpdateCountersSnapshot((IgniteEx)this.ignite, grpIds);
                List diff = IdleVerifyUtility.compareUpdateCounters((IgniteEx)this.ignite, (Map)partsWithCntrsPerGrp, (Map)partsWithCntrsPerGrpAfterChecks);
                if (!F.isEmpty((Collection)diff) && !(res = IdleVerifyUtility.formatUpdateCountersDiff((IgniteEx)this.ignite, (List)diff)).isEmpty()) {
                    throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [" + res + "]");
                }
            }
            this.log.warning("ValidateIndexesClosure finished: processed " + this.totalPartitions + " partitions and " + this.totalIndexes + " indexes.");
        }
        catch (InterruptedException | ExecutionException e2) {
            int j;
            for (j = curPart; j < procPartFutures.size(); ++j) {
                ((Future)procPartFutures.get(j)).cancel(false);
            }
            for (j = curIdx; j < procIdxFutures.size(); ++j) {
                ((Future)procIdxFutures.get(j)).cancel(false);
            }
            for (j = curCacheSize; j < cacheSizeFutures.size(); ++j) {
                ((Future)((T3)cacheSizeFutures.get(j)).get3()).cancel(false);
            }
            for (j = curIdxSize; j < idxSizeFutures.size(); ++j) {
                ((Future)((T3)idxSizeFutures.get(j)).get3()).cancel(false);
            }
            throw this.unwrapFutureException(e2);
        }
        if (this.validateCtx.isCancelled()) {
            throw new IgniteException(CANCELLED_MSG);
        }
        return new VisorValidateIndexesJobResult(partResults, idxResults, integrityCheckResults.values(), checkSizeResults);
    }

    /*
     * WARNING - void declaration
     */
    private Map<Integer, IndexIntegrityCheckIssue> integrityCheckIndexesPartitions(Set<Integer> grpIds, final IgniteInClosure<Integer> idleChecker) {
        if (!this.checkCrc) {
            return Collections.emptyMap();
        }
        ArrayList<Future<T2<Integer, IndexIntegrityCheckIssue>>> integrityCheckFutures = new ArrayList<Future<T2<Integer, IndexIntegrityCheckIssue>>>(grpIds.size());
        HashMap<Integer, IndexIntegrityCheckIssue> integrityCheckResults = new HashMap<Integer, IndexIntegrityCheckIssue>();
        boolean curFut = false;
        IgniteCacheDatabaseSharedManager db = this.ignite.context().cache().context().database();
        try {
            for (Integer n : grpIds) {
                final CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(n.intValue());
                if (grpCtx == null || !grpCtx.persistenceEnabled()) {
                    this.integrityCheckedIndexes.incrementAndGet();
                    continue;
                }
                Future<T2<Integer, IndexIntegrityCheckIssue>> checkFut = this.calcExecutor.submit(new Callable<T2<Integer, IndexIntegrityCheckIssue>>(){

                    @Override
                    public T2<Integer, IndexIntegrityCheckIssue> call() {
                        IndexIntegrityCheckIssue issue = ValidateIndexesClosure.this.integrityCheckIndexPartition(grpCtx, (IgniteInClosure<Integer>)idleChecker);
                        return new T2((Object)grpCtx.groupId(), (Object)issue);
                    }
                });
                integrityCheckFutures.add(checkFut);
            }
            for (Future future : integrityCheckFutures) {
                T2 res = (T2)future.get();
                if (res.getValue() == null) continue;
                integrityCheckResults.put((Integer)res.getKey(), (IndexIntegrityCheckIssue)res.getValue());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            void var8_13;
            boolean bl = curFut;
            while (var8_13 < integrityCheckFutures.size()) {
                ((Future)integrityCheckFutures.get((int)var8_13)).cancel(false);
                ++var8_13;
            }
            throw this.unwrapFutureException(e);
        }
        return integrityCheckResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexIntegrityCheckIssue integrityCheckIndexPartition(CacheGroupContext gctx, IgniteInClosure<Integer> idleChecker) {
        GridKernalContext ctx = this.ignite.context();
        GridCacheSharedContext cctx = ctx.cache().context();
        try {
            FilePageStoreManager pageStoreMgr = (FilePageStoreManager)cctx.pageStore();
            if (pageStoreMgr != null && gctx.persistenceEnabled()) {
                IdleVerifyUtility.checkPartitionsPageCrcSum((IgniteThrowableSupplier & Serializable)() -> (FilePageStore)pageStoreMgr.getStore(gctx.groupId(), 65535), (int)65535, (byte)2);
            }
            idleChecker.apply((Object)gctx.groupId());
            IndexIntegrityCheckIssue indexIntegrityCheckIssue = null;
            return indexIntegrityCheckIssue;
        }
        catch (Throwable t) {
            this.log.error("Integrity check of index partition of cache group " + gctx.cacheOrGroupName() + " failed", t);
            IndexIntegrityCheckIssue indexIntegrityCheckIssue = new IndexIntegrityCheckIssue(gctx.cacheOrGroupName(), t);
            return indexIntegrityCheckIssue;
        }
        finally {
            this.integrityCheckedIndexes.incrementAndGet();
            this.printProgressIfNeeded(() -> "Current progress of ValidateIndexesClosure: checked integrity of " + this.integrityCheckedIndexes.get() + " index partitions of " + this.totalCacheGrps + " cache groups");
        }
    }

    private Future<Map<PartitionKey, ValidateIndexesPartitionResult>> processPartitionAsync(final CacheGroupContext grpCtx, final GridDhtLocalPartition part) {
        return this.calcExecutor.submit(new Callable<Map<PartitionKey, ValidateIndexesPartitionResult>>(){

            @Override
            public Map<PartitionKey, ValidateIndexesPartitionResult> call() {
                return ValidateIndexesClosure.this.processPartition(grpCtx, part);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PartitionKey, ValidateIndexesPartitionResult> processPartition(CacheGroupContext grpCtx, GridDhtLocalPartition part) {
        ValidateIndexesPartitionResult partRes;
        if (this.validateCtx.isCancelled() || !part.reserve()) {
            return Collections.emptyMap();
        }
        try {
            if (part.state() != GridDhtPartitionState.OWNING) {
                Map<PartitionKey, ValidateIndexesPartitionResult> map = Collections.emptyMap();
                return map;
            }
            @Nullable PartitionUpdateCounter updCntr = part.dataStore().partUpdateCounter();
            PartitionUpdateCounter updateCntrBefore = updCntr == null ? null : updCntr.copy();
            partRes = new ValidateIndexesPartitionResult();
            boolean hasMvcc = grpCtx.caches().stream().anyMatch(GridCacheContext::mvccEnabled);
            if (hasMvcc) {
                for (GridCacheContext context : grpCtx.caches()) {
                    Session session = this.mvccSession(context);
                    Throwable throwable = null;
                    try {
                        MvccSnapshot mvccSnapshot = null;
                        boolean mvccEnabled = context.mvccEnabled();
                        if (mvccEnabled) {
                            mvccSnapshot = ((QueryContext)session.getVariable("_IGNITE_QUERY_CONTEXT").getObject()).mvccSnapshot();
                        }
                        GridIterator iterator = grpCtx.offheap().cachePartitionIterator(context.cacheId(), part.id(), mvccSnapshot, null);
                        this.processPartIterator(grpCtx, partRes, session, (GridIterator<CacheDataRow>)iterator);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (session == null) continue;
                        if (throwable != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        session.close();
                    }
                }
            } else {
                this.processPartIterator(grpCtx, partRes, null, (GridIterator<CacheDataRow>)grpCtx.offheap().partitionIterator(part.id()));
            }
            PartitionUpdateCounter updateCntrAfter = part.dataStore().partUpdateCounter();
            if (updateCntrAfter != null && !updateCntrAfter.equals(updateCntrBefore)) {
                throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [grpName=" + grpCtx.cacheOrGroupName() + ", grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "] changed during index validation [before=" + updateCntrBefore + ", after=" + updateCntrAfter + "]");
            }
        }
        catch (IgniteCheckedException e) {
            IgniteUtils.error((IgniteLogger)this.log, (Object)("Failed to process partition [grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "]"), (Throwable)e);
            Map<PartitionKey, ValidateIndexesPartitionResult> map = Collections.emptyMap();
            return map;
        }
        finally {
            part.release();
            this.printProgressOfIndexValidationIfNeeded();
        }
        PartitionKey partKey = new PartitionKey(grpCtx.groupId(), part.id(), grpCtx.cacheOrGroupName());
        this.processedPartitions.incrementAndGet();
        return Collections.singletonMap(partKey, partRes);
    }

    private void processPartIterator(CacheGroupContext grpCtx, ValidateIndexesPartitionResult partRes, Session session, GridIterator<CacheDataRow> it) throws IgniteCheckedException {
        boolean enoughIssues = false;
        GridQueryProcessor qryProcessor = this.ignite.context().query();
        boolean skipConditions = this.checkFirst > 0 || this.checkThrough > 0;
        boolean bothSkipConditions = this.checkFirst > 0 && this.checkThrough > 0;
        long current = 0L;
        long processedNumber = 0L;
        block2: while (it.hasNextX() && !this.validateCtx.isCancelled() && !enoughIssues) {
            IgniteH2Indexing indexing;
            GridH2Table gridH2Tbl;
            GridCacheContext cacheCtx;
            CacheDataRow row = (CacheDataRow)it.nextX();
            if (skipConditions) {
                if (bothSkipConditions) {
                    if (processedNumber > (long)this.checkFirst) break;
                    if (current++ % (long)this.checkThrough > 0L) continue;
                    ++processedNumber;
                } else if (this.checkFirst > 0) {
                    if (current++ > (long)this.checkFirst) {
                        break;
                    }
                } else if (current++ % (long)this.checkThrough > 0L) continue;
            }
            int cacheId = row.cacheId() == 0 ? grpCtx.groupId() : row.cacheId();
            GridCacheContext gridCacheContext = cacheCtx = row.cacheId() == 0 ? grpCtx.singleCacheContext() : grpCtx.shared().cacheContext(row.cacheId());
            if (cacheCtx == null) {
                throw new IgniteException("Unknown cacheId of CacheDataRow: " + cacheId);
            }
            if (row.link() == 0L) {
                String errMsg = "Invalid partition row, possibly deleted";
                this.log.error(errMsg);
                IndexValidationIssue is = new IndexValidationIssue(null, cacheCtx.name(), null, (Throwable)new IgniteCheckedException(errMsg));
                enoughIssues |= partRes.reportIssue(is);
                continue;
            }
            QueryTypeDescriptorImpl res = qryProcessor.typeByValue(cacheCtx.name(), cacheCtx.cacheObjectContext(), row.key(), row.value(), true);
            if (res == null || (gridH2Tbl = (indexing = (IgniteH2Indexing)qryProcessor.getIndexing()).schemaManager().dataTable(cacheCtx.name(), res.tableName())) == null) continue;
            GridH2RowDescriptor gridH2RowDesc = gridH2Tbl.rowDescriptor();
            H2CacheRow h2Row = gridH2RowDesc.createRow(row);
            ArrayList<Index> indexes = gridH2Tbl.getIndexes();
            for (Index idx : indexes) {
                if (this.validateCtx.isCancelled()) continue block2;
                if (!(idx instanceof H2TreeIndexBase)) continue;
                try {
                    Cursor cursor = idx.find(session, (SearchRow)h2Row, (SearchRow)h2Row);
                    if (cursor != null && cursor.next()) continue;
                    throw new IgniteCheckedException("Key is present in CacheDataTree, but can't be found in SQL index.");
                }
                catch (Throwable t) {
                    Object o = CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)grpCtx.cacheObjectContext(), (CacheObject)row.key(), (boolean)true, (boolean)true);
                    IndexValidationIssue is = new IndexValidationIssue(o.toString(), cacheCtx.name(), idx.getName(), t);
                    this.log.error("Failed to lookup key: " + is.toString(), t);
                    enoughIssues |= partRes.reportIssue(is);
                }
            }
        }
    }

    private Session mvccSession(GridCacheContext<?, ?> cctx) throws IgniteCheckedException {
        Session session = null;
        boolean mvccEnabled = cctx.mvccEnabled();
        if (mvccEnabled) {
            ConnectionManager connMgr = ((IgniteH2Indexing)this.ignite.context().query().getIndexing()).connections();
            JdbcConnection connection = (JdbcConnection)connMgr.connection().connection();
            session = (Session)connection.getSession();
            MvccQueryTracker tracker = MvccUtils.mvccTracker(cctx, (boolean)true);
            MvccSnapshot mvccSnapshot = tracker.snapshot();
            QueryContext qctx = new QueryContext(0, cacheName -> null, null, mvccSnapshot, null, true);
            session.setVariable("_IGNITE_QUERY_CONTEXT", new H2Utils.ValueRuntimeSimpleObject<QueryContext>(qctx));
        }
        return session;
    }

    private void printProgressOfIndexValidationIfNeeded() {
        this.printProgressIfNeeded(() -> "Current progress of ValidateIndexesClosure: processed " + this.processedPartitions.get() + " of " + this.totalPartitions + " partitions, " + this.processedIndexes.get() + " of " + this.totalIndexes + " SQL indexes" + (this.checkSizes ? ", " + this.processedCacheSizePartitions.get() + " of " + this.totalPartitions + " calculate cache size per partitions, " + this.processedIdxSizes.get() + " of " + this.totalIndexes + "calculate index size" : ""));
    }

    private void printProgressIfNeeded(Supplier<String> msgSup) {
        long lastTs;
        long curTs = U.currentTimeMillis();
        if (curTs - (lastTs = this.lastProgressPrintTs.get()) >= 60000L && this.lastProgressPrintTs.compareAndSet(lastTs, curTs)) {
            this.log.warning(msgSup.get());
        }
    }

    private Future<Map<String, ValidateIndexesPartitionResult>> processIndexAsync(final T2<GridCacheContext, Index> cacheCtxWithIdx, final IgniteInClosure<Integer> idleChecker) {
        return this.calcExecutor.submit(new Callable<Map<String, ValidateIndexesPartitionResult>>(){

            @Override
            public Map<String, ValidateIndexesPartitionResult> call() {
                BPlusTree.suspendFailureDiagnostic.set(true);
                try {
                    Map map = ValidateIndexesClosure.this.processIndex((T2<GridCacheContext, Index>)cacheCtxWithIdx, (IgniteInClosure<Integer>)idleChecker);
                    return map;
                }
                finally {
                    BPlusTree.suspendFailureDiagnostic.set(false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, ValidateIndexesPartitionResult> processIndex(T2<GridCacheContext, Index> cacheCtxWithIdx, IgniteInClosure<Integer> idleChecker) {
        if (this.validateCtx.isCancelled()) {
            return Collections.emptyMap();
        }
        GridCacheContext ctx = (GridCacheContext)cacheCtxWithIdx.get1();
        Index idx = (Index)cacheCtxWithIdx.get2();
        ValidateIndexesPartitionResult idxValidationRes = new ValidateIndexesPartitionResult();
        boolean enoughIssues = false;
        Cursor cursor = null;
        try (Session session = this.mvccSession((GridCacheContext)cacheCtxWithIdx.get1());){
            cursor = idx.find(session, null, null);
            if (cursor == null) {
                throw new IgniteCheckedException("Can't iterate through index: " + idx);
            }
        }
        catch (Throwable t) {
            IndexValidationIssue is = new IndexValidationIssue(null, ctx.name(), idx.getName(), t);
            this.log.error("Find in index failed: " + is.toString());
            idxValidationRes.reportIssue(is);
            enoughIssues = true;
        }
        boolean skipConditions = this.checkFirst > 0 || this.checkThrough > 0;
        boolean bothSkipConditions = this.checkFirst > 0 && this.checkThrough > 0;
        long current = 0L;
        long processedNumber = 0L;
        KeyCacheObject previousKey = null;
        while (!enoughIssues && !this.validateCtx.isCancelled()) {
            KeyCacheObject h2key = null;
            try {
                try {
                    try {
                        if (!cursor.next()) {
                            previousKey = h2key;
                            break;
                        }
                    }
                    catch (DbException e) {
                        if (X.hasCause((Throwable)e, (Class[])new Class[]{CorruptedTreeException.class})) {
                            throw new IgniteCheckedException("Key is present in SQL index, but is missing in corresponding data page. Previous successfully read key: " + CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)ctx.cacheObjectContext(), (CacheObject)previousKey, (boolean)true, (boolean)true), X.cause((Throwable)e, CorruptedTreeException.class));
                        }
                        throw e;
                    }
                    H2CacheRow h2Row = (H2CacheRow)cursor.get();
                    if (skipConditions) {
                        if (bothSkipConditions) {
                            if (processedNumber > (long)this.checkFirst) {
                                previousKey = h2key;
                                break;
                            }
                            if (current++ % (long)this.checkThrough > 0L) {
                                previousKey = h2key;
                                continue;
                            }
                            ++processedNumber;
                        } else if (this.checkFirst > 0) {
                            if (current++ > (long)this.checkFirst) {
                                previousKey = h2key;
                                break;
                            }
                        } else if (current++ % (long)this.checkThrough > 0L) {
                            previousKey = h2key;
                            continue;
                        }
                    }
                    h2key = h2Row.key();
                    if (h2Row.link() == 0L) {
                        throw new IgniteCheckedException("Invalid index row, possibly deleted " + h2Row);
                    }
                    CacheDataRow cacheDataStoreRow = ctx.group().offheap().read(ctx, h2key);
                    if (cacheDataStoreRow == null) {
                        throw new IgniteCheckedException("Key is present in SQL index, but can't be found in CacheDataTree.");
                    }
                    previousKey = h2key;
                }
                catch (Throwable t) {
                    Object o = CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)ctx.cacheObjectContext(), h2key, (boolean)true, (boolean)true);
                    IndexValidationIssue is = new IndexValidationIssue(String.valueOf(o), ctx.name(), idx.getName(), t);
                    this.log.error("Failed to lookup key: " + is.toString());
                    enoughIssues |= idxValidationRes.reportIssue(is);
                    previousKey = h2key;
                }
            }
            catch (Throwable throwable) {
                previousKey = h2key;
                throw throwable;
            }
        }
        CacheGroupContext group = ctx.group();
        String uniqueIdxName = String.format("[cacheGroup=%s, cacheGroupId=%s, cache=%s, cacheId=%s, idx=%s]", group.name(), group.groupId(), ctx.name(), ctx.cacheId(), idx.getName());
        idleChecker.apply((Object)group.groupId());
        this.processedIndexes.incrementAndGet();
        this.printProgressOfIndexValidationIfNeeded();
        return Collections.singletonMap(uniqueIdxName, idxValidationRes);
    }

    private IgniteException unwrapFutureException(Exception e) {
        assert (e instanceof InterruptedException || e instanceof ExecutionException) : "Expecting either InterruptedException or ExecutionException";
        if (e instanceof InterruptedException) {
            return new IgniteInterruptedException((InterruptedException)e);
        }
        if (e.getCause() instanceof IgniteException) {
            return (IgniteException)e.getCause();
        }
        return new IgniteException(e.getCause());
    }

    private Future<CacheSize> calcCacheSizeAsync(CacheGroupContext grpCtx, GridDhtLocalPartition locPart) {
        return this.calcExecutor.submit(() -> this.calcCacheSize(grpCtx, locPart));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CacheSize calcCacheSize(CacheGroupContext grpCtx, GridDhtLocalPartition locPart) {
        try {
            CacheSize cacheSize;
            block20: {
                if (this.validateCtx.isCancelled()) {
                    CacheSize cacheSize2 = new CacheSize(null, Collections.emptyMap());
                    return cacheSize2;
                }
                @Nullable PartitionUpdateCounter updCntr = locPart.dataStore().partUpdateCounter();
                PartitionUpdateCounter updateCntrBefore = updCntr == null ? updCntr : updCntr.copy();
                int grpId = grpCtx.groupId();
                if (this.failCalcCacheSizeGrpIds.contains(grpId)) {
                    CacheSize cacheSize3 = new CacheSize(null, null);
                    return cacheSize3;
                }
                boolean reserve = false;
                int partId = locPart.id();
                try {
                    reserve = locPart.reserve();
                    if (!reserve) {
                        throw new IgniteException("Can't reserve partition");
                    }
                    if (locPart.state() != GridDhtPartitionState.OWNING) {
                        throw new IgniteException("Partition not in state " + GridDhtPartitionState.OWNING);
                    }
                    HashMap<Integer, Map<String, AtomicLong>> cacheSizeByTbl = new HashMap<Integer, Map<String, AtomicLong>>();
                    GridIterator partIter = grpCtx.offheap().partitionIterator(partId);
                    GridQueryProcessor qryProcessor = this.ignite.context().query();
                    IgniteH2Indexing h2Indexing = (IgniteH2Indexing)qryProcessor.getIndexing();
                    while (partIter.hasNextX() && !this.failCalcCacheSizeGrpIds.contains(grpId)) {
                        GridCacheContext cacheCtx;
                        CacheDataRow cacheDataRow = (CacheDataRow)partIter.nextX();
                        int cacheId = cacheDataRow.cacheId();
                        GridCacheContext gridCacheContext = cacheCtx = cacheId == 0 ? grpCtx.singleCacheContext() : grpCtx.shared().cacheContext(cacheId);
                        if (cacheCtx == null) {
                            throw new IgniteException("Unknown cacheId of CacheDataRow: " + cacheId);
                        }
                        if (cacheDataRow.link() == 0L) {
                            throw new IgniteException("Contains invalid partition row, possibly deleted");
                        }
                        String cacheName = cacheCtx.name();
                        QueryTypeDescriptorImpl qryTypeDesc = qryProcessor.typeByValue(cacheName, cacheCtx.cacheObjectContext(), cacheDataRow.key(), cacheDataRow.value(), true);
                        if (Objects.isNull(qryTypeDesc)) continue;
                        String tableName = qryTypeDesc.tableName();
                        GridH2Table gridH2Tbl = h2Indexing.schemaManager().dataTable(cacheName, tableName);
                        if (Objects.isNull((Object)gridH2Tbl)) continue;
                        cacheSizeByTbl.computeIfAbsent(cacheCtx.cacheId(), i -> new HashMap()).computeIfAbsent(tableName, s -> new AtomicLong()).incrementAndGet();
                    }
                    PartitionUpdateCounter updateCntrAfter = locPart.dataStore().partUpdateCounter();
                    if (updateCntrAfter != null && !updateCntrAfter.equals(updateCntrBefore)) {
                        throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [grpName=" + grpCtx.cacheOrGroupName() + ", grpId=" + grpCtx.groupId() + ", partId=" + locPart.id() + "] changed during size calculation [updCntrBefore=" + updateCntrBefore + ", updCntrAfter=" + updateCntrAfter + "]");
                    }
                    cacheSize = new CacheSize(null, cacheSizeByTbl);
                    if (!reserve) break block20;
                }
                catch (Throwable t) {
                    CacheSize cacheSize4;
                    block21: {
                        IgniteException cacheSizeErr = new IgniteException("Cache size calculation error [" + this.cacheGrpInfo(grpCtx) + ", locParId=" + partId + ", err=" + t.getMessage() + "]", t);
                        IgniteUtils.error((IgniteLogger)this.log, (Object)((Object)cacheSizeErr));
                        this.failCalcCacheSizeGrpIds.add(grpId);
                        cacheSize4 = new CacheSize(cacheSizeErr, null);
                        if (!reserve) break block21;
                        locPart.release();
                    }
                    this.processedCacheSizePartitions.incrementAndGet();
                    this.printProgressOfIndexValidationIfNeeded();
                    return cacheSize4;
                    {
                        catch (Throwable throwable) {
                            if (reserve) {
                                locPart.release();
                            }
                            throw throwable;
                        }
                    }
                }
                locPart.release();
            }
            return cacheSize;
        }
        finally {
            this.processedCacheSizePartitions.incrementAndGet();
            this.printProgressOfIndexValidationIfNeeded();
        }
    }

    private Future<T2<Throwable, Long>> calcIndexSizeAsync(GridCacheContext cacheCtx, Index idx, IgniteInClosure<Integer> idleChecker) {
        return this.calcExecutor.submit(() -> this.calcIndexSize(cacheCtx, idx, idleChecker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T2<Throwable, Long> calcIndexSize(GridCacheContext cacheCtx, Index idx, IgniteInClosure<Integer> idleChecker) {
        if (this.validateCtx.isCancelled()) {
            return new T2(null, (Object)0L);
        }
        try {
            if (this.failCalcCacheSizeGrpIds.contains(cacheCtx.groupId())) {
                T2 t2 = new T2(null, (Object)0L);
                return t2;
            }
            String cacheName = cacheCtx.name();
            String tblName = idx.getTable().getName();
            String idxName = idx.getName();
            try {
                long indexSize = this.ignite.context().query().getIndexing().indexSize(cacheName, tblName, idxName);
                idleChecker.apply((Object)cacheCtx.groupId());
                T2 t2 = new T2(null, (Object)indexSize);
                return t2;
            }
            catch (Throwable t) {
                IgniteException idxSizeErr = new IgniteException("Index size calculation error [" + this.cacheGrpInfo(cacheCtx.group()) + ", " + this.cacheInfo(cacheCtx) + ", tableName=" + tblName + ", idxName=" + idxName + ", err=" + t.getMessage() + "]", t);
                IgniteUtils.error((IgniteLogger)this.log, (Object)((Object)idxSizeErr));
                T2 t2 = new T2((Object)idxSizeErr, (Object)0L);
                this.processedIdxSizes.incrementAndGet();
                this.printProgressOfIndexValidationIfNeeded();
                return t2;
            }
        }
        finally {
            this.processedIdxSizes.incrementAndGet();
            this.printProgressOfIndexValidationIfNeeded();
        }
    }

    private String cacheGrpInfo(CacheGroupContext cacheGrpCtx) {
        return "cacheGrpName=" + cacheGrpCtx.name() + ", cacheGrpId=" + cacheGrpCtx.groupId();
    }

    private String cacheInfo(GridCacheContext cacheCtx) {
        return "cacheName=" + cacheCtx.name() + ", cacheId=" + cacheCtx.cacheId();
    }

    private void checkSizes(List<T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>>> cacheSizesFutures, List<T3<GridCacheContext, Index, Future<T2<Throwable, Long>>>> idxSizeFutures, Map<String, ValidateIndexesCheckSizeResult> checkSizeRes) throws ExecutionException, InterruptedException {
        if (!this.checkSizes) {
            return;
        }
        HashMap<Integer, CacheSize> cacheSizeTotal = new HashMap<Integer, CacheSize>();
        for (T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>> t3 : cacheSizesFutures) {
            CacheGroupContext cacheGrpCtx = (CacheGroupContext)t3.get1();
            CacheSize cacheSize = (CacheSize)((Future)t3.get3()).get();
            Throwable cacheSizeErr = cacheSize.err;
            int grpId = cacheGrpCtx.groupId();
            if (this.failCalcCacheSizeGrpIds.contains(grpId) && Objects.nonNull(cacheSizeErr)) {
                checkSizeRes.computeIfAbsent(this.cacheGrpInfo(cacheGrpCtx), s -> new ValidateIndexesCheckSizeResult(0L, new ArrayList())).issues().add(new ValidateIndexesCheckSizeIssue(null, 0L, cacheSizeErr));
                continue;
            }
            cacheSizeTotal.computeIfAbsent(grpId, i -> new CacheSize(null, new HashMap<Integer, Map<String, AtomicLong>>())).merge(cacheSize.cacheSizePerTbl);
        }
        for (T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>> t3 : idxSizeFutures) {
            GridCacheContext cacheCtx = (GridCacheContext)t3.get1();
            int grpId = cacheCtx.groupId();
            if (this.failCalcCacheSizeGrpIds.contains(grpId)) continue;
            Index idx = (Index)t3.get2();
            String tblName = idx.getTable().getName();
            AtomicLong cacheSizeObj = (AtomicLong)((CacheSize)cacheSizeTotal.get((Object)Integer.valueOf((int)grpId))).cacheSizePerTbl.getOrDefault(cacheCtx.cacheId(), Collections.emptyMap()).get(tblName);
            long cacheSizeByTbl = Objects.isNull(cacheSizeObj) ? 0L : cacheSizeObj.get();
            T2 idxSizeRes = (T2)((Future)t3.get3()).get();
            Throwable err = (Throwable)idxSizeRes.get1();
            long idxSize = (Long)idxSizeRes.get2();
            if (Objects.isNull(err) && idxSize != cacheSizeByTbl) {
                err = new IgniteException("Cache and index size not same.");
            }
            if (!Objects.nonNull(err)) continue;
            checkSizeRes.computeIfAbsent("[" + this.cacheGrpInfo(cacheCtx.group()) + ", " + this.cacheInfo(cacheCtx) + ", tableName=" + tblName + "]", s -> new ValidateIndexesCheckSizeResult(cacheSizeByTbl, new ArrayList())).issues().add(new ValidateIndexesCheckSizeIssue(idx.getName(), idxSize, err));
        }
    }

    private static class CacheSize {
        final Throwable err;
        final Map<Integer, Map<String, AtomicLong>> cacheSizePerTbl;

        public CacheSize(@Nullable Throwable err, @Nullable Map<Integer, Map<String, AtomicLong>> cacheSizePerTbl) {
            this.err = err;
            this.cacheSizePerTbl = cacheSizePerTbl;
        }

        void merge(Map<Integer, Map<String, AtomicLong>> other) {
            assert (Objects.nonNull(this.cacheSizePerTbl));
            for (Map.Entry<Integer, Map<String, AtomicLong>> cacheEntry : other.entrySet()) {
                for (Map.Entry<String, AtomicLong> tableEntry : cacheEntry.getValue().entrySet()) {
                    this.cacheSizePerTbl.computeIfAbsent(cacheEntry.getKey(), i -> new HashMap()).computeIfAbsent(tableEntry.getKey(), s -> new AtomicLong()).addAndGet(tableEntry.getValue().get());
                }
            }
        }
    }
}

