/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.affinity.PartitionExtractor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.join.CollocationModel;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAggregateFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlArray;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlPlaceholder;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterAndCondition;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterContext;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterQueryModel;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterQueryModelType;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterUtils;
import org.apache.ignite.internal.processors.query.h2.sql.SqlAstTraverser;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.table.Column;

public class GridSqlQuerySplitter {
    private static final String MERGE_TABLE_SCHEMA = "PUBLIC";
    private static final String MERGE_TABLE_PREFIX = "__T";
    private static final String COLUMN_PREFIX = "__C";
    private static final String HAVING_COLUMN = "__H";
    private static final String UNIQUE_TABLE_ALIAS_SUFFIX = "__Z";
    private static final String EXPR_ALIAS_PREFIX = "__X";
    private int nextExprAliasId;
    private int nextTblAliasId;
    private int splitId = -1;
    private final Set<QueryTable> tbls = new HashSet<QueryTable>();
    private final Set<String> pushedDownCols = new HashSet<String>();
    private boolean skipMergeTbl;
    private GridCacheSqlQuery rdcSqlQry;
    private final List<GridCacheSqlQuery> mapSqlQrys = new ArrayList<GridCacheSqlQuery>();
    private int paramsCnt;
    private final boolean collocatedGrpBy;
    private final boolean canExtractPartitions;
    private final boolean distributedJoins;
    private final IgniteLogger log;
    private final IdentityHashMap<GridSqlAst, GridSqlAlias> uniqueFromAliases = new IdentityHashMap();
    private final PartitionExtractor extractor;

    public GridSqlQuerySplitter(int paramsCnt, boolean collocatedGrpBy, boolean distributedJoins, boolean locSplit, PartitionExtractor extractor, IgniteLogger log) {
        this.paramsCnt = paramsCnt;
        this.collocatedGrpBy = collocatedGrpBy;
        this.extractor = extractor;
        this.distributedJoins = distributedJoins;
        this.log = log;
        this.canExtractPartitions = !distributedJoins && !locSplit;
    }

    private static GridSqlTable mergeTable(int idx) {
        return new GridSqlTable(MERGE_TABLE_SCHEMA, MERGE_TABLE_PREFIX + idx);
    }

    public static String mergeTableIdentifier(int idx) {
        return GridSqlQuerySplitter.mergeTable(idx).getSQL();
    }

    private String columnName(int idx) {
        return COLUMN_PREFIX + this.splitId + '_' + idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridCacheTwoStepQuery split(H2PooledConnection conn, GridSqlQuery qry, String originalSql, boolean collocatedGrpBy, boolean distributedJoins, boolean enforceJoinOrder, boolean locSplit, IgniteH2Indexing idx, int paramsCnt, IgniteLogger log) throws SQLException, IgniteCheckedException {
        SplitterContext.set(distributedJoins);
        try {
            GridCacheTwoStepQuery gridCacheTwoStepQuery = GridSqlQuerySplitter.split0(conn, qry, originalSql, collocatedGrpBy, distributedJoins, enforceJoinOrder, locSplit, idx, paramsCnt, log);
            return gridCacheTwoStepQuery;
        }
        finally {
            SplitterContext.set(false);
        }
    }

    private static GridCacheTwoStepQuery split0(H2PooledConnection conn, GridSqlQuery qry, String originalSql, boolean collocatedGrpBy, boolean distributedJoins, boolean enforceJoinOrder, boolean locSplit, IgniteH2Indexing idx, int paramsCnt, IgniteLogger log) throws SQLException, IgniteCheckedException {
        boolean explain = qry.explain();
        qry.explain(false);
        GridSqlQuerySplitter splitter = new GridSqlQuerySplitter(paramsCnt, collocatedGrpBy, distributedJoins, locSplit, idx.partitionExtractor(), log);
        splitter.normalizeQuery(qry);
        qry = GridSqlQueryParser.parseQuery(GridSqlQuerySplitter.prepare(conn, H2Utils.context(conn), qry.getSQL(), false, enforceJoinOrder), true, log);
        splitter.splitQuery(qry);
        assert (!F.isEmpty(splitter.mapSqlQrys)) : "map";
        assert (splitter.rdcSqlQry != null) : "rdc";
        if (distributedJoins) {
            boolean allCollocated = true;
            for (GridCacheSqlQuery mapSqlQry : splitter.mapSqlQrys) {
                Prepared prepared0 = GridSqlQuerySplitter.prepare(conn, H2Utils.context(conn), mapSqlQry.query(), true, enforceJoinOrder);
                allCollocated &= CollocationModel.isCollocated((Query)prepared0);
                mapSqlQry.query(GridSqlQueryParser.parseQuery(prepared0, true, log).getSQL());
            }
            if (allCollocated) {
                distributedJoins = false;
            }
        }
        List<Integer> cacheIds = H2Utils.collectCacheIds(idx, null, splitter.tbls);
        boolean mvccEnabled = H2Utils.collectMvccEnabled(idx, cacheIds);
        boolean replicatedOnly = splitter.mapSqlQrys.stream().noneMatch(GridCacheSqlQuery::isPartitioned);
        boolean treatReplicatedAsPartitioned = splitter.mapSqlQrys.stream().anyMatch(GridCacheSqlQuery::hasOuterJoinReplicatedPartitioned);
        H2Utils.checkQuery(idx, cacheIds, splitter.tbls);
        return new GridCacheTwoStepQuery(originalSql, paramsCnt, splitter.tbls, splitter.rdcSqlQry, splitter.mapSqlQrys, splitter.skipMergeTbl, explain, distributedJoins, replicatedOnly, splitter.extractor.mergeMapQueries(splitter.mapSqlQrys), cacheIds, mvccEnabled, locSplit, treatReplicatedAsPartitioned);
    }

    private void splitQuery(GridSqlQuery qry) throws IgniteCheckedException {
        GridSqlSubquery fakeQryParent = new GridSqlSubquery(qry);
        SplitterQueryModel fakeModelParent = new SplitterQueryModel(null, null, -1, null);
        fakeModelParent.buildQueryModel(fakeQryParent, 0, null);
        assert (fakeModelParent.childModelsCount() == 1);
        SplitterQueryModel model = fakeModelParent.childModel(0);
        model.analyzeQueryModel(this.collocatedGrpBy);
        if (model.needSplitChild()) {
            this.pushDownQueryModel(model);
            this.setupMergeJoinSorting(model);
        } else if (!model.needSplit()) {
            model.forceSplit();
        }
        this.splitQueryModel(model);
        qry = fakeQryParent.subquery();
        String rdcQry = qry.getSQL();
        SplitterUtils.checkNoDataTablesInReduceQuery(qry, rdcQry);
        this.rdcSqlQry = new GridCacheSqlQuery(rdcQry);
        this.skipMergeTbl = qry.skipMergeTable();
        GridSqlQuerySplitter.setupParameters(this.rdcSqlQry, qry, this.paramsCnt);
    }

    private void pushDownQueryModel(SplitterQueryModel model) {
        if (model.type() == SplitterQueryModelType.UNION) {
            assert (model.needSplitChild());
            for (int i = 0; i < model.childModelsCount(); ++i) {
                this.pushDownQueryModel(model.childModel(i));
            }
        } else if (model.type() == SplitterQueryModelType.SELECT) {
            if (!model.needSplit()) {
                assert (model.needSplitChild());
                this.pushDownQueryModelSelect(model);
            }
        } else {
            throw new IllegalStateException("Type: " + (Object)((Object)model.type()));
        }
    }

    private boolean hasPushedDownColumn(GridSqlAst expr) {
        if (expr instanceof GridSqlColumn) {
            return this.pushedDownCols.contains(((GridSqlColumn)expr).columnName());
        }
        for (int i = 0; i < expr.size(); ++i) {
            if (!this.hasPushedDownColumn((GridSqlAst)expr.child(i))) continue;
            return true;
        }
        return false;
    }

    private void pushDownQueryModelSelect(SplitterQueryModel model) {
        assert (model.type() == SplitterQueryModelType.SELECT) : model.type();
        boolean hasLeftJoin = SplitterUtils.hasLeftJoin(((GridSqlSelect)model.ast()).from());
        int begin = -1;
        for (int i = 0; i < model.childModelsCount(); ++i) {
            SplitterQueryModel child = model.childModel(i);
            boolean hasPushedDownCol = false;
            if (child.isQuery() && (child.needSplitChild() || child.needSplit()) || (hasPushedDownCol = hasLeftJoin && i != 0 && this.hasPushedDownColumn(model.findJoin(i).on()))) {
                if (hasPushedDownCol && begin == -1) {
                    begin = i - 1;
                }
                if (begin != -1) {
                    this.pushDownQueryModelRange(model, begin, i - 1);
                    i = begin + 1;
                    assert (model.childModel(i) == child);
                    int n = begin = hasPushedDownCol ? i : -1;
                }
                if (!child.needSplitChild()) continue;
                this.pushDownQueryModel(child);
                continue;
            }
            if (begin != -1) continue;
            begin = i;
        }
        if (begin != -1) {
            this.pushDownQueryModelRange(model, begin, model.childModelsCount() - 1);
        }
    }

    private void setupMergeJoinSorting(SplitterQueryModel model) {
        if (model.type() == SplitterQueryModelType.UNION) {
            for (int i = 0; i < model.childModelsCount(); ++i) {
                this.setupMergeJoinSorting(model.childModel(i));
            }
        } else if (model.type() == SplitterQueryModelType.SELECT) {
            if (!model.needSplit()) {
                boolean needSplitChild = false;
                for (int i = 0; i < model.childModelsCount(); ++i) {
                    SplitterQueryModel child = model.childModel(i);
                    assert (child.isQuery()) : child.type();
                    if (child.needSplit()) {
                        needSplitChild = true;
                        continue;
                    }
                    this.setupMergeJoinSorting(child);
                }
                if (needSplitChild && model.childModelsCount() > 1) {
                    this.setupMergeJoinSortingSelect(model);
                }
            }
        } else {
            throw new IllegalStateException("Type: " + (Object)((Object)model.type()));
        }
    }

    private void setupMergeJoinSortingSelect(SplitterQueryModel model) {
        for (int i = 1; i < model.childModelsCount(); ++i) {
            SplitterQueryModel child = model.childModel(i);
            if (!child.needSplit()) continue;
            if (i > 1) {
                this.doPushDownQueryModelRange(model, 0, i - 1, false);
                i = 1;
                assert (model.childModel(i) == child);
            }
            this.injectSortingFirstJoin(model);
        }
    }

    private void injectSortingFirstJoin(SplitterQueryModel model) {
        GridSqlJoin join = model.findJoin(0);
        GridSqlAlias leftTbl = (GridSqlAlias)join.leftTable();
        GridSqlAlias rightTbl = (GridSqlAlias)join.rightTable();
        ArrayList<SplitterAndCondition> andConditions = new ArrayList<SplitterAndCondition>();
        SplitterAndCondition.collectAndConditions(andConditions, join, 2);
        SplitterAndCondition.collectAndConditions(andConditions, model.ast(), 3);
        ArrayList<GridSqlColumn> leftOrder = new ArrayList<GridSqlColumn>();
        ArrayList<GridSqlColumn> rightOrder = new ArrayList<GridSqlColumn>();
        for (int i = 0; i < andConditions.size(); ++i) {
            SplitterAndCondition and = (SplitterAndCondition)andConditions.get(i);
            GridSqlOperation op = (GridSqlOperation)and.ast();
            if (op.operationType() != GridSqlOperationType.EQUAL) continue;
            Object leftExpr = op.child(0);
            Object rightExpr = op.child(1);
            if (!(leftExpr instanceof GridSqlColumn) || !(rightExpr instanceof GridSqlColumn)) continue;
            GridSqlAst leftFrom = ((GridSqlColumn)leftExpr).expressionInFrom();
            GridSqlAst rightFrom = ((GridSqlColumn)rightExpr).expressionInFrom();
            if (leftFrom == leftTbl && rightFrom == rightTbl) {
                leftOrder.add((GridSqlColumn)leftExpr);
                rightOrder.add((GridSqlColumn)rightExpr);
                continue;
            }
            if (leftFrom != rightTbl || rightFrom != leftTbl) continue;
            leftOrder.add((GridSqlColumn)rightExpr);
            rightOrder.add((GridSqlColumn)leftExpr);
        }
        this.injectOrderBy(leftTbl, leftOrder);
        this.injectOrderBy(rightTbl, rightOrder);
    }

    private void injectOrderBy(GridSqlAlias subQryAlias, List<GridSqlColumn> orderByCols) {
        if (orderByCols.isEmpty()) {
            return;
        }
        Object qry = ((GridSqlSubquery)GridSqlAlias.unwrap(subQryAlias)).subquery();
        GridSqlSelect select = this.leftmostSelect((GridSqlQuery)qry);
        BitSet set = new BitSet();
        for (int i = 0; i < orderByCols.size(); ++i) {
            GridSqlColumn col = orderByCols.get(i);
            int colIdx = 0;
            while (true) {
                String colName;
                GridSqlAst expr;
                if ((expr = select.column(colIdx)) instanceof GridSqlAlias) {
                    colName = ((GridSqlAlias)expr).alias();
                } else if (expr instanceof GridSqlColumn) {
                    colName = ((GridSqlColumn)expr).columnName();
                } else {
                    throw new IllegalStateException();
                }
                if (colName.equals(col.columnName())) break;
                ++colIdx;
            }
            if (set.get(colIdx)) continue;
            set.set(colIdx, true);
            ((GridSqlQuery)qry).addSort(new GridSqlSortColumn(colIdx, true, false, false));
        }
    }

    private GridSqlSelect leftmostSelect(GridSqlQuery qry) {
        while (qry instanceof GridSqlUnion) {
            qry = ((GridSqlUnion)qry).left();
        }
        return (GridSqlSelect)qry;
    }

    private void pushDownQueryModelRange(SplitterQueryModel model, int begin, int end) {
        assert (end >= begin);
        if (begin == end && model.childModel(end).isQuery()) {
            model.childModel(end).forceSplit();
        } else {
            this.doPushDownQueryModelRange(model, begin, end, true);
        }
    }

    private void doPushDownQueryModelRange(SplitterQueryModel model, int begin, int end, boolean needSplit) {
        GridSqlSelect wrapSelect = new GridSqlSelect();
        GridSqlSubquery wrapSubqry = new GridSqlSubquery(wrapSelect);
        GridSqlAlias wrapAlias = SplitterUtils.alias(this.nextUniqueTableAlias(null), wrapSubqry);
        SplitterQueryModel wrapModel = new SplitterQueryModel(SplitterQueryModelType.SELECT, wrapSubqry, 0, wrapAlias, needSplit);
        GridSqlSelect select = (GridSqlSelect)model.ast();
        Set tblAliases = U.newIdentityHashSet();
        HashMap<String, GridSqlAlias> cols = new HashMap<String, GridSqlAlias>();
        for (int i = begin; i <= end; ++i) {
            GridSqlAlias uniqueTblAlias = model.childModel(i).uniqueAlias();
            assert (uniqueTblAlias != null) : select.getSQL();
            tblAliases.add(uniqueTblAlias);
        }
        this.pushDownSelectColumns(tblAliases, cols, wrapAlias, select);
        this.pushDownWhereConditions(tblAliases, cols, wrapAlias, select);
        this.pushDownJoins(tblAliases, cols, model, begin, end, wrapAlias);
        for (GridSqlAlias col : cols.values()) {
            wrapSelect.addColumn(col, true);
        }
        model.moveChildModelsToWrapModel(wrapModel, begin, end);
    }

    private void pushDownJoins(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, SplitterQueryModel model, int begin, int end, GridSqlAlias wrapAlias) {
        GridSqlJoin endJoin;
        GridSqlJoin afterBeginJoin;
        GridSqlJoin beginJoin;
        GridSqlJoin endJoin2;
        GridSqlSelect select = (GridSqlSelect)model.ast();
        GridSqlSelect wrapSelect = (GridSqlSelect)((GridSqlSubquery)GridSqlAlias.unwrap(wrapAlias)).subquery();
        int last = model.childModelsCount() - 1;
        if (begin == end) {
            endJoin2 = model.findJoin(end);
            wrapSelect.from(model.childModel(end).uniqueAlias());
            endJoin2.child(end == 0 ? 0 : 1, wrapAlias);
        } else if (end == last) {
            assert (begin > 0);
            beginJoin = model.findJoin(begin);
            afterBeginJoin = model.findJoin(begin + 1);
            endJoin = model.findJoin(end);
            wrapSelect.from(endJoin);
            afterBeginJoin.leftTable(beginJoin.rightTable());
            beginJoin.rightTable(wrapAlias);
            select.from(beginJoin);
        } else if (begin == 0) {
            endJoin2 = model.findJoin(end);
            GridSqlJoin afterEndJoin = model.findJoin(end + 1);
            wrapSelect.from(endJoin2);
            afterEndJoin.leftTable(wrapAlias);
        } else {
            beginJoin = model.findJoin(begin);
            afterBeginJoin = model.findJoin(begin + 1);
            endJoin = model.findJoin(end);
            GridSqlJoin afterEndJoin = model.findJoin(end + 1);
            wrapSelect.from(endJoin);
            afterEndJoin.leftTable(beginJoin);
            afterBeginJoin.leftTable(beginJoin.rightTable());
            beginJoin.rightTable(wrapAlias);
        }
        GridSqlAst from = select.from();
        while (from instanceof GridSqlJoin) {
            assert (!(((GridSqlJoin)from).rightTable() instanceof GridSqlJoin));
            this.pushDownColumnsInExpression(tblAliases, cols, wrapAlias, from, 2);
            from = from.child(0);
        }
    }

    private void pushDownSelectColumns(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, GridSqlAlias wrapAlias, GridSqlSelect select) {
        for (int i = 0; i < select.allColumns(); ++i) {
            GridSqlAst expr = select.column(i);
            if (!(expr instanceof GridSqlAlias)) {
                String alias = expr instanceof GridSqlColumn ? ((GridSqlColumn)expr).columnName() : EXPR_ALIAS_PREFIX + i;
                expr = SplitterUtils.alias(alias, expr);
                select.setColumn(i, expr);
            }
            if (GridSqlQuerySplitter.isAllRelatedToTables(tblAliases, U.newIdentityHashSet(), expr) && !SplitterUtils.hasAggregates(expr)) {
                this.pushDownColumn(tblAliases, cols, wrapAlias, expr, 0);
                continue;
            }
            this.pushDownColumnsInExpression(tblAliases, cols, wrapAlias, expr, 0);
        }
    }

    private void pushDownColumnsInExpression(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, GridSqlAlias wrapAlias, GridSqlAst parent, int childIdx) {
        Object child = parent.child(childIdx);
        if (child instanceof GridSqlColumn) {
            this.pushDownColumn(tblAliases, cols, wrapAlias, parent, childIdx);
        } else {
            for (int i = 0; i < child.size(); ++i) {
                this.pushDownColumnsInExpression(tblAliases, cols, wrapAlias, (GridSqlAst)child, i);
            }
        }
    }

    private void pushDownColumn(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, GridSqlAlias wrapAlias, GridSqlAst parent, int childIdx) {
        String uniqueColAlias;
        Object expr = parent.child(childIdx);
        if (expr instanceof GridSqlColumn) {
            GridSqlColumn col = (GridSqlColumn)parent.child(childIdx);
            GridSqlAlias tblAlias = (GridSqlAlias)col.expressionInFrom();
            assert (tblAlias != null);
            if (!tblAliases.contains(tblAlias)) {
                return;
            }
            uniqueColAlias = this.uniquePushDownColumnAlias(col);
        } else {
            uniqueColAlias = EXPR_ALIAS_PREFIX + this.nextExprAliasId++ + "__" + ((GridSqlAlias)parent).alias();
        }
        GridSqlType resType = expr.resultType();
        GridSqlAlias colAlias = cols.get(uniqueColAlias);
        if (colAlias == null) {
            colAlias = SplitterUtils.alias(uniqueColAlias, expr);
            cols.put(uniqueColAlias, colAlias);
            this.pushedDownCols.add(uniqueColAlias);
        }
        GridSqlColumn col = SplitterUtils.column(uniqueColAlias);
        col.expressionInFrom(wrapAlias);
        col.resultType(resType);
        parent.child(childIdx, col);
    }

    private String uniquePushDownColumnAlias(GridSqlColumn col) {
        String colName = col.columnName();
        if (this.pushedDownCols.contains(colName)) {
            return colName;
        }
        GridSqlAlias uniqueTblAlias = (GridSqlAlias)col.expressionInFrom();
        return GridSqlQuerySplitter.uniquePushDownColumnAlias(uniqueTblAlias.alias(), colName);
    }

    private static String uniquePushDownColumnAlias(String uniqueTblAlias, String colName) {
        assert (!F.isEmpty((String)uniqueTblAlias));
        assert (!F.isEmpty((String)colName));
        return uniqueTblAlias + "__" + colName;
    }

    private void pushDownWhereConditions(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, GridSqlAlias wrapAlias, GridSqlSelect select) {
        if (select.where() == null) {
            return;
        }
        GridSqlSelect wrapSelect = (GridSqlSelect)((GridSqlSubquery)GridSqlAlias.unwrap(wrapAlias)).subquery();
        ArrayList<SplitterAndCondition> andConditions = new ArrayList<SplitterAndCondition>();
        SplitterAndCondition.collectAndConditions(andConditions, select, 3);
        for (int i = 0; i < andConditions.size(); ++i) {
            SplitterAndCondition c = (SplitterAndCondition)andConditions.get(i);
            Object condition = c.ast();
            if (GridSqlQuerySplitter.isAllRelatedToTables(tblAliases, U.newIdentityHashSet(), condition)) {
                if (SplitterUtils.isTrue(condition)) continue;
                c.parent().child(c.childIndex(), GridSqlConst.TRUE);
                wrapSelect.whereAnd((GridSqlAst)condition);
                continue;
            }
            this.pushDownColumnsInExpression(tblAliases, cols, wrapAlias, c.parent(), c.childIndex());
        }
    }

    private static boolean isAllRelatedToTables(Set<GridSqlAlias> tblAliases, Set<GridSqlAlias> locSubQryTblAliases, GridSqlAst ast) {
        if (ast instanceof GridSqlColumn) {
            GridSqlColumn col = (GridSqlColumn)ast;
            if (!tblAliases.contains(col.expressionInFrom()) && !locSubQryTblAliases.contains(col.expressionInFrom())) {
                return false;
            }
        } else {
            if (ast instanceof GridSqlSelect) {
                ((GridSqlSelect)ast).collectFromAliases(locSubQryTblAliases);
            }
            for (int i = 0; i < ast.size(); ++i) {
                if (GridSqlQuerySplitter.isAllRelatedToTables(tblAliases, locSubQryTblAliases, ast.child(i))) continue;
                return false;
            }
        }
        return true;
    }

    private void splitQueryModel(SplitterQueryModel model) throws IgniteCheckedException {
        switch (model.type()) {
            case SELECT: {
                if (model.needSplit()) {
                    this.splitSelect(model.parent(), model.childIndex());
                    break;
                }
            }
            case UNION: {
                for (int i = 0; i < model.childModelsCount(); ++i) {
                    this.splitQueryModel(model.childModel(i));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Type: " + (Object)((Object)model.type()));
            }
        }
    }

    private void splitSelect(GridSqlAst parent, int childIdx) throws IgniteCheckedException {
        int i;
        if (++this.splitId > 99) {
            throw new CacheException("Too complex query to process.");
        }
        GridSqlSelect mapQry = (GridSqlSelect)parent.child(childIdx);
        int visibleCols = mapQry.visibleColumns();
        ArrayList<GridSqlAst> rdcExps = new ArrayList<GridSqlAst>(visibleCols);
        ArrayList<GridSqlAst> mapExps = new ArrayList<GridSqlAst>(mapQry.allColumns());
        mapExps.addAll(mapQry.columns(false));
        HashSet<String> colNames = new HashSet<String>();
        int havingCol = mapQry.havingColumn();
        boolean distinctAggregateFound = false;
        if (!this.collocatedGrpBy) {
            int len = mapExps.size();
            for (int i2 = 0; i2 < len; ++i2) {
                distinctAggregateFound |= SplitterUtils.hasDistinctAggregates((GridSqlAst)mapExps.get(i2));
            }
        }
        boolean aggregateFound = distinctAggregateFound;
        int len = mapExps.size();
        for (int i3 = 0; i3 < len; ++i3) {
            aggregateFound |= this.splitSelectExpression(mapExps, rdcExps, colNames, i3, this.collocatedGrpBy, i3 == havingCol, distinctAggregateFound);
        }
        assert (!this.collocatedGrpBy || !aggregateFound);
        GridSqlSelect rdcQry = new GridSqlSelect().from(GridSqlQuerySplitter.mergeTable(this.splitId));
        mapQry.clearColumns();
        for (GridSqlAst exp : mapExps) {
            mapQry.addColumn(exp, true);
        }
        for (i = 0; i < visibleCols; ++i) {
            rdcQry.addColumn((GridSqlAst)rdcExps.get(i), true);
        }
        for (i = visibleCols; i < rdcExps.size(); ++i) {
            rdcQry.addColumn((GridSqlAst)rdcExps.get(i), false);
        }
        for (i = rdcExps.size(); i < mapExps.size(); ++i) {
            rdcQry.addColumn(SplitterUtils.column(((GridSqlAlias)mapExps.get(i)).alias()), false);
        }
        if (mapQry.groupColumns() != null && !this.collocatedGrpBy) {
            rdcQry.groupColumns(mapQry.groupColumns());
            if (distinctAggregateFound) {
                mapQry.groupColumns(null);
            }
        }
        if (havingCol >= 0 && !this.collocatedGrpBy) {
            for (i = visibleCols; i < rdcQry.allColumns(); ++i) {
                GridSqlAst c = rdcQry.column(i);
                if (!(c instanceof GridSqlAlias) || !HAVING_COLUMN.equals(((GridSqlAlias)c).alias())) continue;
                rdcQry.havingColumn(i);
                break;
            }
            mapQry.havingColumn(-1);
        }
        if (!mapQry.sort().isEmpty()) {
            for (GridSqlSortColumn sortCol : mapQry.sort()) {
                rdcQry.addSort(sortCol);
            }
            if (aggregateFound) {
                mapQry.clearSort();
            }
        }
        if (mapQry.limit() != null) {
            rdcQry.limit(mapQry.limit());
            if (aggregateFound) {
                mapQry.limit(null);
            }
        }
        if (mapQry.offset() != null) {
            rdcQry.offset(mapQry.offset());
            if (mapQry.limit() != null) {
                mapQry.limit(SplitterUtils.op(GridSqlOperationType.PLUS, mapQry.offset(), mapQry.limit()));
            }
            mapQry.offset(null);
        }
        if (mapQry.distinct()) {
            mapQry.distinct(!aggregateFound && mapQry.groupColumns() == null && mapQry.havingColumn() < 0);
            rdcQry.distinct(true);
        }
        parent.child(childIdx, rdcQry);
        GridCacheSqlQuery map = new GridCacheSqlQuery(mapQry.getSQL());
        GridSqlQuerySplitter.setupParameters(map, mapQry, this.paramsCnt);
        SqlAstTraverser traverser = new SqlAstTraverser(mapQry, this.distributedJoins, this.log);
        traverser.traverse();
        map.columns(this.collectColumns(mapExps));
        map.sortColumns(mapQry.sort());
        map.partitioned(traverser.hasPartitionedTables());
        map.hasSubQueries(traverser.hasSubQueries());
        map.hasOuterJoinReplicatedPartitioned(traverser.hasOuterJoinReplicatedPartitioned());
        if (map.isPartitioned() && this.canExtractPartitions) {
            map.derivedPartitions((Object)this.extractor.extract(mapQry));
        }
        this.mapSqlQrys.add(map);
    }

    public static GridSqlAlias keyColumn(GridSqlSelect sel) {
        GridSqlAst from = sel.from();
        GridSqlTable tbl = from instanceof GridSqlTable ? (GridSqlTable)from : (GridSqlTable)((GridSqlElement)from).child();
        GridH2Table gridTbl = tbl.dataTable();
        Column h2KeyCol = gridTbl.getColumn(0);
        GridSqlColumn keyCol = new GridSqlColumn(h2KeyCol, tbl, h2KeyCol.getName());
        keyCol.resultType(GridSqlType.fromColumn(h2KeyCol));
        GridSqlAlias al = SplitterUtils.alias("_KEY", keyCol);
        return al;
    }

    private static void setupParameters(GridCacheSqlQuery sqlQry, GridSqlQuery qryAst, int paramsCnt) {
        TreeSet<Integer> paramIdxs = new TreeSet<Integer>();
        SplitterUtils.findParamsQuery(qryAst, paramsCnt, paramIdxs);
        int[] paramIdxsArr = new int[paramIdxs.size()];
        int i = 0;
        for (Integer paramIdx : paramIdxs) {
            paramIdxsArr[i++] = paramIdx;
        }
        sqlQry.parameterIndexes(paramIdxsArr);
    }

    private LinkedHashMap<String, ?> collectColumns(List<GridSqlAst> cols) {
        LinkedHashMap<String, GridSqlType> res = new LinkedHashMap<String, GridSqlType>(cols.size(), 1.0f, false);
        for (int i = 0; i < cols.size(); ++i) {
            String alias;
            GridSqlAst colUnwrapped;
            GridSqlAst col = cols.get(i);
            if (col instanceof GridSqlAlias) {
                colUnwrapped = col.child();
                alias = ((GridSqlAlias)col).alias();
            } else {
                colUnwrapped = col;
                alias = this.columnName(i);
            }
            GridSqlType type = colUnwrapped.resultType();
            if (type == null) {
                throw new NullPointerException("Column type: " + col);
            }
            if (res.put(alias, type) == null) continue;
            throw new IllegalStateException("Alias already exists: " + alias);
        }
        return res;
    }

    private void normalizeQuery(GridSqlQuery qry) {
        if (qry instanceof GridSqlUnion) {
            GridSqlUnion union = (GridSqlUnion)qry;
            this.normalizeQuery(union.left());
            this.normalizeQuery(union.right());
        } else {
            GridSqlSelect select = (GridSqlSelect)qry;
            this.normalizeFrom(select, 2, false);
            List<GridSqlAst> cols = select.columns(false);
            for (int i = 0; i < cols.size(); ++i) {
                this.normalizeExpression(select, GridSqlSelect.childIndexForColumn(i));
            }
            this.normalizeExpression(select, 3);
        }
        this.normalizeExpression(qry, 0);
        this.normalizeExpression(qry, 1);
    }

    private void generateUniqueAlias(GridSqlAst parent, int childIdx) {
        Object child = parent.child(childIdx);
        Object tbl = GridSqlAlias.unwrap(child);
        assert (tbl instanceof GridSqlTable || tbl instanceof GridSqlSubquery || tbl instanceof GridSqlFunction) : tbl.getClass();
        String uniqueAlias = this.nextUniqueTableAlias(tbl != child ? ((GridSqlAlias)child).alias() : null);
        GridSqlAlias uniqueAliasAst = new GridSqlAlias(uniqueAlias, (GridSqlAst)tbl);
        this.uniqueFromAliases.put((GridSqlAst)tbl, uniqueAliasAst);
        parent.child(childIdx, uniqueAliasAst);
    }

    private String nextUniqueTableAlias(String origAlias) {
        String uniqueAlias = UNIQUE_TABLE_ALIAS_SUFFIX + this.nextTblAliasId++;
        if (origAlias != null) {
            uniqueAlias = origAlias + uniqueAlias;
        }
        return uniqueAlias;
    }

    private void normalizeFrom(GridSqlAst parent, int childIdx, boolean parentAlias) {
        GridSqlElement from = (GridSqlElement)parent.child(childIdx);
        if (from instanceof GridSqlTable) {
            GridSqlTable tbl = (GridSqlTable)from;
            String schemaName = tbl.dataTable() != null ? tbl.dataTable().identifier().schema() : tbl.schema();
            String tblName = tbl.dataTable() != null ? tbl.dataTable().identifier().table() : tbl.tableName();
            this.tbls.add(new QueryTable(schemaName, tblName));
            if (!parentAlias) {
                this.generateUniqueAlias(parent, childIdx);
            }
        } else if (from instanceof GridSqlAlias) {
            this.normalizeFrom(from, 0, true);
            this.generateUniqueAlias(parent, childIdx);
        } else if (from instanceof GridSqlSubquery) {
            this.normalizeQuery((GridSqlQuery)((GridSqlSubquery)from).subquery());
            if (!parentAlias) {
                throw new IllegalStateException("No alias for subquery: " + from.getSQL());
            }
        } else if (from instanceof GridSqlJoin) {
            this.normalizeFrom(from, 0, false);
            this.normalizeFrom(from, 1, false);
            this.normalizeExpression(from, 2);
        } else if (from instanceof GridSqlFunction) {
            if (!parentAlias) {
                this.generateUniqueAlias(parent, childIdx);
            }
        } else {
            throw new IllegalStateException(from.getClass().getName() + " : " + from.getSQL());
        }
    }

    private void normalizeExpression(GridSqlAst parent, int childIdx) {
        Object el = parent.child(childIdx);
        if (el instanceof GridSqlAlias || el instanceof GridSqlOperation || el instanceof GridSqlFunction || el instanceof GridSqlArray) {
            for (int i = 0; i < el.size(); ++i) {
                this.normalizeExpression((GridSqlAst)el, i);
            }
        } else if (el instanceof GridSqlSubquery) {
            this.normalizeQuery((GridSqlQuery)((GridSqlSubquery)el).subquery());
        } else if (el instanceof GridSqlColumn) {
            GridSqlColumn col = (GridSqlColumn)el;
            Object tbl = GridSqlAlias.unwrap(col.expressionInFrom());
            GridSqlAlias uniqueAlias = this.uniqueFromAliases.get(tbl);
            assert (uniqueAlias != null) : childIdx + "\n" + parent.getSQL();
            col.tableAlias(uniqueAlias.alias());
            col.expressionInFrom(uniqueAlias);
        } else if (!(el instanceof GridSqlParameter || el instanceof GridSqlPlaceholder || el instanceof GridSqlConst)) {
            throw new IllegalStateException(el + ": " + el.getClass());
        }
    }

    private boolean splitSelectExpression(List<GridSqlAst> mapSelect, List<GridSqlAst> rdcSelect, Set<String> colNames, int idx, boolean collocatedGrpBy, boolean isHaving, boolean hasDistinctAggregate) {
        GridSqlAst el = mapSelect.get(idx);
        GridSqlAlias alias = null;
        boolean aggregateFound = false;
        if (el instanceof GridSqlAlias) {
            alias = (GridSqlAlias)el;
            el = alias.child();
        }
        if (!collocatedGrpBy && SplitterUtils.hasAggregates(el)) {
            aggregateFound = true;
            if (alias == null) {
                alias = SplitterUtils.alias(isHaving ? HAVING_COLUMN : this.columnName(idx), el);
            }
            this.splitAggregates(alias, 0, mapSelect, idx, hasDistinctAggregate, true);
            rdcSelect.add(alias);
        } else {
            String mapColAlias;
            String string = mapColAlias = isHaving ? HAVING_COLUMN : this.columnName(idx);
            String rdcColAlias = alias == null ? (el instanceof GridSqlColumn ? ((GridSqlColumn)el).columnName() : mapColAlias) : alias.alias();
            mapSelect.set(idx, SplitterUtils.alias(mapColAlias, el));
            GridSqlElement rdcEl = SplitterUtils.column(mapColAlias);
            if (colNames.add(rdcColAlias)) {
                rdcEl = SplitterUtils.alias(rdcColAlias, rdcEl);
            }
            rdcSelect.add(rdcEl);
        }
        return aggregateFound;
    }

    private boolean splitAggregates(GridSqlAst parentExpr, int childIdx, List<GridSqlAst> mapSelect, int exprIdx, boolean hasDistinctAggregate, boolean first) {
        Object el = parentExpr.child(childIdx);
        if (el instanceof GridSqlAggregateFunction) {
            this.splitAggregate(parentExpr, childIdx, mapSelect, exprIdx, hasDistinctAggregate, first);
            return true;
        }
        for (int i = 0; i < el.size(); ++i) {
            if (!this.splitAggregates((GridSqlAst)el, i, mapSelect, exprIdx, hasDistinctAggregate, first)) continue;
            first = false;
        }
        return !first;
    }

    private void splitAggregate(GridSqlAst parentExpr, int aggIdx, List<GridSqlAst> mapSelect, int exprIdx, boolean hasDistinctAggregate, boolean first) {
        GridSqlElement rdcAgg;
        GridSqlElement mapAgg;
        GridSqlAggregateFunction agg = (GridSqlAggregateFunction)parentExpr.child(aggIdx);
        assert (agg.resultType() != null);
        GridSqlAlias mapAggAlias = SplitterUtils.alias(this.columnName(first ? exprIdx : mapSelect.size()), GridSqlPlaceholder.EMPTY);
        if (first) {
            mapSelect.set(exprIdx, mapAggAlias);
        } else {
            mapSelect.add(mapAggAlias);
        }
        switch (agg.type()) {
            case AVG: {
                if (hasDistinctAggregate) {
                    mapAgg = (GridSqlElement)agg.child();
                    rdcAgg = SplitterUtils.aggregate(agg.distinct(), agg.type()).resultType(agg.resultType()).addChild(SplitterUtils.column(mapAggAlias.alias()));
                    break;
                }
                GridSqlElement cntMapAgg = SplitterUtils.aggregate(agg.distinct(), GridSqlFunctionType.COUNT).resultType(GridSqlType.BIGINT).addChild((GridSqlAst)agg.child());
                String cntMapAggAlias = this.columnName(mapSelect.size());
                cntMapAgg = SplitterUtils.alias(cntMapAggAlias, cntMapAgg);
                mapSelect.add(cntMapAgg);
                mapAgg = SplitterUtils.aggregate(agg.distinct(), GridSqlFunctionType.AVG).resultType(GridSqlType.DOUBLE).addChild(new GridSqlFunction(GridSqlFunctionType.CAST).resultType(GridSqlType.DOUBLE).addChild((GridSqlAst)agg.child()));
                GridSqlElement sumUpRdc = SplitterUtils.aggregate(false, GridSqlFunctionType.SUM).addChild(SplitterUtils.op(GridSqlOperationType.MULTIPLY, SplitterUtils.column(mapAggAlias.alias()), SplitterUtils.column(cntMapAggAlias)));
                GridSqlElement sumDownRdc = SplitterUtils.aggregate(false, GridSqlFunctionType.SUM).addChild(SplitterUtils.column(cntMapAggAlias));
                if (!SplitterUtils.isFractionalType(agg.resultType().type())) {
                    sumUpRdc = new GridSqlFunction(GridSqlFunctionType.CAST).resultType(GridSqlType.BIGINT).addChild(sumUpRdc);
                    sumDownRdc = new GridSqlFunction(GridSqlFunctionType.CAST).resultType(GridSqlType.BIGINT).addChild(sumDownRdc);
                }
                rdcAgg = new GridSqlFunction(GridSqlFunctionType.CAST).resultType(agg.resultType()).addChild(SplitterUtils.op(GridSqlOperationType.DIVIDE, sumUpRdc, sumDownRdc));
                break;
            }
            case SUM: 
            case MAX: 
            case MIN: {
                GridSqlElement rdcAgg0;
                if (hasDistinctAggregate) {
                    mapAgg = (GridSqlElement)agg.child();
                    rdcAgg0 = SplitterUtils.aggregate(agg.distinct(), agg.type()).addChild(SplitterUtils.column(mapAggAlias.alias()));
                } else {
                    mapAgg = SplitterUtils.aggregate(agg.distinct(), agg.type()).resultType(agg.resultType()).addChild((GridSqlAst)agg.child());
                    rdcAgg0 = new GridSqlFunction(GridSqlFunctionType.CAST).resultType(agg.resultType()).addChild(SplitterUtils.aggregate(agg.distinct(), agg.type()).addChild(SplitterUtils.column(mapAggAlias.alias())));
                }
                rdcAgg = new GridSqlFunction(GridSqlFunctionType.CAST).resultType(agg.resultType()).addChild(rdcAgg0);
                break;
            }
            case COUNT_ALL: 
            case COUNT: {
                if (hasDistinctAggregate) {
                    assert (agg.type() == GridSqlFunctionType.COUNT);
                    mapAgg = (GridSqlElement)agg.child();
                    rdcAgg = SplitterUtils.aggregate(agg.distinct(), agg.type()).resultType(GridSqlType.BIGINT).addChild(SplitterUtils.column(mapAggAlias.alias()));
                    break;
                }
                mapAgg = SplitterUtils.aggregate(agg.distinct(), agg.type()).resultType(GridSqlType.BIGINT);
                if (agg.type() == GridSqlFunctionType.COUNT) {
                    mapAgg.addChild((GridSqlAst)agg.child());
                }
                rdcAgg = SplitterUtils.aggregate(false, GridSqlFunctionType.SUM).addChild(SplitterUtils.column(mapAggAlias.alias()));
                rdcAgg = new GridSqlFunction(GridSqlFunctionType.CAST).resultType(GridSqlType.BIGINT).addChild(rdcAgg);
                break;
            }
            case GROUP_CONCAT: {
                if (agg.distinct() || agg.hasGroupConcatOrder()) {
                    throw new IgniteSQLException("Clauses DISTINCT and ORDER BY are unsupported for GROUP_CONCAT for not collocated data.", 1002);
                }
                mapAgg = hasDistinctAggregate ? (GridSqlElement)agg.child() : SplitterUtils.aggregate(agg.distinct(), agg.type()).setGroupConcatSeparator(agg.getGroupConcatSeparator()).resultType(GridSqlType.STRING).addChild((GridSqlAst)agg.child());
                rdcAgg = SplitterUtils.aggregate(false, GridSqlFunctionType.GROUP_CONCAT).setGroupConcatSeparator(agg.getGroupConcatSeparator()).resultType(GridSqlType.STRING).addChild(SplitterUtils.column(mapAggAlias.alias()));
                break;
            }
            default: {
                throw new IgniteException("Unsupported aggregate: " + (Object)((Object)agg.type()));
            }
        }
        assert (!(mapAgg instanceof GridSqlAlias));
        assert (mapAgg.resultType() != null);
        mapAggAlias.child(0, mapAgg);
        mapAggAlias.resultType(mapAgg.resultType());
        parentExpr.child(aggIdx, rdcAgg);
    }

    private static Prepared prepare(H2PooledConnection c, QueryContext qctx, String qry, boolean distributedJoins, boolean enforceJoinOrder) throws SQLException, IgniteCheckedException {
        H2Utils.setupConnection(c, qctx, distributedJoins, enforceJoinOrder);
        try (PreparedStatement s = c.prepareStatement(qry, H2StatementCache.queryFlags(distributedJoins, enforceJoinOrder));){
            Prepared prepared = GridSqlQueryParser.prepared(s);
            return prepared;
        }
    }
}

