/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2PkHashIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneIndex;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.index.Index;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2TableDescriptor {
    public static final String PK_IDX_NAME = "_key_PK";
    public static final String PK_HASH_IDX_NAME = "_key_PK_hash";
    public static final String AFFINITY_KEY_IDX_NAME = "AFFINITY_KEY";
    private final IgniteH2Indexing idx;
    private final String fullTblName;
    private final GridQueryTypeDescriptor type;
    private final String schemaName;
    private final GridCacheContextInfo cacheInfo;
    private GridH2Table tbl;
    private GridLuceneIndex luceneIdx;
    private H2PkHashIndex pkHashIdx;
    private boolean isSql;

    public H2TableDescriptor(IgniteH2Indexing idx, String schemaName, GridQueryTypeDescriptor type, GridCacheContextInfo cacheInfo, boolean isSql) {
        this.idx = idx;
        this.type = type;
        this.schemaName = schemaName;
        this.cacheInfo = cacheInfo;
        this.isSql = isSql;
        this.fullTblName = H2Utils.withQuotes(schemaName) + "." + H2Utils.withQuotes(type.tableName());
    }

    public boolean sql() {
        return this.isSql;
    }

    public IgniteH2Indexing indexing() {
        return this.idx;
    }

    public GridH2Table table() {
        return this.tbl;
    }

    public void table(GridH2Table tbl) {
        this.tbl = tbl;
    }

    public String schemaName() {
        return this.schemaName;
    }

    String tableName() {
        return this.type.tableName();
    }

    String fullTableName() {
        return this.fullTblName;
    }

    String typeName() {
        return this.type.name();
    }

    public String cacheName() {
        return this.cacheInfo.name();
    }

    public GridCacheContextInfo cacheInfo() {
        return this.cacheInfo;
    }

    public GridCacheContext cache() {
        return this.cacheInfo.cacheContext();
    }

    GridQueryTypeDescriptor type() {
        return this.type;
    }

    GridLuceneIndex luceneIndex() {
        return this.luceneIdx;
    }

    public String toString() {
        return S.toString(H2TableDescriptor.class, (Object)this);
    }

    public ArrayList<Index> createSystemIndexes(GridH2Table tbl) {
        GridQueryIndexDescriptor textIdx;
        ArrayList<Index> idxs = new ArrayList<Index>();
        IndexColumn keyCol = tbl.indexColumn(0, 0);
        IndexColumn affCol = tbl.getAffinityKeyColumn();
        if (affCol != null && H2Utils.equals(affCol, keyCol)) {
            affCol = null;
        }
        List<IndexColumn> unwrappedKeyAndAffinityCols = this.extractKeyColumns(tbl, keyCol, affCol);
        List<IndexColumn> wrappedKeyCols = H2Utils.treeIndexColumns(tbl.rowDescriptor(), new ArrayList<IndexColumn>(2), keyCol, affCol);
        Index hashIdx = this.createHashIndex(tbl, wrappedKeyCols);
        if (hashIdx != null) {
            idxs.add(hashIdx);
        }
        GridH2IndexBase pkIdx = this.idx.createSortedIndex(PK_IDX_NAME, tbl, true, false, unwrappedKeyAndAffinityCols, wrappedKeyCols, -1, null);
        idxs.add((Index)pkIdx);
        if (this.type().valueClass() == String.class && !this.idx.distributedConfiguration().isDisableCreateLuceneIndexForStringValueType()) {
            try {
                this.luceneIdx = new GridLuceneIndex(this.idx.kernalContext(), tbl.cacheName(), this.type);
            }
            catch (IgniteCheckedException e1) {
                throw new IgniteException((Throwable)e1);
            }
        }
        if ((textIdx = this.type.textIndex()) != null) {
            try {
                this.luceneIdx = new GridLuceneIndex(this.idx.kernalContext(), tbl.cacheName(), this.type);
            }
            catch (IgniteCheckedException e1) {
                throw new IgniteException((Throwable)e1);
            }
        }
        if (affCol != null) {
            boolean affIdxFound = false;
            for (GridQueryIndexDescriptor idxDesc : this.type.indexes().values()) {
                if (idxDesc.type() != QueryIndexType.SORTED) continue;
                String firstField = (String)idxDesc.fields().iterator().next();
                Column col = tbl.getColumn(firstField);
                IndexColumn idxCol = tbl.indexColumn(col.getColumnId(), idxDesc.descending(firstField) ? 1 : 0);
                affIdxFound |= H2Utils.equals(idxCol, affCol);
            }
            if (!affIdxFound) {
                List<IndexColumn> unwrappedKeyCols = this.extractKeyColumns(tbl, keyCol, null);
                ArrayList<IndexColumn> colsWithUnwrappedKey = new ArrayList<IndexColumn>(unwrappedKeyCols.size());
                colsWithUnwrappedKey.add(affCol);
                H2Utils.addUniqueColumns(colsWithUnwrappedKey, unwrappedKeyCols);
                List<IndexColumn> cols = H2Utils.treeIndexColumns(tbl.rowDescriptor(), new ArrayList<IndexColumn>(2), affCol, keyCol);
                idxs.add((Index)this.idx.createSortedIndex(AFFINITY_KEY_IDX_NAME, tbl, false, true, colsWithUnwrappedKey, cols, -1, null));
            }
        }
        return idxs;
    }

    @NotNull
    private List<IndexColumn> extractKeyColumns(GridH2Table tbl, IndexColumn keyCol, IndexColumn affCol) {
        ArrayList<IndexColumn> keyCols;
        if (this.isSql) {
            keyCols = new ArrayList(this.type.fields().size() + 1);
            if (QueryUtils.isSqlType((Class)this.type.keyClass())) {
                keyCols.add(keyCol);
            } else {
                if (!this.type.primaryKeyFields().isEmpty()) {
                    for (String keyName : this.type.primaryKeyFields()) {
                        GridQueryProperty prop = this.type.property(keyName);
                        assert (prop.key()) : keyName + " is not a key field";
                        Column col = tbl.getColumn(prop.name());
                        keyCols.add(tbl.indexColumn(col.getColumnId(), 0));
                    }
                } else {
                    for (String propName : this.type.fields().keySet()) {
                        GridQueryProperty prop = this.type.property(propName);
                        if (!prop.key()) continue;
                        Column col = tbl.getColumn(propName);
                        keyCols.add(tbl.indexColumn(col.getColumnId(), 0));
                    }
                }
                if (keyCols.isEmpty()) {
                    keyCols.add(keyCol);
                }
            }
        } else {
            keyCols = new ArrayList<IndexColumn>(2);
            keyCols.add(keyCol);
        }
        if (affCol != null && !H2Utils.containsColumn(keyCols, affCol)) {
            keyCols.add(affCol);
        } else {
            keyCols.trimToSize();
        }
        return Collections.unmodifiableList(keyCols);
    }

    public Collection<GridH2IndexBase> createUserIndexes() {
        assert (this.tbl != null);
        ArrayList<GridH2IndexBase> res = new ArrayList<GridH2IndexBase>();
        for (GridQueryIndexDescriptor idxDesc : this.type.indexes().values()) {
            GridH2IndexBase idx = this.createUserIndex(idxDesc, null);
            res.add(idx);
        }
        return res;
    }

    public GridH2IndexBase createUserIndex(GridQueryIndexDescriptor idxDesc, @Nullable SchemaIndexCacheVisitor cacheVisitor) {
        IndexColumn keyCol = this.tbl.indexColumn(0, 0);
        IndexColumn affCol = this.tbl.getAffinityKeyColumn();
        List<IndexColumn> cols = new ArrayList<IndexColumn>(idxDesc.fields().size() + 2);
        for (String field : idxDesc.fields()) {
            Column col = this.tbl.getColumn(field);
            cols.add(this.tbl.indexColumn(col.getColumnId(), idxDesc.descending(field) ? 1 : 0));
        }
        GridH2RowDescriptor desc = this.tbl.rowDescriptor();
        if (idxDesc.type() == QueryIndexType.SORTED) {
            List<IndexColumn> unwrappedKeyCols = this.extractKeyColumns(this.tbl, keyCol, affCol);
            ArrayList<IndexColumn> colsWithUnwrappedKey = new ArrayList<IndexColumn>(cols);
            H2Utils.addUniqueColumns(colsWithUnwrappedKey, unwrappedKeyCols);
            cols = H2Utils.treeIndexColumns(desc, cols, keyCol, affCol);
            return this.idx.createSortedIndex(idxDesc.name(), this.tbl, false, false, colsWithUnwrappedKey, cols, idxDesc.inlineSize(), cacheVisitor);
        }
        if (idxDesc.type() == QueryIndexType.GEOSPATIAL) {
            return H2Utils.createSpatialIndex(this.tbl, idxDesc.name(), cols);
        }
        throw new IllegalStateException("Index type: " + idxDesc.type());
    }

    private Index createHashIndex(GridH2Table tbl, List<IndexColumn> cols) {
        if (this.cacheInfo.affinityNode()) {
            assert (this.pkHashIdx == null) : this.pkHashIdx;
            this.pkHashIdx = new H2PkHashIndex(this.cacheInfo.cacheContext(), tbl, PK_HASH_IDX_NAME, cols, tbl.rowDescriptor().context().config().getQueryParallelism());
            return this.pkHashIdx;
        }
        return null;
    }

    void onDrop() {
        this.tbl.destroy();
        U.closeQuiet((AutoCloseable)this.luceneIdx);
    }
}

