/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.query.h2.DistributedSqlConfiguration;
import org.h2.expression.Function;

public class FunctionsManager {
    private static HashMap<String, Object> origFuncs;
    private static HashMap<String, Object> funcs;

    public FunctionsManager(DistributedSqlConfiguration distSqlCfg) {
        assert (Objects.nonNull(funcs));
        assert (Objects.nonNull(origFuncs));
        distSqlCfg.listenDisabledFunctions((DistributePropertyListener<HashSet<String>>)((DistributePropertyListener)this::updateDisabledFunctions));
    }

    private void updateDisabledFunctions(String paramName, HashSet<String> oldDisabledFuncs, HashSet<String> newDisabledFuncs) {
        if (newDisabledFuncs != null) {
            FunctionsManager.removeFunctions(newDisabledFuncs);
        } else {
            FunctionsManager.removeFunctions(DistributedSqlConfiguration.DFLT_DISABLED_FUNCS);
        }
    }

    private static void removeFunctions(Set<String> funcNames) {
        funcs.putAll(origFuncs);
        funcs.keySet().removeAll(funcNames);
    }

    static {
        try {
            Field fldFUNCTIONS = Function.class.getDeclaredField("FUNCTIONS");
            fldFUNCTIONS.setAccessible(true);
            funcs = (HashMap)fldFUNCTIONS.get(Class.class);
            origFuncs = new HashMap<String, Object>(funcs);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

