/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.exceptions.QueryConsistencyException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;

public class ReadFailureException
extends QueryConsistencyException {
    private final int failed;
    private final boolean dataPresent;
    private final Map<InetAddress, Integer> failuresMap;

    public ReadFailureException(ConsistencyLevel consistency, int received, int required, int failed, Map<InetAddress, Integer> failuresMap, boolean dataPresent) {
        this(null, consistency, received, required, failed, failuresMap, dataPresent);
    }

    @Deprecated
    public ReadFailureException(ConsistencyLevel consistency, int received, int required, int failed, boolean dataPresent) {
        this(null, consistency, received, required, failed, Collections.emptyMap(), dataPresent);
    }

    public ReadFailureException(InetSocketAddress address, ConsistencyLevel consistency, int received, int required, int failed, Map<InetAddress, Integer> failuresMap, boolean dataPresent) {
        super(address, String.format("Cassandra failure during read query at consistency %s (%d responses were required but only %d replica responded, %d failed)", new Object[]{consistency, required, received, failed}), consistency, received, required);
        this.failed = failed;
        this.failuresMap = failuresMap;
        this.dataPresent = dataPresent;
    }

    @Deprecated
    public ReadFailureException(InetSocketAddress address, ConsistencyLevel consistency, int received, int required, int failed, boolean dataPresent) {
        this(address, consistency, received, required, failed, Collections.emptyMap(), dataPresent);
    }

    private ReadFailureException(InetSocketAddress address, String msg, Throwable cause, ConsistencyLevel consistency, int received, int required, int failed, Map<InetAddress, Integer> failuresMap, boolean dataPresent) {
        super(address, msg, cause, consistency, received, required);
        this.failed = failed;
        this.failuresMap = failuresMap;
        this.dataPresent = dataPresent;
    }

    public int getFailures() {
        return this.failed;
    }

    public Map<InetAddress, Integer> getFailuresMap() {
        return this.failuresMap;
    }

    public boolean wasDataRetrieved() {
        return this.dataPresent;
    }

    @Override
    public ReadFailureException copy() {
        return new ReadFailureException(this.getAddress(), this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.getFailures(), this.getFailuresMap(), this.wasDataRetrieved());
    }

    public ReadFailureException copy(InetSocketAddress address) {
        return new ReadFailureException(address, this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.failed, this.getFailuresMap(), this.dataPresent);
    }
}

