/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;

class SqlAstTraverser {
    private final GridSqlAst root;
    private final boolean distributedJoins;
    private final IgniteLogger log;
    private boolean hasPartitionedTables;
    private boolean hasSubQueries;
    private boolean hasOuterJoinReplicatedPartitioned;

    SqlAstTraverser(GridSqlAst root, boolean distributedJoins, IgniteLogger log) {
        this.root = root;
        this.distributedJoins = distributedJoins;
        this.log = log;
    }

    public void traverse() {
        this.lookForPartitionedJoin(this.root, null);
    }

    public boolean hasPartitionedTables() {
        return this.hasPartitionedTables;
    }

    public boolean hasSubQueries() {
        return this.hasSubQueries;
    }

    public boolean hasOuterJoinReplicatedPartitioned() {
        return this.hasOuterJoinReplicatedPartitioned;
    }

    private void lookForPartitionedJoin(GridSqlAst ast, GridSqlAst upWhere) {
        if (ast == null) {
            return;
        }
        GridSqlJoin join = null;
        GridSqlAst where = null;
        if (ast instanceof GridSqlJoin) {
            join = (GridSqlJoin)ast;
            where = upWhere;
        } else if (ast instanceof GridSqlSelect) {
            GridSqlSelect select = (GridSqlSelect)ast;
            if (select.from() instanceof GridSqlJoin) {
                join = (GridSqlJoin)select.from();
                where = select.where();
            }
        } else if (ast instanceof GridSqlSubquery) {
            this.hasSubQueries = true;
        } else if (ast instanceof GridSqlTable) {
            this.hasPartitionedTables |= ((GridSqlTable)ast).dataTable().isPartitioned();
        }
        if (join == null) {
            for (int i = 0; i < ast.size(); ++i) {
                this.lookForPartitionedJoin((GridSqlAst)ast.child(i), null);
            }
            return;
        }
        this.lookForPartitionedJoin(where, null);
        GridSqlTable leftTable = this.getTable(join.leftTable());
        GridH2Table left = null;
        if (leftTable == null) {
            this.hasSubQueries = true;
            this.lookForPartitionedJoin(join.leftTable(), where);
        } else {
            left = leftTable.dataTable();
            if (left != null && left.isPartitioned()) {
                this.hasPartitionedTables = true;
            }
        }
        GridSqlTable rightTable = this.getTable(join.rightTable());
        if (rightTable == null) {
            this.hasSubQueries = true;
            this.lookForPartitionedJoin(join.rightTable(), where);
            return;
        }
        GridH2Table right = rightTable.dataTable();
        if (right != null && right.isPartitioned()) {
            this.hasPartitionedTables = true;
        }
        if (left == null || right == null) {
            return;
        }
        if (join.isLeftOuter() && !left.isPartitioned() && right.isPartitioned()) {
            this.hasOuterJoinReplicatedPartitioned = true;
        }
        if (!left.isPartitioned() || !right.isPartitioned()) {
            return;
        }
        if (!this.distributedJoins) {
            this.checkPartitionedJoin(join, where, left, right, this.log);
        }
    }

    private void checkPartitionedJoin(GridSqlJoin join, GridSqlAst where, GridH2Table left, GridH2Table right, IgniteLogger log) {
        String leftTblAls = this.getAlias(join.leftTable());
        String rightTblAls = this.getAlias(join.rightTable());
        boolean pkLeft = left.getExplicitAffinityKeyColumn() == null;
        boolean pkRight = right.getExplicitAffinityKeyColumn() == null;
        Set<String> leftAffKeys = this.affKeys(pkLeft, left);
        Set<String> rightAffKeys = this.affKeys(pkRight, right);
        boolean joinIsValid = this.checkPartitionedCondition(join.on(), leftTblAls, leftAffKeys, pkLeft, rightTblAls, rightAffKeys, pkRight);
        if (!joinIsValid && where instanceof GridSqlElement) {
            joinIsValid = this.checkPartitionedCondition((GridSqlElement)where, leftTblAls, leftAffKeys, pkLeft, rightTblAls, rightAffKeys, pkRight);
        }
        if (!joinIsValid) {
            log.warning(String.format("For join two partitioned tables join condition should contain the equality operation of affinity keys. Left side: %s; right side: %s", left.getName(), right.getName()));
        }
    }

    private GridSqlTable getTable(GridSqlElement el) {
        if (el instanceof GridSqlTable) {
            return (GridSqlTable)el;
        }
        if (el instanceof GridSqlAlias && el.child() instanceof GridSqlTable) {
            return (GridSqlTable)el.child();
        }
        return null;
    }

    private String getAlias(GridSqlElement el) {
        if (el instanceof GridSqlAlias) {
            return ((GridSqlAlias)el).alias();
        }
        return null;
    }

    private Set<String> affKeys(boolean pk, GridH2Table tbl) {
        HashSet<String> affKeys = new HashSet<String>();
        if (!pk) {
            affKeys.add(tbl.getAffinityKeyColumn().columnName);
        } else {
            affKeys.add("_KEY");
            String keyFieldName = tbl.rowDescriptor().type().keyFieldName();
            if (keyFieldName == null) {
                affKeys.addAll(tbl.rowDescriptor().type().primaryKeyFields());
            } else {
                affKeys.add(keyFieldName);
            }
        }
        return affKeys;
    }

    private boolean checkPartitionedCondition(GridSqlElement condition, String leftTbl, Set<String> leftAffKeys, boolean pkLeft, String rightTbl, Set<String> rightAffKeys, boolean pkRight) {
        if (!(condition instanceof GridSqlOperation)) {
            return false;
        }
        GridSqlOperation op = (GridSqlOperation)condition;
        if (GridSqlOperationType.EQUAL == op.operationType()) {
            this.checkEqualityOperation(op, leftTbl, leftAffKeys, pkLeft, rightTbl, rightAffKeys, pkRight);
        }
        if (this.affinityCondIsCovered(leftAffKeys, rightAffKeys)) {
            return true;
        }
        if (GridSqlOperationType.AND != op.operationType()) {
            return false;
        }
        for (int i = 0; i < op.size(); ++i) {
            boolean ret = this.checkPartitionedCondition((GridSqlElement)op.child(i), leftTbl, leftAffKeys, pkLeft, rightTbl, rightAffKeys, pkRight);
            if (!ret) continue;
            return true;
        }
        return false;
    }

    private void checkEqualityOperation(GridSqlOperation equalOp, String leftTbl, Set<String> leftCols, boolean pkLeft, String rightTbl, Set<String> rightCols, boolean pkRight) {
        int rightColIdx;
        int leftColIdx;
        if (!(equalOp.child(0) instanceof GridSqlColumn)) {
            return;
        }
        if (!(equalOp.child(1) instanceof GridSqlColumn)) {
            return;
        }
        String leftTblAls = ((GridSqlColumn)equalOp.child(0)).tableAlias();
        String rightTblAls = ((GridSqlColumn)equalOp.child(1)).tableAlias();
        int n = leftTbl.equals(leftTblAls) ? 0 : (leftColIdx = leftTbl.equals(rightTblAls) ? 1 : -1);
        int n2 = rightTbl.equals(rightTblAls) ? 1 : (rightColIdx = rightTbl.equals(leftTblAls) ? 0 : -1);
        if (leftColIdx == -1 || rightColIdx == -1) {
            return;
        }
        String leftCol = ((GridSqlColumn)equalOp.child(leftColIdx)).columnName();
        String rightCol = ((GridSqlColumn)equalOp.child(rightColIdx)).columnName();
        if (leftCols.contains(leftCol) && rightCols.contains(rightCol)) {
            leftCols.remove(leftCol);
            rightCols.remove(rightCol);
            if (pkLeft && (leftCols.size() == 1 || "_KEY".equals(leftCol))) {
                leftCols.clear();
            }
            if (pkRight && (rightCols.size() == 1 || "_KEY".equals(rightCol))) {
                rightCols.clear();
            }
        }
    }

    private boolean affinityCondIsCovered(Set<String> leftAffKeys, Set<String> rightAffKeys) {
        return leftAffKeys.isEmpty() && rightAffKeys.isEmpty();
    }
}

