/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.load;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.CacheException;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.IgniteNode;
import org.apache.ignite.yardstick.cache.load.model.ModelUtil;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteCacheRandomOperationBenchmark
extends IgniteAbstractBenchmark {
    public static final int operations = Operation.values().length;
    public static final int CONTINUOUS_QUERY_PER_CACHE = 3;
    private static BenchmarkIgniteBiPredicate igniteBiPred = new BenchmarkIgniteBiPredicate();
    private static final int SCAN_QUERY_PARTITION_AMOUNT = 10;
    private List<IgniteCache<Object, Object>> availableCaches;
    private List<IgniteCache<Object, Object>> txCaches;
    private List<IgniteCache<Object, Object>> affCaches;
    private Map<String, Class[]> keysCacheClasses;
    private Map<String, Class[]> valuesCacheClasses;
    private Map<String, List<SqlCacheDescriptor>> cacheSqlDescriptors;
    private List<TestQuery> queries;
    private List<Operation> allowedLoadTestOps;
    private BenchmarkReplaceValueEntryProcessor replaceEntryProc;
    private BenchmarkRemoveEntryProcessor rmvEntryProc;
    private Map<String, AtomicLong> operationStatistics;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        if (this.args.additionalCachesNumber() > 0) {
            this.createAdditionalCaches();
        }
        this.searchCache();
        this.preLoading();
    }

    private void createAdditionalCaches() throws Exception {
        Map cfgMap;
        try {
            cfgMap = ((ApplicationContext)IgniteNode.loadConfiguration(this.args.configuration()).get2()).getBeansOfType(CacheConfiguration.class);
        }
        catch (BeansException e) {
            throw new Exception("Failed to instantiate bean [type=" + CacheConfiguration.class + ", err=" + e.getMessage() + ']', e);
        }
        if (cfgMap == null || cfgMap.isEmpty()) {
            throw new Exception("Failed to find cache configurations in: " + this.args.configuration());
        }
        CacheConfiguration ccfg = (CacheConfiguration)cfgMap.get(this.args.additionalCachesName());
        if (ccfg == null) {
            throw new Exception("Failed to find cache configuration [cache=" + this.args.additionalCachesName() + ", cfg=" + this.args.configuration() + ']');
        }
        for (int i = 0; i < this.args.additionalCachesNumber(); ++i) {
            CacheConfiguration newCfg = new CacheConfiguration((CompleteConfiguration)ccfg);
            newCfg.setName("additional_" + this.args.additionalCachesName() + "_cache_" + i);
            try {
                this.ignite().createCache(newCfg);
                continue;
            }
            catch (CacheException e) {
                BenchmarkUtils.error((String)("Failed to create additional cache [ name = " + this.args.additionalCachesName() + ", err" + e.getMessage() + ']'), (Throwable)e);
            }
        }
    }

    public void onException(Throwable e) {
        BenchmarkUtils.error((String)"The benchmark of random operation failed.", (Throwable)e);
        super.onException(e);
    }

    public boolean test(Map<Object, Object> map) throws Exception {
        if (this.nextBoolean()) {
            this.executeInTransaction(map);
            this.executeOutOfTx(map, true);
        } else {
            this.executeOutOfTx(map, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            BenchmarkUtils.println((String)"Benchmark statistics");
            for (String cacheName : this.ignite().cacheNames()) {
                BenchmarkUtils.println((String)String.format("Operations over cache '%s'", cacheName));
                for (Operation op : Operation.values()) {
                    BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)String.format("%s: %s", new Object[]{op, this.operationStatistics.get((Object)((Object)op) + "_" + cacheName)}));
                }
            }
        }
        finally {
            super.tearDown();
        }
    }

    private void searchCache() throws Exception {
        this.availableCaches = new ArrayList<IgniteCache<Object, Object>>(this.ignite().cacheNames().size());
        this.txCaches = new ArrayList<IgniteCache<Object, Object>>();
        this.affCaches = new ArrayList<IgniteCache<Object, Object>>();
        this.keysCacheClasses = new HashMap<String, Class[]>();
        this.valuesCacheClasses = new HashMap<String, Class[]>();
        this.replaceEntryProc = new BenchmarkReplaceValueEntryProcessor(null);
        this.rmvEntryProc = new BenchmarkRemoveEntryProcessor();
        this.cacheSqlDescriptors = new HashMap<String, List<SqlCacheDescriptor>>();
        this.operationStatistics = new HashMap<String, AtomicLong>();
        this.loadQueries();
        this.loadAllowedOperations();
        for (String cacheName : this.ignite().cacheNames()) {
            IgniteCache cache = this.ignite().cache(cacheName);
            for (Operation op : Operation.values()) {
                this.operationStatistics.put((Object)((Object)op) + "_" + cacheName, new AtomicLong(0L));
            }
            CacheConfiguration configuration = (CacheConfiguration)cache.getConfiguration(CacheConfiguration.class);
            if (this.isClassDefinedInConfig(configuration)) {
                Class<?> valCls;
                Class<?> keyCls;
                ArrayList keys = new ArrayList();
                ArrayList values = new ArrayList();
                if (configuration.getQueryEntities() != null) {
                    Collection entries = configuration.getQueryEntities();
                    for (QueryEntity queryEntity : entries) {
                        try {
                            if (queryEntity.getKeyType() != null) {
                                keyCls = Class.forName(queryEntity.getKeyType());
                                if (ModelUtil.canCreateInstance(keyCls)) {
                                    keys.add(keyCls);
                                } else {
                                    throw new IgniteException("Class is unknown for the load test. Make sure you specified its full name [cache=" + cacheName + ", clsName=" + queryEntity.getKeyType() + ']');
                                }
                            }
                            if (queryEntity.getValueType() == null) continue;
                            valCls = Class.forName(queryEntity.getValueType());
                            if (!ModelUtil.canCreateInstance(valCls)) {
                                throw new IgniteException("Class is unknown for the load test. Make sure you specified its full name [cache=" + cacheName + ", clsName=" + queryEntity.getValueType() + ']');
                            }
                            values.add(valCls);
                            this.configureCacheSqlDescriptor(cacheName, queryEntity, valCls);
                        }
                        catch (ClassNotFoundException e) {
                            BenchmarkUtils.println((String)e.getMessage());
                            BenchmarkUtils.println((String)"This can be a BinaryObject. Ignoring exception.");
                            if (this.cacheSqlDescriptors.containsKey(cacheName)) continue;
                            this.cacheSqlDescriptors.put(cacheName, new ArrayList());
                        }
                    }
                }
                if (configuration.getQueryEntities() != null) {
                    Collection entities = configuration.getQueryEntities();
                    for (QueryEntity entity : entities) {
                        try {
                            if (entity.getKeyType() != null) {
                                keyCls = Class.forName(entity.getKeyType());
                                if (ModelUtil.canCreateInstance(keyCls)) {
                                    keys.add(keyCls);
                                } else {
                                    throw new IgniteException("Class is unknown for the load test. Make sure you specified its full name [clsName=" + entity.getKeyType() + ']');
                                }
                            }
                            if (entity.getValueType() == null) continue;
                            valCls = Class.forName(entity.getValueType());
                            if (ModelUtil.canCreateInstance(valCls)) {
                                values.add(valCls);
                                continue;
                            }
                            throw new IgniteException("Class is unknown for the load test. Make sure you specified its full name [clsName=" + entity.getKeyType() + ']');
                        }
                        catch (ClassNotFoundException e) {
                            BenchmarkUtils.println((String)e.getMessage());
                            BenchmarkUtils.println((String)"This can be a BinaryObject. Ignoring exception.");
                            if (this.cacheSqlDescriptors.containsKey(cacheName)) continue;
                            this.cacheSqlDescriptors.put(cacheName, new ArrayList());
                        }
                    }
                }
                this.keysCacheClasses.put(cacheName, keys.toArray(new Class[0]));
                this.valuesCacheClasses.put(cacheName, values.toArray(new Class[0]));
            } else {
                this.keysCacheClasses.put(cacheName, new Class[]{this.randomKeyClass(cacheName)});
            }
            this.valuesCacheClasses.put(cacheName, this.determineValueClasses(cacheName));
            if (configuration.getCacheMode() != CacheMode.LOCAL) {
                this.affCaches.add((IgniteCache<Object, Object>)cache);
            }
            if (configuration.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL) {
                this.txCaches.add((IgniteCache<Object, Object>)cache);
            }
            this.availableCaches.add((IgniteCache<Object, Object>)cache);
        }
    }

    private void loadAllowedOperations() {
        this.allowedLoadTestOps = new ArrayList<Operation>();
        if (this.args.allowedLoadTestOps().isEmpty()) {
            Collections.addAll(this.allowedLoadTestOps, Operation.values());
        } else {
            for (String opName : this.args.allowedLoadTestOps()) {
                this.allowedLoadTestOps.add(Operation.valueOf(opName.toUpperCase()));
            }
        }
    }

    private void loadQueries() throws Exception {
        this.queries = new ArrayList<TestQuery>();
        if (this.args.loadTestQueriesFile() != null) {
            try (FileReader fr = new FileReader(this.args.loadTestQueriesFile());
                 BufferedReader br = new BufferedReader(fr);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    boolean distributedJoins = false;
                    int commentIdx = line.lastIndexOf(35);
                    if (commentIdx >= 0) {
                        if (line.toUpperCase().indexOf("DISTRIBUTEDJOINS", commentIdx) > 0) {
                            distributedJoins = true;
                        }
                        line = line.substring(0, commentIdx);
                    }
                    line = line.trim();
                    TestQuery qry = new TestQuery(line, distributedJoins);
                    this.queries.add(qry);
                    BenchmarkUtils.println((String)("Loaded query: " + qry));
                }
            }
        }
    }

    private void configureCacheSqlDescriptor(String cacheName, QueryEntity qryEntity, Class valCls) throws ClassNotFoundException {
        List<SqlCacheDescriptor> descs = this.cacheSqlDescriptors.get(cacheName);
        if (descs == null) {
            descs = new ArrayList<SqlCacheDescriptor>();
            this.cacheSqlDescriptors.put(cacheName, descs);
        }
        HashMap<String, Class> indexedFields = new HashMap<String, Class>();
        for (QueryIndex index : qryEntity.getIndexes()) {
            for (String iField : index.getFieldNames()) {
                indexedFields.put(iField, Class.forName((String)qryEntity.getFields().get(iField)));
            }
        }
        descs.add(new SqlCacheDescriptor(valCls, qryEntity.getFields().keySet(), indexedFields));
    }

    private boolean isClassDefinedInConfig(CacheConfiguration configuration) {
        return configuration.getIndexedTypes() != null && configuration.getIndexedTypes().length > 0 || !CollectionUtils.isEmpty((Collection)configuration.getQueryEntities());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preLoading() throws Exception {
        if (this.args.preloadAmount() > this.args.range()) {
            throw new IllegalArgumentException("Preloading amount (\"-pa\", \"--preloadAmount\") must by less then the range (\"-r\", \"--range\").");
        }
        this.startPreloadLogging(this.args.preloadLogsInterval());
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            ArrayList futs = new ArrayList();
            final Thread thread = Thread.currentThread();
            for (int i = 0; i < this.availableCaches.size(); ++i) {
                final String string = this.availableCaches.get(i).getName();
                futs.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try (IgniteDataStreamer dataLdr = IgniteCacheRandomOperationBenchmark.this.ignite().dataStreamer(string);){
                            for (int i = 0; i < IgniteCacheRandomOperationBenchmark.this.args.preloadAmount(); ++i) {
                                if (i % 100 == 0 && thread.isInterrupted()) {
                                    break;
                                }
                                dataLdr.addData(IgniteCacheRandomOperationBenchmark.this.createRandomKey(i, string), IgniteCacheRandomOperationBenchmark.this.createRandomValue(i, string));
                            }
                        }
                    }
                }));
            }
            for (Future future : futs) {
                future.get();
            }
        }
        finally {
            executor.shutdown();
        }
        this.stopPreloadLogging();
    }

    private Map<UUID, List<Integer>> personCachePartitions(String cacheName) {
        int i;
        Affinity affinity = this.ignite().affinity(cacheName);
        ArrayList<Integer> rndParts = new ArrayList<Integer>(10);
        if (affinity.partitions() <= 10) {
            for (i = 0; i < affinity.partitions(); ++i) {
                rndParts.add(i);
            }
        } else {
            for (i = 0; i < 10; ++i) {
                int partNum;
                while (rndParts.contains(partNum = IgniteCacheRandomOperationBenchmark.nextRandom(affinity.partitions()))) {
                }
                rndParts.add(partNum);
            }
        }
        Collections.sort(rndParts);
        Map partPerNodes = affinity.mapPartitionsToNodes(rndParts);
        HashMap<UUID, List<Integer>> nodesToPart = new HashMap<UUID, List<Integer>>();
        for (Map.Entry entry : partPerNodes.entrySet()) {
            ArrayList nodeParts = (ArrayList)nodesToPart.get(((ClusterNode)entry.getValue()).id());
            if (nodeParts == null) {
                nodeParts = new ArrayList();
                nodesToPart.put(((ClusterNode)entry.getValue()).id(), nodeParts);
            }
            nodeParts.add(entry.getKey());
        }
        return nodesToPart;
    }

    private Object createRandomKey(int id, String cacheName) {
        Class clazz = this.randomKeyClass(cacheName);
        return ModelUtil.create(clazz, id);
    }

    private Class randomKeyClass(String cacheName) {
        Class[] keys = this.keysCacheClasses.containsKey(cacheName) ? this.keysCacheClasses.get(cacheName) : ModelUtil.keyClasses();
        return keys[IgniteCacheRandomOperationBenchmark.nextRandom(keys.length)];
    }

    private Class[] determineValueClasses(@NotNull String cacheName) {
        return cacheName.toLowerCase().contains("fat-values") ? ModelUtil.fatValueClasses() : ModelUtil.simpleValueClasses();
    }

    private Object createRandomValue(int id, String cacheName) {
        Class clazz = this.randomValueClass(cacheName);
        return ModelUtil.create(clazz, id);
    }

    private Class randomValueClass(String cacheName) {
        Class[] values = this.valuesCacheClasses.containsKey(cacheName) ? this.valuesCacheClasses.get(cacheName) : ModelUtil.valueClasses();
        return values[IgniteCacheRandomOperationBenchmark.nextRandom(values.length)];
    }

    private void executeOutOfTx(Map<Object, Object> map, boolean withoutTransactionCache) throws Exception {
        for (IgniteCache<Object, Object> cache : this.availableCaches) {
            if (withoutTransactionCache && this.txCaches.contains(cache)) continue;
            this.executeRandomOperation(map, cache);
        }
    }

    private void executeRandomOperation(Map<Object, Object> map, IgniteCache<Object, Object> cache) throws Exception {
        Operation op = this.nextRandomOperation();
        try {
            switch (op) {
                case PUT: {
                    this.doPut(cache);
                    break;
                }
                case PUT_ALL: {
                    this.doPutAll(cache);
                    break;
                }
                case GET: {
                    this.doGet(cache);
                    break;
                }
                case GET_ALL: {
                    this.doGetAll(cache);
                    break;
                }
                case INVOKE: {
                    this.doInvoke(cache);
                    break;
                }
                case INVOKE_ALL: {
                    this.doInvokeAll(cache);
                    break;
                }
                case REMOVE: {
                    this.doRemove(cache);
                    break;
                }
                case REMOVE_ALL: {
                    this.doRemoveAll(cache);
                    break;
                }
                case PUT_IF_ABSENT: {
                    this.doPutIfAbsent(cache);
                    break;
                }
                case REPLACE: {
                    this.doReplace(cache);
                    break;
                }
                case SCAN_QUERY: {
                    this.doScanQuery(cache);
                    break;
                }
                case SQL_QUERY: {
                    this.doSqlQuery(cache);
                    break;
                }
                case CONTINUOUS_QUERY: {
                    this.doContinuousQuery(cache, map);
                }
            }
            this.storeStatistics(cache.getName(), map, op);
        }
        catch (Exception e) {
            BenchmarkUtils.error((String)String.format("Failed to perform operation %s.", new Object[]{op}), (Throwable)e);
        }
    }

    @NotNull
    private Operation nextRandomOperation() {
        return this.allowedLoadTestOps.get(IgniteCacheRandomOperationBenchmark.nextRandom(this.allowedLoadTestOps.size()));
    }

    private void storeStatistics(String cacheName, Map<Object, Object> map, Operation op) {
        String opCacheKey = (Object)((Object)op) + "_" + cacheName;
        Long opAmount = (Long)map.get("amount");
        opAmount = opAmount == null ? 1L : opAmount + 1L;
        Integer opCacheCnt = (Integer)map.get(opCacheKey);
        opCacheCnt = opCacheCnt == null ? 1 : opCacheCnt + 1;
        if (opAmount % 100L == 0L) {
            this.updateStat(map);
        } else {
            map.put(opCacheKey, opCacheCnt);
        }
        map.put("amount", opAmount);
    }

    private void updateStat(Map<Object, Object> map) {
        for (Operation op : Operation.values()) {
            for (String cacheName : this.ignite().cacheNames()) {
                String opCacheKey = (Object)((Object)op) + "_" + cacheName;
                Integer val = (Integer)map.get(opCacheKey);
                if (val == null) continue;
                this.operationStatistics.get(opCacheKey).addAndGet(val.longValue());
                map.put(opCacheKey, 0);
            }
        }
    }

    private void executeInTransaction(final Map<Object, Object> map) throws Exception {
        IgniteBenchmarkUtils.doInTransaction(this.ignite().transactions(), TransactionConcurrency.fromOrdinal((int)IgniteCacheRandomOperationBenchmark.nextRandom(TransactionConcurrency.values().length)), TransactionIsolation.fromOrdinal((int)IgniteCacheRandomOperationBenchmark.nextRandom(TransactionIsolation.values().length)), new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                for (IgniteCache cache : IgniteCacheRandomOperationBenchmark.this.txCaches) {
                    if (!IgniteCacheRandomOperationBenchmark.this.nextBoolean()) continue;
                    IgniteCacheRandomOperationBenchmark.this.executeRandomOperation(map, (IgniteCache<Object, Object>)cache);
                }
                return null;
            }
        });
    }

    private void doPut(IgniteCache<Object, Object> cache) throws Exception {
        int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
        cache.put(this.createRandomKey(i, cache.getName()), this.createRandomValue(i, cache.getName()));
    }

    private void doPutAll(IgniteCache<Object, Object> cache) throws Exception {
        TreeMap<Object, Object> putMap = new TreeMap<Object, Object>();
        Class keyCass = this.randomKeyClass(cache.getName());
        for (int cnt = 0; cnt < this.args.batch(); ++cnt) {
            int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
            putMap.put(ModelUtil.create(keyCass, i), this.createRandomValue(i, cache.getName()));
        }
        cache.putAll(putMap);
    }

    private void doGet(IgniteCache<Object, Object> cache) throws Exception {
        int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
        cache.get(this.createRandomKey(i, cache.getName()));
    }

    private void doGetAll(IgniteCache<Object, Object> cache) throws Exception {
        TreeSet<Object> keys = new TreeSet<Object>();
        Class keyCls = this.randomKeyClass(cache.getName());
        for (int cnt = 0; cnt < this.args.batch(); ++cnt) {
            int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
            keys.add(ModelUtil.create(keyCls, i));
        }
        cache.getAll(keys);
    }

    private void doInvoke(IgniteCache<Object, Object> cache) throws Exception {
        int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
        if (this.nextBoolean()) {
            cache.invoke(this.createRandomKey(i, cache.getName()), (EntryProcessor)this.replaceEntryProc, new Object[]{this.createRandomValue(i + 1, cache.getName())});
        } else {
            cache.invoke(this.createRandomKey(i, cache.getName()), (EntryProcessor)this.rmvEntryProc, new Object[0]);
        }
    }

    private void doInvokeAll(IgniteCache<Object, Object> cache) throws Exception {
        TreeMap<Object, EntryProcessor<Object, Object, Object>> map = new TreeMap<Object, EntryProcessor<Object, Object, Object>>();
        Class keyCls = this.randomKeyClass(cache.getName());
        for (int cnt = 0; cnt < this.args.batch(); ++cnt) {
            int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
            Object key = ModelUtil.create(keyCls, i);
            if (this.nextBoolean()) {
                map.put(key, new BenchmarkReplaceValueEntryProcessor(this.createRandomValue(i + 1, cache.getName())));
                continue;
            }
            map.put(key, this.rmvEntryProc);
        }
        cache.invokeAll(map, new Object[0]);
    }

    private void doRemove(IgniteCache<Object, Object> cache) throws Exception {
        int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
        cache.remove(this.createRandomKey(i, cache.getName()));
    }

    private void doRemoveAll(IgniteCache<Object, Object> cache) throws Exception {
        TreeSet<Object> keys = new TreeSet<Object>();
        Class keyCls = this.randomKeyClass(cache.getName());
        for (int cnt = 0; cnt < this.args.batch(); ++cnt) {
            int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
            keys.add(ModelUtil.create(keyCls, i));
        }
        cache.removeAll(keys);
    }

    private void doPutIfAbsent(IgniteCache<Object, Object> cache) throws Exception {
        int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
        cache.putIfAbsent(this.createRandomKey(i, cache.getName()), this.createRandomValue(i, cache.getName()));
    }

    private void doReplace(IgniteCache<Object, Object> cache) throws Exception {
        int i = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
        cache.replace(this.createRandomKey(i, cache.getName()), this.createRandomValue(i, cache.getName()), this.createRandomValue(i + 1, cache.getName()));
    }

    private void doScanQuery(IgniteCache<Object, Object> cache) throws Exception {
        if (!this.affCaches.contains(cache)) {
            return;
        }
        Map<UUID, List<Integer>> partitionsMap = this.personCachePartitions(cache.getName());
        ScanQueryBroadcastClosure c = new ScanQueryBroadcastClosure(cache.getName(), partitionsMap);
        ClusterGroup clusterGrp = this.ignite().cluster().forNodeIds(partitionsMap.keySet());
        IgniteCompute compute = this.ignite().compute(clusterGrp);
        compute.broadcast((IgniteRunnable)c);
    }

    private void doSqlQuery(IgniteCache<Object, Object> cache) {
        List<SqlCacheDescriptor> descriptors = this.cacheSqlDescriptors.get(cache.getName());
        if (descriptors != null) {
            SqlFieldsQuery sq = null;
            if (this.queries.isEmpty()) {
                if (!descriptors.isEmpty()) {
                    SqlCacheDescriptor randomDesc = descriptors.get(IgniteCacheRandomOperationBenchmark.nextRandom(descriptors.size()));
                    int id = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
                    sq = this.nextBoolean() ? randomDesc.getSqlQuery(id) : randomDesc.getSqlFieldsQuery(id);
                }
            } else {
                TestQuery qry = this.queries.get(IgniteCacheRandomOperationBenchmark.nextRandom(this.queries.size()));
                String sql = this.randomizeSql(qry.sql);
                sq = new SqlFieldsQuery(sql);
                sq.setDistributedJoins(qry.distributedJoin);
            }
            if (sq != null) {
                try (QueryCursor cursor = cache.query(sq);){
                    for (Object e : cursor) {
                    }
                }
            }
        }
    }

    private String randomizeSql(String sql) {
        int cnt = StringUtils.countOccurrencesOf((String)sql, (String)"%s");
        Object[] sub = new Integer[cnt];
        for (int i = 0; i < cnt; ++i) {
            sub[i] = IgniteCacheRandomOperationBenchmark.nextRandom(this.args.range());
        }
        sql = String.format(sql, sub);
        return sql;
    }

    private void doContinuousQuery(IgniteCache<Object, Object> cache, Map<Object, Object> map) throws Exception {
        ArrayList<QueryCursor> cursors = (ArrayList<QueryCursor>)map.get(cache.getName());
        if (cursors == null) {
            cursors = new ArrayList<QueryCursor>(3);
            map.put(cache.getName(), cursors);
        }
        if (cursors.size() == 3) {
            QueryCursor cursor = (QueryCursor)cursors.get(IgniteCacheRandomOperationBenchmark.nextRandom(cursors.size()));
            cursor.close();
            cursors.remove(cursor);
        }
        ContinuousQuery qry = new ContinuousQuery();
        qry.setLocalListener((CacheEntryUpdatedListener)new ContinuousQueryUpdater());
        qry.setRemoteFilterFactory(FactoryBuilder.factoryOf((Serializable)new ContinuousQueryFilter()));
        cursors.add(cache.query((Query)qry));
    }

    private boolean nextBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    private static class TestQuery {
        private final String sql;
        private final boolean distributedJoin;

        public TestQuery(String sql, boolean distributedJoin) {
            this.sql = sql;
            this.distributedJoin = distributedJoin;
        }

        public String toString() {
            return S.toString(TestQuery.class, (Object)this);
        }
    }

    private static enum Operation {
        PUT,
        PUT_ALL,
        GET,
        GET_ALL,
        INVOKE,
        INVOKE_ALL,
        REMOVE,
        REMOVE_ALL,
        PUT_IF_ABSENT,
        REPLACE,
        SCAN_QUERY,
        SQL_QUERY,
        CONTINUOUS_QUERY;


        public static Operation valueOf(int num) {
            return Operation.values()[num];
        }
    }

    private static class SqlCacheDescriptor {
        private Class valCls;
        private Set<String> fields;
        private Map<String, Class> indexedFieldsByCls;

        SqlCacheDescriptor(Class valCls, Set<String> fields, Map<String, Class> indexedFieldsByCls) {
            this.valCls = valCls;
            this.fields = fields;
            this.indexedFieldsByCls = indexedFieldsByCls;
        }

        private String makeQuerySelect(int id) {
            return StringUtils.collectionToDelimitedString(this.fields, (String)", ");
        }

        private String makeQueryCondition(int id) {
            StringBuilder sb = new StringBuilder();
            for (String iField : this.indexedFieldsByCls.keySet()) {
                Class cl = this.indexedFieldsByCls.get(iField);
                if (!Number.class.isAssignableFrom(cl) && !String.class.equals((Object)cl)) continue;
                if (sb.length() != 0) {
                    switch (id % 3 % 2) {
                        case 0: {
                            sb.append(" OR ");
                            break;
                        }
                        case 1: {
                            sb.append(" AND ");
                        }
                    }
                }
                if (Number.class.isAssignableFrom(cl)) {
                    sb.append(iField);
                    switch (id % 2) {
                        case 0: {
                            sb.append(" > ");
                            break;
                        }
                        case 1: {
                            sb.append(" < ");
                        }
                    }
                    sb.append(id);
                    continue;
                }
                if (!String.class.equals((Object)cl)) continue;
                sb.append("lower(").append(iField).append(") LIKE lower('%").append(id).append("%')");
            }
            return sb.toString();
        }

        SqlQuery getSqlQuery(int id) {
            return new SqlQuery(this.valCls, this.makeQueryCondition(id));
        }

        SqlFieldsQuery getSqlFieldsQuery(int id) {
            return new SqlFieldsQuery(String.format("SELECT %s FROM %s WHERE %s", this.makeQuerySelect(id), this.valCls.getSimpleName(), this.makeQueryCondition(id)));
        }
    }

    private static class BenchmarkIgniteBiPredicate
    implements IgniteBiPredicate {
        private BenchmarkIgniteBiPredicate() {
        }

        public boolean apply(Object key, Object val) {
            return true;
        }
    }

    private static class ScanQueryBroadcastClosure
    implements IgniteRunnable {
        @IgniteInstanceResource
        private Ignite node;
        private Map<UUID, List<Integer>> cachePart;
        private String cacheName;

        private ScanQueryBroadcastClosure(String cacheName, Map<UUID, List<Integer>> cachePart) {
            this.cachePart = cachePart;
            this.cacheName = cacheName;
        }

        public void run() {
            IgniteCache cache = this.node.cache(this.cacheName);
            List<Integer> myPartitions = this.cachePart.get(this.node.cluster().localNode().id());
            for (Integer part : myPartitions) {
                ScanQuery scanQry = new ScanQuery();
                scanQry.setPartition(part);
                scanQry.setFilter((IgniteBiPredicate)igniteBiPred);
                QueryCursor cursor = cache.query((Query)scanQry);
                Throwable throwable = null;
                try {
                    for (Object e : cursor) {
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cursor == null) continue;
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    cursor.close();
                }
            }
        }
    }

    private static class ContinuousQueryFilter
    implements CacheEntryEventSerializableFilter,
    Serializable {
        private boolean flag = true;

        private ContinuousQueryFilter() {
        }

        public boolean evaluate(CacheEntryEvent evt) throws CacheEntryListenerException {
            this.flag = !this.flag;
            return this.flag;
        }
    }

    private static class ContinuousQueryUpdater
    implements CacheEntryUpdatedListener,
    Serializable {
        private ContinuousQueryUpdater() {
        }

        public void onUpdated(Iterable iterable) throws CacheEntryListenerException {
            for (Object t : iterable) {
            }
        }
    }

    private static class BenchmarkRemoveEntryProcessor
    implements EntryProcessor<Object, Object, Object>,
    Serializable {
        private BenchmarkRemoveEntryProcessor() {
        }

        public Object process(MutableEntry<Object, Object> entry, Object ... arguments) {
            Object oldVal = entry.getValue();
            entry.remove();
            return oldVal;
        }
    }

    private static class BenchmarkReplaceValueEntryProcessor
    implements EntryProcessor<Object, Object, Object>,
    Serializable {
        private Object newVal;

        private BenchmarkReplaceValueEntryProcessor(Object newVal) {
            this.newVal = newVal;
        }

        public Object process(MutableEntry<Object, Object> entry, Object ... arguments) {
            Object newVal = arguments == null || arguments[0] == null ? this.newVal : arguments[0];
            Object oldVal = entry.getValue();
            entry.setValue(newVal);
            return oldVal;
        }
    }
}

