/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.dml;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Person;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteSqlMergeQueryBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private AtomicInteger putCnt = new AtomicInteger();
    private AtomicInteger qryCnt = new AtomicInteger();

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        if (rnd.nextBoolean()) {
            double salary = rnd.nextDouble() * (double)this.args.range() * 1000.0;
            double maxSalary = salary + 1000.0;
            Collection<Cache.Entry<Integer, Object>> entries = this.executeQuery(salary, maxSalary);
            for (Cache.Entry<Integer, Object> entry : entries) {
                double s;
                Object o = entry.getValue();
                double d = s = o instanceof Person ? ((Person)o).getSalary() : ((Double)((BinaryObject)o).field("salary")).doubleValue();
                if (!(s < salary) && !(s > maxSalary)) continue;
                throw new Exception("Invalid person retrieved [min=" + salary + ", max=" + maxSalary + ", person=" + o + ']');
            }
            this.qryCnt.getAndIncrement();
        } else {
            int i = rnd.nextInt(this.args.range());
            this.cache.query(new SqlFieldsQuery("merge into Person(_key, id, firstName, lastName, salary) values (?, ?, ?, ?, ?)").setArgs(new Object[]{i, i, "firstName" + i, "lastName" + i, (double)i * 1000.0}));
            this.putCnt.getAndIncrement();
        }
        return true;
    }

    public void onWarmupFinished() {
        super.onWarmupFinished();
    }

    private Collection<Cache.Entry<Integer, Object>> executeQuery(double minSalary, double maxSalary) throws Exception {
        SqlQuery qry = new SqlQuery(Person.class, "salary >= ? and salary <= ?");
        qry.setArgs(new Object[]{minSalary, maxSalary});
        return this.cache.query((Query)qry).getAll();
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("query").withKeepBinary();
    }

    @Override
    public void tearDown() throws Exception {
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Finished sql query put benchmark [putCnt=" + this.putCnt.get() + ", qryCnt=" + this.qryCnt.get() + ']'));
        super.tearDown();
    }
}

