/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsConfigurationManager;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.query.stat.view.StatisticsColumnConfigurationView;
import org.apache.ignite.internal.util.typedef.F;

public class ColumnConfigurationViewSupplier {
    IgniteStatisticsConfigurationManager cfgMgr;
    private final IgniteLogger log;

    public ColumnConfigurationViewSupplier(IgniteStatisticsConfigurationManager cfgMgr, Function<Class<?>, IgniteLogger> logSupplier) {
        this.cfgMgr = cfgMgr;
        this.log = logSupplier.apply(ColumnConfigurationViewSupplier.class);
    }

    public Iterable<StatisticsColumnConfigurationView> columnConfigurationViewSupplier(Map<String, Object> filter) {
        Collection<StatisticsObjectConfiguration> configs;
        String schema = (String)filter.get("schema");
        String name = (String)filter.get("name");
        try {
            if (!F.isEmpty((String)schema) && !F.isEmpty((String)name)) {
                StatisticsKey key = new StatisticsKey(schema, name);
                StatisticsObjectConfiguration keyCfg = this.cfgMgr.config(key);
                if (keyCfg == null) {
                    return Collections.emptyList();
                }
                configs = Collections.singletonList(keyCfg);
            } else {
                configs = this.cfgMgr.getAllConfig();
            }
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Error while getting statistics configuration: " + e.getMessage(), (Throwable)e);
            configs = Collections.emptyList();
        }
        ArrayList<StatisticsColumnConfigurationView> res = new ArrayList<StatisticsColumnConfigurationView>();
        for (StatisticsObjectConfiguration cfg : configs) {
            for (StatisticsColumnConfiguration colCfg : cfg.columnsAll().values()) {
                if (colCfg.tombstone()) continue;
                res.add(new StatisticsColumnConfigurationView(cfg, colCfg));
            }
        }
        return res;
    }
}

