/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;

public class LocalStatisticsGatheringContext {
    private final boolean forceRecollect;
    private final GridH2Table tbl;
    private final StatisticsObjectConfiguration cfg;
    private final Set<Integer> remainingParts;
    private final Set<Integer> allParts;
    private final AffinityTopologyVersion topVer;
    private final CompletableFuture<Void> future;
    private volatile boolean cancelled;

    public LocalStatisticsGatheringContext(boolean forceRecollect, GridH2Table tbl, StatisticsObjectConfiguration cfg, Set<Integer> remainingParts, AffinityTopologyVersion topVer) {
        this.forceRecollect = forceRecollect;
        this.tbl = tbl;
        this.cfg = cfg;
        this.remainingParts = new HashSet<Integer>(remainingParts);
        this.allParts = forceRecollect ? null : new HashSet<Integer>(remainingParts);
        this.topVer = topVer;
        this.future = new CompletableFuture();
    }

    public boolean forceRecollect() {
        return this.forceRecollect;
    }

    public GridH2Table table() {
        return this.tbl;
    }

    public StatisticsObjectConfiguration configuration() {
        return this.cfg;
    }

    public synchronized boolean partitionDone(int partId) {
        this.remainingParts.remove(partId);
        return this.remainingParts.isEmpty();
    }

    public synchronized Set<Integer> remainingParts() {
        return new HashSet<Integer>(this.remainingParts);
    }

    public Set<Integer> allParts() {
        return this.allParts;
    }

    public synchronized void partitionNotAvailable(int partId) {
        this.remainingParts.remove(partId);
        this.cancel();
        if (this.remainingParts.isEmpty()) {
            this.future.cancel(true);
            return;
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public CompletableFuture<Void> future() {
        return this.future;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public String toString() {
        return S.toString(LocalStatisticsGatheringContext.class, (Object)this);
    }
}

