/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.util.Collection;
import java.util.Iterator;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Array;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Boolean;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Byte;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Bytes;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2CacheObject;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Date;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Decimal;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Double;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Float;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Geometry;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Integer;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2JavaObject;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Long;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Null;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRange;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRangeBounds;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2SelectForUpdateTxDetails;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Short;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2String;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Time;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Timestamp;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2Uuid;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.plugin.extensions.communication.IgniteMessageFactory;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactoryProvider;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridH2ValueMessageFactory
implements MessageFactoryProvider {
    public void registerAll(IgniteMessageFactory factory) {
        factory.register((short)-4, () -> GridH2Null.INSTANCE);
        factory.register((short)-5, GridH2Boolean::new);
        factory.register((short)-6, GridH2Byte::new);
        factory.register((short)-7, GridH2Short::new);
        factory.register((short)-8, GridH2Integer::new);
        factory.register((short)-9, GridH2Long::new);
        factory.register((short)-10, GridH2Decimal::new);
        factory.register((short)-11, GridH2Double::new);
        factory.register((short)-12, GridH2Float::new);
        factory.register((short)-13, GridH2Time::new);
        factory.register((short)-14, GridH2Date::new);
        factory.register((short)-15, GridH2Timestamp::new);
        factory.register((short)-16, GridH2Bytes::new);
        factory.register((short)-17, GridH2String::new);
        factory.register((short)-18, GridH2Array::new);
        factory.register((short)-19, GridH2JavaObject::new);
        factory.register((short)-20, GridH2Uuid::new);
        factory.register((short)-21, GridH2Geometry::new);
        factory.register((short)-22, GridH2CacheObject::new);
        factory.register((short)-30, GridH2IndexRangeRequest::new);
        factory.register((short)-31, GridH2IndexRangeResponse::new);
        factory.register((short)-32, GridH2RowMessage::new);
        factory.register((short)-33, GridH2QueryRequest::new);
        factory.register((short)-34, GridH2RowRange::new);
        factory.register((short)-35, GridH2RowRangeBounds::new);
        factory.register((short)-54, QueryTable::new);
        factory.register((short)-55, GridH2DmlRequest::new);
        factory.register((short)-56, GridH2DmlResponse::new);
        factory.register((short)-57, GridH2SelectForUpdateTxDetails::new);
    }

    @Nullable
    public Message create(short type) {
        throw new UnsupportedOperationException();
    }

    public static Collection<Message> toMessages(Collection<Value[]> src, Collection<Message> dst, int cnt) throws IgniteCheckedException {
        for (Value[] row : src) {
            assert (row.length >= cnt);
            for (int i = 0; i < cnt; ++i) {
                dst.add(GridH2ValueMessageFactory.toMessage(row[i]));
            }
        }
        return dst;
    }

    public static Value[] fillArray(Iterator<? extends Message> src, Value[] dst, GridKernalContext ctx) throws IgniteCheckedException {
        for (int i = 0; i < dst.length; ++i) {
            Message msg = src.next();
            dst[i] = ((GridH2ValueMessage)msg).value(ctx);
        }
        return dst;
    }

    public static GridH2ValueMessage toMessage(Value v) throws IgniteCheckedException {
        switch (v.getType()) {
            case 0: {
                return GridH2Null.INSTANCE;
            }
            case 1: {
                return new GridH2Boolean(v);
            }
            case 2: {
                return new GridH2Byte(v);
            }
            case 3: {
                return new GridH2Short(v);
            }
            case 4: {
                return new GridH2Integer(v);
            }
            case 5: {
                return new GridH2Long(v);
            }
            case 6: {
                return new GridH2Decimal(v);
            }
            case 7: {
                return new GridH2Double(v);
            }
            case 8: {
                return new GridH2Float(v);
            }
            case 10: {
                return new GridH2Date(v);
            }
            case 9: {
                return new GridH2Time(v);
            }
            case 11: {
                return new GridH2Timestamp(v);
            }
            case 12: {
                return new GridH2Bytes(v);
            }
            case 13: 
            case 14: 
            case 21: {
                return new GridH2String(v);
            }
            case 17: {
                return new GridH2Array(v);
            }
            case 19: {
                if (v instanceof GridH2ValueCacheObject) {
                    return new GridH2CacheObject((GridH2ValueCacheObject)v);
                }
                return new GridH2JavaObject(v);
            }
            case 20: {
                return new GridH2Uuid(v);
            }
            case 22: {
                return new GridH2Geometry(v);
            }
        }
        throw new IllegalStateException("Unsupported H2 type: " + v.getType());
    }
}

