/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.index.client;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.internal.cache.query.index.IndexDefinition;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.processors.query.h2.index.QueryIndexKeyDefinitionProvider;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.table.IndexColumn;

public class ClientIndexDefinition
implements IndexDefinition {
    private final int cfgInlineSize;
    private final int maxInlineSize;
    private final IndexName idxName;
    private final LinkedHashMap<String, IndexKeyDefinition> keyDefs;

    public ClientIndexDefinition(GridH2Table table, IndexName idxName, List<IndexColumn> unwrappedCols, int cfgInlineSize, int maxInlineSize) {
        this.idxName = idxName;
        this.cfgInlineSize = cfgInlineSize;
        this.maxInlineSize = maxInlineSize;
        this.keyDefs = new QueryIndexKeyDefinitionProvider(table, unwrappedCols).keyDefinitions();
    }

    public int getCfgInlineSize() {
        return this.cfgInlineSize;
    }

    public int getMaxInlineSize() {
        return this.maxInlineSize;
    }

    public IndexName idxName() {
        return this.idxName;
    }

    public LinkedHashMap<String, IndexKeyDefinition> indexKeyDefinitions() {
        return this.keyDefs;
    }
}

