/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.SecurityCredentialsAttrFilterPredicate;
import org.apache.ignite.internal.managers.discovery.IgniteClusterNode;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.jetbrains.annotations.Nullable;

public class ZookeeperClusterNode
implements IgniteClusterNode,
Externalizable,
Comparable<ZookeeperClusterNode> {
    private static final long serialVersionUID = 0L;
    private static final byte CLIENT_NODE_MASK = 1;
    private volatile UUID id;
    private Serializable consistentId;
    private long internalId;
    private long order;
    private IgniteProductVersion ver;
    private Map<String, Object> attrs;
    private Collection<String> addrs;
    private Collection<String> hostNames;
    private long sesTimeout;
    private transient DiscoveryMetricsProvider metricsProvider;
    private transient boolean loc;
    private volatile transient ClusterMetrics metrics;
    @GridToStringExclude
    private volatile transient Map<Integer, CacheMetrics> cacheMetrics;
    private byte flags;
    @GridToStringExclude
    private transient boolean daemon;
    @GridToStringExclude
    private volatile transient boolean daemonInit;

    public ZookeeperClusterNode() {
    }

    public ZookeeperClusterNode(UUID id, Collection<String> addrs, Collection<String> hostNames, IgniteProductVersion ver, Map<String, Object> attrs, Serializable consistentId, long sesTimeout, boolean client, DiscoveryMetricsProvider metricsProvider) {
        assert (id != null);
        assert (consistentId != null);
        this.id = id;
        this.ver = ver;
        this.attrs = Collections.unmodifiableMap(attrs);
        this.addrs = addrs;
        this.hostNames = hostNames;
        this.consistentId = consistentId;
        this.sesTimeout = sesTimeout;
        this.metricsProvider = metricsProvider;
        if (client) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    public UUID id() {
        return this.id;
    }

    public Object consistentId() {
        return this.consistentId;
    }

    public void setConsistentId(Serializable consistentId) {
        this.consistentId = consistentId;
        HashMap<String, Object> map = new HashMap<String, Object>(this.attrs);
        map.put("org.apache.ignite.consistent.id", consistentId);
        this.attrs = Collections.unmodifiableMap(map);
    }

    @Nullable
    public <T> T attribute(String name) {
        if ("org.apache.ignite.security.cred".equals(name)) {
            return null;
        }
        return (T)this.attrs.get(name);
    }

    void setAttributes(Map<String, Object> attrs) {
        this.attrs = U.sealMap(attrs);
    }

    Map<String, Object> getAttributes() {
        return this.attrs;
    }

    public ClusterMetrics metrics() {
        if (this.metricsProvider != null) {
            ClusterMetrics metrics0 = this.metricsProvider.metrics();
            assert (metrics0 != null);
            this.metrics = metrics0;
            return metrics0;
        }
        return this.metrics;
    }

    public void setMetrics(ClusterMetrics metrics) {
        assert (metrics != null);
        this.metrics = metrics;
    }

    public Map<Integer, CacheMetrics> cacheMetrics() {
        if (this.metricsProvider != null) {
            Map cacheMetrics0;
            this.cacheMetrics = cacheMetrics0 = this.metricsProvider.cacheMetrics();
            return cacheMetrics0;
        }
        return this.cacheMetrics;
    }

    public void setCacheMetrics(Map<Integer, CacheMetrics> cacheMetrics) {
        this.cacheMetrics = cacheMetrics != null ? cacheMetrics : Collections.emptyMap();
    }

    public Map<String, Object> attributes() {
        return F.view(this.attrs, (IgnitePredicate[])new IgnitePredicate[]{new SecurityCredentialsAttrFilterPredicate()});
    }

    public Collection<String> addresses() {
        return this.addrs;
    }

    public Collection<String> hostNames() {
        return this.hostNames;
    }

    public long order() {
        return this.order;
    }

    long internalId() {
        return this.internalId;
    }

    void internalId(long internalId) {
        this.internalId = internalId;
    }

    void order(long order) {
        assert (order > 0L) : order;
        this.order = order;
    }

    public void onClientDisconnected(UUID newId) {
        this.id = newId;
    }

    long sessionTimeout() {
        return this.sesTimeout;
    }

    public IgniteProductVersion version() {
        return this.ver;
    }

    public void local(boolean loc) {
        this.loc = loc;
    }

    public boolean isLocal() {
        return this.loc;
    }

    public boolean isDaemon() {
        if (!this.daemonInit) {
            this.daemon = "true".equalsIgnoreCase((String)this.attribute("org.apache.ignite.daemon"));
            this.daemonInit = true;
        }
        return this.daemon;
    }

    public boolean isClient() {
        return (1 & this.flags) != 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid((DataOutput)out, (UUID)this.id);
        out.writeObject(this.consistentId);
        out.writeLong(this.internalId);
        out.writeLong(this.order);
        out.writeObject(this.ver);
        U.writeMap((ObjectOutput)out, this.attrs);
        U.writeCollection((ObjectOutput)out, this.addrs);
        U.writeCollection((ObjectOutput)out, this.hostNames);
        out.writeLong(this.sesTimeout);
        out.writeByte(this.flags);
        byte[] mtr = null;
        ClusterMetrics metrics = this.metrics;
        if (metrics != null) {
            mtr = ClusterMetricsSnapshot.serialize((ClusterMetrics)metrics);
        }
        U.writeByteArray((DataOutput)out, (byte[])mtr);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readUuid((DataInput)in);
        this.consistentId = (Serializable)in.readObject();
        this.internalId = in.readLong();
        this.order = in.readLong();
        this.ver = (IgniteProductVersion)in.readObject();
        this.attrs = U.sealMap((Map)U.readMap((ObjectInput)in));
        this.addrs = U.readCollection((ObjectInput)in);
        this.hostNames = U.readCollection((ObjectInput)in);
        this.sesTimeout = in.readLong();
        this.flags = in.readByte();
        byte[] mtr = U.readByteArray((DataInput)in);
        if (mtr != null) {
            this.metrics = ClusterMetricsSnapshot.deserialize((byte[])mtr, (int)0);
        }
    }

    @Override
    public int compareTo(@Nullable ZookeeperClusterNode node) {
        if (node == null) {
            return 1;
        }
        int res = Long.compare(this.order, node.order);
        if (res == 0) {
            assert (this.id().equals(node.id())) : "Duplicate order [this=" + this + ", other=" + node + ']';
            res = this.id().compareTo(node.id());
        }
        return res;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return F.eqNodes((Object)this, (Object)obj);
    }

    public String toString() {
        return "ZookeeperClusterNode [id=" + this.id + ", addrs=" + this.addrs + ", order=" + this.order + ", loc=" + this.loc + ", client=" + this.isClient() + ']';
    }
}

