/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CommunicationFailureContext;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;

class ZkCommunicationFailureContext
implements CommunicationFailureContext {
    private static final Comparator<ClusterNode> NODE_ORDER_CMP = new Comparator<ClusterNode>(){

        @Override
        public int compare(ClusterNode node1, ClusterNode node2) {
            return Long.compare(node1.order(), node2.order());
        }
    };
    private Set<ClusterNode> killedNodes = new HashSet<ClusterNode>();
    private final Map<UUID, BitSet> nodesState;
    private final List<ClusterNode> initialNodes;
    private final List<ClusterNode> curNodes;
    private final GridCacheSharedContext<?, ?> ctx;

    ZkCommunicationFailureContext(GridCacheSharedContext<?, ?> ctx, List<ClusterNode> curNodes, List<ClusterNode> initialNodes, Map<UUID, BitSet> nodesState) {
        this.ctx = ctx;
        this.curNodes = Collections.unmodifiableList(curNodes);
        this.initialNodes = initialNodes;
        this.nodesState = nodesState;
    }

    public List<ClusterNode> topologySnapshot() {
        return this.curNodes;
    }

    public boolean connectionAvailable(ClusterNode node1, ClusterNode node2) {
        BitSet nodeState = this.nodesState.get(node1.id());
        if (nodeState == null) {
            throw new IllegalArgumentException("Invalid node: " + node1);
        }
        int nodeIdx = Collections.binarySearch(this.initialNodes, node2, NODE_ORDER_CMP);
        if (nodeIdx < 0) {
            throw new IllegalArgumentException("Invalid node: " + node2);
        }
        assert (nodeIdx < nodeState.size()) : nodeIdx;
        return nodeState.get(nodeIdx);
    }

    public Map<String, CacheConfiguration<?, ?>> startedCaches() {
        Map cachesMap = this.ctx.affinity().caches();
        HashMap res = U.newHashMap((int)cachesMap.size());
        for (DynamicCacheDescriptor desc : cachesMap.values()) {
            if (!desc.cacheType().userCache()) continue;
            res.put(desc.cacheName(), desc.cacheConfiguration());
        }
        return res;
    }

    public List<List<ClusterNode>> cacheAffinity(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException("Null cache name.");
        }
        DynamicCacheDescriptor cacheDesc = (DynamicCacheDescriptor)this.ctx.affinity().caches().get(CU.cacheId((String)cacheName));
        if (cacheDesc == null) {
            throw new IllegalArgumentException("Invalid cache name: " + cacheName);
        }
        GridAffinityAssignmentCache aff = this.ctx.affinity().groupAffinity(cacheDesc.groupId());
        assert (aff != null) : cacheName;
        return aff.readyAssignments(aff.lastVersion());
    }

    public List<List<ClusterNode>> cachePartitionOwners(String cacheName) {
        GridDhtPartitionTopology top;
        if (cacheName == null) {
            throw new NullPointerException("Null cache name.");
        }
        DynamicCacheDescriptor cacheDesc = (DynamicCacheDescriptor)this.ctx.affinity().caches().get(CU.cacheId((String)cacheName));
        if (cacheDesc == null) {
            throw new IllegalArgumentException("Invalid cache name: " + cacheName);
        }
        if (cacheDesc.cacheConfiguration().getCacheMode() == CacheMode.LOCAL) {
            return Collections.emptyList();
        }
        CacheGroupContext grp = this.ctx.cache().cacheGroup(cacheDesc.groupId());
        if (grp == null) {
            top = this.ctx.exchange().clientTopologyIfExists(cacheDesc.groupId());
            assert (top != null) : cacheName;
        } else {
            top = grp.topology();
        }
        return top.allOwners();
    }

    public void killNode(ClusterNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (Collections.binarySearch(this.curNodes, node, NODE_ORDER_CMP) < 0) {
            throw new IllegalArgumentException("Invalid node: " + node);
        }
        this.killedNodes.add(node);
    }

    Set<ClusterNode> killedNodes() {
        return this.killedNodes;
    }

    public String toString() {
        return "ZkCommunicationFailureContext []";
    }
}

