/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark.impl.optimization;

import org.apache.ignite.spark.impl.optimization.SupportedExpressions;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class ConditionExpressions$
implements SupportedExpressions {
    public static final ConditionExpressions$ MODULE$;

    static {
        new ConditionExpressions$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean apply(Expression expr, Function1<Expression, Object> checkChild) {
        Expression expression = expr;
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Expression left = equalTo.left();
            Expression right = equalTo.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)expression;
            Expression left = equalNullSafe.left();
            Expression right = equalNullSafe.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)expression;
            Expression left = greaterThan.left();
            Expression right = greaterThan.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression left = greaterThanOrEqual.left();
            Expression right = greaterThanOrEqual.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof LessThan) {
            LessThan lessThan = (LessThan)expression;
            Expression left = lessThan.left();
            Expression right = lessThan.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
            Expression left = lessThanOrEqual.left();
            Expression right = lessThanOrEqual.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression child = inSet.child();
            Set set = inSet.hset();
            if (set.forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Object x$1) {
                    return x$1 instanceof Literal;
                }
            })) {
                return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression child = in.value();
            Seq list = in.list();
            if (list.forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Expression x$2) {
                    return x$2 instanceof Literal;
                }
            })) {
                return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
            }
        }
        if (expression instanceof IsNull) {
            IsNull isNull = (IsNull)expression;
            Expression child = isNull.child();
            return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        }
        if (expression instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)expression;
            Expression child = isNotNull.child();
            return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof Not) {
            Not not = (Not)expression;
            Expression child = not.child();
            return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        }
        if (expression instanceof StartsWith) {
            StartsWith startsWith = (StartsWith)expression;
            Expression left = startsWith.left();
            Expression right = startsWith.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof EndsWith) {
            EndsWith endsWith = (EndsWith)expression;
            Expression left = endsWith.left();
            Expression right = endsWith.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (!(expression instanceof Contains)) return false;
        Contains contains = (Contains)expression;
        Expression left = contains.left();
        Expression right = contains.right();
        if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
        if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
        return true;
    }

    @Override
    public Option<String> toString(Expression expr, Function1<Expression, String> childToString, boolean useQualifier, boolean useAlias) {
        None$ none$;
        Expression expression = expr;
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Expression left = equalTo.left();
            Expression right = equalTo.right();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)expression;
            Expression left = equalNullSafe.left();
            Expression right = equalNullSafe.right();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " IS NULL OR ", " = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)expression;
            Expression left = greaterThan.left();
            Expression right = greaterThan.right();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " > ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression left = greaterThanOrEqual.left();
            Expression right = greaterThanOrEqual.right();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof LessThan) {
            LessThan lessThan = (LessThan)expression;
            Expression left = lessThan.left();
            Expression right = lessThan.right();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
            Expression left = lessThanOrEqual.left();
            Expression right = lessThanOrEqual.right();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof In) {
            In in = (In)expression;
            Expression attr = in.value();
            Seq values = in.list();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IN (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)attr), ((TraversableOnce)values.map((Function1)new Serializable(childToString){
                public static final long serialVersionUID = 0L;
                private final Function1 childToString$1;

                public final String apply(Expression x$3) {
                    return (String)this.childToString$1.apply((Object)x$3);
                }
                {
                    this.childToString$1 = childToString$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        } else if (expression instanceof IsNull) {
            IsNull isNull = (IsNull)expression;
            Expression child = isNull.child();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IS NULL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)expression;
            Expression child = isNotNull.child();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IS NOT NULL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AND ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " OR ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof Not) {
            Not not = (Not)expression;
            Expression child = not.child();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NOT ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof StartsWith) {
            StartsWith startsWith = (StartsWith)expression;
            Expression attr = startsWith.left();
            Expression value = startsWith.right();
            String valStr = this.removeQuotes((String)childToString.apply((Object)value));
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE '", "%'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)attr), valStr})));
        } else if (expression instanceof EndsWith) {
            EndsWith endsWith = (EndsWith)expression;
            Expression attr = endsWith.left();
            Expression value = endsWith.right();
            String valStr = this.removeQuotes((String)childToString.apply((Object)value));
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE '%", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)attr), valStr})));
        } else if (expression instanceof Contains) {
            Contains contains = (Contains)expression;
            Expression attr = contains.left();
            Expression value = contains.right();
            String valStr = this.removeQuotes((String)childToString.apply((Object)value));
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE '%", "%'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)attr), valStr})));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String removeQuotes(String str) {
        String string;
        if (str.length() < 2) {
            string = str;
        } else {
            String string2 = str;
            String string3 = string2.startsWith("'") && string2.endsWith("'") ? string2.substring(1, string2.length() - 1) : str;
            string = string3;
        }
        return string;
    }

    private ConditionExpressions$() {
        MODULE$ = this;
    }
}

