/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.randomforest.data;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.tree.randomforest.data.NodeId;

public class TreeNode
implements IgniteModel<Vector, Double> {
    private static final long serialVersionUID = -8546263332508653661L;
    private NodeId id;
    private int featureId;
    private double val;
    private Type type;
    private double impurity;
    private int depth;
    private TreeNode left;
    private TreeNode right;

    public TreeNode(long id, int treeId) {
        this.id = new NodeId(treeId, id);
        this.val = -1.0;
        this.type = Type.UNKNOWN;
        this.impurity = Double.POSITIVE_INFINITY;
        this.depth = 1;
    }

    public TreeNode() {
    }

    @Override
    public Double predict(Vector features) {
        assert (this.type != Type.UNKNOWN);
        if (this.type == Type.LEAF) {
            return this.val;
        }
        if (features.get(this.featureId) <= this.val) {
            return this.left.predict(features);
        }
        return this.right.predict(features);
    }

    public NodeId predictNextNodeKey(Vector features) {
        switch (this.type) {
            case UNKNOWN: {
                return this.id;
            }
            case LEAF: {
                return this.id;
            }
        }
        if (features.get(this.featureId) <= this.val) {
            return this.left.predictNextNodeKey(features);
        }
        return this.right.predictNextNodeKey(features);
    }

    public List<TreeNode> toConditional(int featureId, double val) {
        assert (this.type == Type.UNKNOWN);
        this.toLeaf(val);
        this.left = new TreeNode(2L * this.id.getNodeId(), this.id.getTreeId());
        this.right = new TreeNode(2L * this.id.getNodeId() + 1L, this.id.getTreeId());
        this.type = Type.CONDITIONAL;
        this.featureId = featureId;
        this.left.depth = this.right.depth = this.depth + 1;
        return Arrays.asList(this.left, this.right);
    }

    public void toLeaf(double val) {
        assert (this.type == Type.UNKNOWN);
        this.val = val;
        this.type = Type.LEAF;
        this.left = null;
        this.right = null;
    }

    public NodeId getId() {
        return this.id;
    }

    public void setVal(double val) {
        this.val = val;
    }

    public Type getType() {
        return this.type;
    }

    public double getVal() {
        return this.val;
    }

    public void setImpurity(double impurity) {
        this.impurity = impurity;
    }

    public double getImpurity() {
        return this.impurity;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getFeatureId() {
        return this.featureId;
    }

    public TreeNode getLeft() {
        return this.left;
    }

    public TreeNode getRight() {
        return this.right;
    }

    public static enum Type {
        UNKNOWN,
        LEAF,
        CONDITIONAL;

    }
}

