/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.trainers;

import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.feature.extractor.Vectorizer;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDatasetBuilder;
import org.apache.ignite.ml.dataset.impl.local.LocalDatasetBuilder;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.environment.logging.MLLogger;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.preprocessing.developer.PatchedPreprocessor;
import org.apache.ignite.ml.structures.LabeledVector;
import org.jetbrains.annotations.NotNull;

public abstract class DatasetTrainer<M extends IgniteModel, L> {
    protected LearningEnvironmentBuilder envBuilder = LearningEnvironmentBuilder.defaultBuilder();
    protected LearningEnvironment environment = this.envBuilder.buildForTrainer();

    public static <I, L> DatasetTrainer<IgniteModel<I, I>, L> identityTrainer() {
        return new DatasetTrainer<IgniteModel<I, I>, L>(){

            @Override
            public <K, V> IgniteModel<I, I> fitWithInitializedDeployingContext(DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> preprocessor) {
                return x -> x;
            }

            @Override
            protected <K, V> IgniteModel<I, I> updateModel(IgniteModel<I, I> mdl, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> preprocessor) {
                return x -> x;
            }

            @Override
            public boolean isUpdateable(IgniteModel<I, I> mdl) {
                return true;
            }
        };
    }

    public <K, V> M fit(DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> preprocessor) {
        this.learningEnvironment().initDeployingContext(preprocessor);
        return this.fitWithInitializedDeployingContext(datasetBuilder, preprocessor);
    }

    public <K, V> M fit(DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> preprocessor, LearningEnvironment learningEnvironment) {
        this.environment = learningEnvironment;
        return this.fitWithInitializedDeployingContext(datasetBuilder, preprocessor);
    }

    protected abstract <K, V> M fitWithInitializedDeployingContext(DatasetBuilder<K, V> var1, Preprocessor<K, V> var2);

    public <K, V> M update(M mdl, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> preprocessor) {
        if (mdl != null) {
            if (this.isUpdateable(mdl)) {
                this.learningEnvironment().initDeployingContext(preprocessor);
                return this.updateModel(mdl, datasetBuilder, preprocessor);
            }
            this.environment.logger(this.getClass()).log(MLLogger.VerboseLevel.HIGH, "Model cannot be updated because of initial state of it doesn't corresponds to trainer parameters", new Object[0]);
        }
        return this.fit(datasetBuilder, preprocessor);
    }

    public abstract boolean isUpdateable(M var1);

    @NotNull
    protected M getLastTrainedModelOrThrowEmptyDatasetException(M lastTrainedMdl) {
        String msg = "Cannot train model on empty dataset";
        if (lastTrainedMdl != null) {
            this.environment.logger(this.getClass()).log(MLLogger.VerboseLevel.HIGH, msg, new Object[0]);
            return lastTrainedMdl;
        }
        throw new EmptyDatasetException();
    }

    public <K, V> M fit(Ignite ignite, IgniteCache<K, V> cache, Preprocessor<K, V> preprocessor) {
        return this.fit(new CacheBasedDatasetBuilder<K, V>(ignite, cache), preprocessor);
    }

    public <K, V> M update(M mdl, Ignite ignite, IgniteCache<K, V> cache, Preprocessor<K, V> preprocessor) {
        return this.update(mdl, new CacheBasedDatasetBuilder<K, V>(ignite, cache), preprocessor);
    }

    public <K, V> M fit(Ignite ignite, IgniteCache<K, V> cache, IgniteBiPredicate<K, V> filter, Preprocessor<K, V> preprocessor) {
        return this.fit(new CacheBasedDatasetBuilder<K, V>(ignite, cache, filter), preprocessor);
    }

    public <K, V> M update(M mdl, Ignite ignite, IgniteCache<K, V> cache, IgniteBiPredicate<K, V> filter, Preprocessor<K, V> preprocessor) {
        return this.update(mdl, new CacheBasedDatasetBuilder<K, V>(ignite, cache, filter), preprocessor);
    }

    public <K, V> M fit(Map<K, V> data, int parts, Preprocessor<K, V> preprocessor) {
        return this.fit(new LocalDatasetBuilder<K, V>(data, parts), preprocessor);
    }

    public <K, V> M update(M mdl, Map<K, V> data, int parts, Preprocessor<K, V> preprocessor) {
        return this.update(mdl, new LocalDatasetBuilder<K, V>(data, parts), preprocessor);
    }

    public <K, V> M fit(Map<K, V> data, IgniteBiPredicate<K, V> filter, int parts, Preprocessor<K, V> preprocessor) {
        return this.fit(new LocalDatasetBuilder<K, V>(data, filter, parts), preprocessor);
    }

    public <K, V> M update(M mdl, Map<K, V> data, IgniteBiPredicate<K, V> filter, int parts, Preprocessor<K, V> preprocessor) {
        return this.update(mdl, new LocalDatasetBuilder<K, V>(data, filter, parts), preprocessor);
    }

    public DatasetTrainer<M, L> withEnvironmentBuilder(LearningEnvironmentBuilder envBuilder) {
        this.envBuilder = envBuilder;
        this.environment = envBuilder.buildForTrainer();
        return this;
    }

    protected abstract <K, V> M updateModel(M var1, DatasetBuilder<K, V> var2, Preprocessor<K, V> var3);

    public LearningEnvironment learningEnvironment() {
        return this.environment;
    }

    public <L1> DatasetTrainer<M, L1> withConvertedLabels(final IgniteFunction<L1, L> new2Old) {
        final DatasetTrainer old = this;
        return new DatasetTrainer<M, L1>(){

            private <K, V> Preprocessor<K, V> getNewExtractor(Preprocessor<K, V> extractor) {
                IgniteFunction func = lv -> new LabeledVector((Vector)lv.features(), new2Old.apply(lv.label()));
                return new PatchedPreprocessor(func, extractor);
            }

            public <K, V> M fit(DatasetBuilder<K, V> datasetBuilder, Vectorizer<K, V, Integer, L1> extractor) {
                return old.fit(datasetBuilder, this.getNewExtractor(extractor));
            }

            @Override
            protected <K, V> M updateModel(M mdl, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> preprocessor) {
                return old.updateModel(mdl, datasetBuilder, this.getNewExtractor(preprocessor));
            }

            @Override
            public <K, V> M fitWithInitializedDeployingContext(DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> preprocessor) {
                return old.fit(datasetBuilder, this.getNewExtractor(preprocessor));
            }

            @Override
            public boolean isUpdateable(M mdl) {
                return old.isUpdateable(mdl);
            }
        };
    }

    public static class EmptyDatasetException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 6914650522523293521L;

        public EmptyDatasetException() {
            super("Cannot train model on empty dataset");
        }
    }
}

