/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.io.Serializable;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.BinaryClassificationPointwiseMetricStatsAggregator;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetric;

public class Npv<L extends Serializable>
extends BinaryClassificationMetric<L> {
    private static final long serialVersionUID = -2974485980038821226L;
    private Double value = Double.NaN;

    public Npv() {
    }

    public Npv(L truthLabel, L falseLabel) {
        super(truthLabel, falseLabel);
    }

    public Npv<L> initBy(BinaryClassificationPointwiseMetricStatsAggregator<L> aggr) {
        int negativePredictions = aggr.getFalseNegative() + aggr.getTrueNegative();
        this.value = negativePredictions == 0 ? 1.0 : (double)aggr.getTrueNegative() / (double)negativePredictions;
        return this;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public MetricName name() {
        return MetricName.NPV;
    }
}

