/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment.logging;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.environment.logging.MLLogger;
import org.apache.ignite.ml.math.Tracer;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class CustomMLLogger
implements MLLogger {
    private final IgniteLogger log;

    private CustomMLLogger(IgniteLogger log) {
        this.log = log;
    }

    public static Factory factory(IgniteLogger rootLog) {
        return new Factory(rootLog);
    }

    @Override
    public Vector log(Vector vector) {
        Tracer.showAscii(vector, this.log);
        return vector;
    }

    @Override
    public <K, V> IgniteModel<K, V> log(MLLogger.VerboseLevel verboseLevel, IgniteModel<K, V> mdl) {
        this.log(verboseLevel, mdl.toString(true));
        return mdl;
    }

    @Override
    public void log(MLLogger.VerboseLevel verboseLevel, String fmtStr, Object ... params) {
        this.log(verboseLevel, String.format(fmtStr, params));
    }

    private void log(MLLogger.VerboseLevel verboseLevel, String line) {
        switch (verboseLevel) {
            case LOW: {
                this.log.info(line);
                break;
            }
            case HIGH: {
                this.log.debug(line);
            }
        }
    }

    private static class Factory
    implements MLLogger.Factory {
        private IgniteLogger rootLog;

        public Factory(IgniteLogger rootLog) {
            this.rootLog = rootLog;
        }

        @Override
        public <T> MLLogger create(Class<T> targetCls) {
            return new CustomMLLogger(this.rootLog.getLogger(targetCls));
        }
    }
}

