/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class EstimationUtils$ {
    public static final EstimationUtils$ MODULE$;

    static {
        new EstimationUtils$();
    }

    public boolean rowCountsExist(Seq<LogicalPlan> plans2) {
        return plans2.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogicalPlan x$1) {
                return x$1.stats().rowCount().isDefined();
            }
        });
    }

    public boolean columnStatsExist(Seq<Tuple2<Statistics, Attribute>> statsAndAttr) {
        return statsAndAttr.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Statistics, Attribute> x0$1) {
                Tuple2<Statistics, Attribute> tuple2 = x0$1;
                if (tuple2 != null) {
                    Statistics stats2 = (Statistics)tuple2._1();
                    Attribute attr = (Attribute)tuple2._2();
                    boolean bl = stats2.attributeStats().contains(attr);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public ColumnStat nullColumnStat(DataType dataType2, BigInt rowCount) {
        return new ColumnStat(BigInt$.MODULE$.int2bigInt(0), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, rowCount, dataType2.defaultSize(), dataType2.defaultSize(), ColumnStat$.MODULE$.apply$default$7());
    }

    public BigInt updateNdv(BigInt oldNumRows, BigInt newNumRows, BigInt oldNdv) {
        return newNumRows.$less(oldNumRows) ? this.ceil(package$.MODULE$.BigDecimal().apply(oldNdv).$times(package$.MODULE$.BigDecimal().apply(newNumRows)).$div(package$.MODULE$.BigDecimal().apply(oldNumRows))) : oldNdv;
    }

    public BigInt ceil(BigDecimal bigDecimal) {
        return bigDecimal.setScale(0, BigDecimal.RoundingMode$.MODULE$.CEILING()).toBigInt();
    }

    public AttributeMap<ColumnStat> getOutputMap(AttributeMap<ColumnStat> inputMap, Seq<Attribute> output2) {
        return AttributeMap$.MODULE$.apply((Seq)output2.flatMap((Function1)new Serializable(inputMap){
            public static final long serialVersionUID = 0L;
            private final AttributeMap inputMap$1;

            public final Iterable<Tuple2<Attribute, ColumnStat>> apply(Attribute a) {
                return Option$.MODULE$.option2Iterable(this.inputMap$1.get(a).map((Function1)new Serializable(this, a){
                    public static final long serialVersionUID = 0L;
                    private final Attribute a$1;

                    public final Tuple2<Attribute, ColumnStat> apply(ColumnStat x$2) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.a$1), (Object)x$2);
                    }
                    {
                        this.a$1 = a$1;
                    }
                }));
            }
            {
                this.inputMap$1 = inputMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public BigInt getOutputSize(Seq<Attribute> attributes, BigInt outputRowCount, AttributeMap<ColumnStat> attrStats) {
        long sizePerRow = 8L + BoxesRunTime.unboxToLong((Object)((TraversableOnce)attributes.map((Function1)new Serializable(attrStats){
            public static final long serialVersionUID = 0L;
            private final AttributeMap attrStats$1;

            public final long apply(Attribute attr) {
                long l;
                if (this.attrStats$1.contains(attr)) {
                    DataType dataType2 = attr.dataType();
                    long l2 = StringType$.MODULE$.equals(dataType2) ? ((ColumnStat)this.attrStats$1.apply(attr)).avgLen() + 8L + 4L : ((ColumnStat)this.attrStats$1.apply(attr)).avgLen();
                    l = l2;
                } else {
                    l = attr.dataType().defaultSize();
                }
                return l;
            }
            {
                this.attrStats$1 = attrStats$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return outputRowCount.$greater(BigInt$.MODULE$.int2bigInt(0)) ? outputRowCount.$times(BigInt$.MODULE$.long2bigInt(sizePerRow)) : BigInt$.MODULE$.int2bigInt(1);
    }

    public AttributeMap<ColumnStat> getOutputSize$default$3() {
        return AttributeMap$.MODULE$.apply(Nil$.MODULE$);
    }

    public double toDouble(Object value2, DataType dataType2) {
        DataType dataType3;
        block4: {
            double d;
            block3: {
                block2: {
                    dataType3 = dataType2;
                    boolean bl = dataType3 instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType3) ? true : TimestampType$.MODULE$.equals(dataType3));
                    if (!bl) break block2;
                    d = new StringOps(Predef$.MODULE$.augmentString(value2.toString())).toDouble();
                    break block3;
                }
                if (!BooleanType$.MODULE$.equals(dataType3)) break block4;
                d = BoxesRunTime.unboxToBoolean((Object)value2) ? 1.0 : 0.0;
            }
            return d;
        }
        throw new MatchError((Object)dataType3);
    }

    public Object fromDouble(double d, DataType dataType2) {
        DataType dataType3;
        block12: {
            Object object;
            block3: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    dataType3 = dataType2;
                                                    if (!BooleanType$.MODULE$.equals(dataType3)) break block2;
                                                    object = BoxesRunTime.boxToBoolean(((int)d == 1 ? 1 : 0) != 0);
                                                    break block3;
                                                }
                                                if (!DateType$.MODULE$.equals(dataType3)) break block4;
                                                object = BoxesRunTime.boxToInteger((int)((int)d));
                                                break block3;
                                            }
                                            if (!TimestampType$.MODULE$.equals(dataType3)) break block5;
                                            object = BoxesRunTime.boxToLong((long)((long)d));
                                            break block3;
                                        }
                                        if (!ByteType$.MODULE$.equals(dataType3)) break block6;
                                        object = BoxesRunTime.boxToByte((byte)((byte)d));
                                        break block3;
                                    }
                                    if (!ShortType$.MODULE$.equals(dataType3)) break block7;
                                    object = BoxesRunTime.boxToShort((short)((short)d));
                                    break block3;
                                }
                                if (!IntegerType$.MODULE$.equals(dataType3)) break block8;
                                object = BoxesRunTime.boxToInteger((int)((int)d));
                                break block3;
                            }
                            if (!LongType$.MODULE$.equals(dataType3)) break block9;
                            object = BoxesRunTime.boxToLong((long)((long)d));
                            break block3;
                        }
                        if (!FloatType$.MODULE$.equals(dataType3)) break block10;
                        object = BoxesRunTime.boxToFloat((float)((float)d));
                        break block3;
                    }
                    if (!DoubleType$.MODULE$.equals(dataType3)) break block11;
                    object = BoxesRunTime.boxToDouble((double)d);
                    break block3;
                }
                if (!(dataType3 instanceof DecimalType)) break block12;
                object = Decimal$.MODULE$.apply(d);
            }
            return object;
        }
        throw new MatchError((Object)dataType3);
    }

    private int findFirstBinForValue(double value2, HistogramBin[] bins) {
        int i;
        for (i = 0; i < bins.length && value2 > bins[i].hi(); ++i) {
        }
        return i;
    }

    private int findLastBinForValue(double value2, HistogramBin[] bins) {
        int i;
        for (i = bins.length - 1; i >= 0 && value2 < bins[i].lo(); --i) {
        }
        return i;
    }

    private double binHoldingRangePossibility(double upperBound, double lowerBound, HistogramBin bin) {
        Predef$.MODULE$.assert(bin.lo() <= lowerBound && lowerBound <= upperBound && upperBound <= bin.hi());
        return bin.hi() == bin.lo() ? 1.0 : (upperBound == lowerBound ? 1.0 / (double)bin.ndv() : scala.math.package$.MODULE$.min((upperBound - lowerBound) / (bin.hi() - bin.lo()), 1.0));
    }

    public double numBinsHoldingRange(double upperBound, boolean upperBoundInclusive, double lowerBound, boolean lowerBoundInclusive, HistogramBin[] bins) {
        double d;
        Predef$.MODULE$.assert(((HistogramBin)Predef$.MODULE$.refArrayOps((Object[])bins).head()).lo() <= lowerBound && lowerBound <= upperBound && upperBound <= ((HistogramBin)Predef$.MODULE$.refArrayOps((Object[])bins).last()).hi(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Given range does not fit in the given histogram.";
            }
        });
        Predef$.MODULE$.assert(upperBound != lowerBound || upperBoundInclusive || lowerBoundInclusive, (Function0)new Serializable(upperBound, lowerBound){
            public static final long serialVersionUID = 0L;
            private final double upperBound$1;
            private final double lowerBound$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", " < value < ", "' is an invalid range."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.lowerBound$1), BoxesRunTime.boxToDouble((double)this.upperBound$1)}));
            }
            {
                this.upperBound$1 = upperBound$1;
                this.lowerBound$1 = lowerBound$1;
            }
        });
        int upperBinIndex = upperBoundInclusive ? this.findLastBinForValue(upperBound, bins) : this.findFirstBinForValue(upperBound, bins);
        int lowerBinIndex = lowerBoundInclusive ? this.findFirstBinForValue(lowerBound, bins) : this.findLastBinForValue(lowerBound, bins);
        Predef$.MODULE$.assert(lowerBinIndex <= upperBinIndex, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid histogram data.";
            }
        });
        if (lowerBinIndex == upperBinIndex) {
            d = this.binHoldingRangePossibility(upperBound, lowerBound, bins[lowerBinIndex]);
        } else {
            HistogramBin lowerBin = bins[lowerBinIndex];
            double lowerPart = this.binHoldingRangePossibility(lowerBin.hi(), lowerBound, lowerBin);
            HistogramBin higherBin = bins[upperBinIndex];
            double higherPart = this.binHoldingRangePossibility(upperBound, higherBin.lo(), higherBin);
            d = lowerPart + higherPart + (double)upperBinIndex - (double)lowerBinIndex - 1.0;
        }
        return d;
    }

    public Seq<EstimationUtils.OverlappedRange> getOverlappedRanges(Histogram leftHistogram, Histogram rightHistogram, double lowerBound, double upperBound) {
        ArrayBuffer overlappedRanges = new ArrayBuffer();
        HistogramBin[] leftBins = (HistogramBin[])Predef$.MODULE$.refArrayOps((Object[])leftHistogram.bins()).filter((Function1)new Serializable(lowerBound, upperBound){
            public static final long serialVersionUID = 0L;
            private final double lowerBound$2;
            private final double upperBound$2;

            public final boolean apply(HistogramBin b) {
                return b.lo() <= this.upperBound$2 && b.hi() >= this.lowerBound$2;
            }
            {
                this.lowerBound$2 = lowerBound$2;
                this.upperBound$2 = upperBound$2;
            }
        });
        HistogramBin[] rightBins = (HistogramBin[])Predef$.MODULE$.refArrayOps((Object[])rightHistogram.bins()).filter((Function1)new Serializable(lowerBound, upperBound){
            public static final long serialVersionUID = 0L;
            private final double lowerBound$2;
            private final double upperBound$2;

            public final boolean apply(HistogramBin b) {
                return b.lo() <= this.upperBound$2 && b.hi() >= this.lowerBound$2;
            }
            {
                this.lowerBound$2 = lowerBound$2;
                this.upperBound$2 = upperBound$2;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])leftBins).foreach((Function1)new Serializable(leftHistogram, rightHistogram, lowerBound, upperBound, overlappedRanges, rightBins){
            public static final long serialVersionUID = 0L;
            public final Histogram leftHistogram$1;
            public final Histogram rightHistogram$1;
            public final double lowerBound$2;
            public final double upperBound$2;
            public final ArrayBuffer overlappedRanges$1;
            private final HistogramBin[] rightBins$1;

            public final void apply(HistogramBin lb) {
                Predef$.MODULE$.refArrayOps((Object[])this.rightBins$1).foreach((Function1)new Serializable(this, lb){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getOverlappedRanges.1 $outer;
                    private final HistogramBin lb$1;

                    public final Object apply(HistogramBin rb) {
                        Tuple2<HistogramBin, Object> tuple2 = EstimationUtils$.MODULE$.trimBin(this.lb$1, this.$outer.leftHistogram$1.height(), this.$outer.lowerBound$2, this.$outer.upperBound$2);
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            HistogramBin left = (HistogramBin)tuple2._1();
                            double leftHeight = tuple2._2$mcD$sp();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)left, (Object)BoxesRunTime.boxToDouble((double)leftHeight));
                            HistogramBin left2 = (HistogramBin)tuple23._1();
                            double leftHeight2 = tuple23._2$mcD$sp();
                            Tuple2<HistogramBin, Object> tuple24 = EstimationUtils$.MODULE$.trimBin(rb, this.$outer.rightHistogram$1.height(), this.$outer.lowerBound$2, this.$outer.upperBound$2);
                            if (tuple24 != null) {
                                BoxedUnit boxedUnit;
                                Tuple2 tuple25;
                                HistogramBin right = (HistogramBin)tuple24._1();
                                double rightHeight = tuple24._2$mcD$sp();
                                Tuple2 tuple26 = tuple25 = new Tuple2((Object)right, (Object)BoxesRunTime.boxToDouble((double)rightHeight));
                                HistogramBin right2 = (HistogramBin)tuple26._1();
                                double rightHeight2 = tuple26._2$mcD$sp();
                                if (left2.lo() <= right2.hi() && left2.hi() >= right2.lo()) {
                                    EstimationUtils.OverlappedRange overlappedRange;
                                    if (right2.lo() >= left2.lo() && right2.hi() >= left2.hi()) {
                                        if (left2.hi() == right2.lo()) {
                                            overlappedRange = new EstimationUtils.OverlappedRange(right2.lo(), right2.lo(), 1.0, 1.0, leftHeight2 / (double)left2.ndv(), rightHeight2 / (double)right2.ndv());
                                        } else {
                                            double leftRatio = (left2.hi() - right2.lo()) / (left2.hi() - left2.lo());
                                            double rightRatio = (left2.hi() - right2.lo()) / (right2.hi() - right2.lo());
                                            overlappedRange = new EstimationUtils.OverlappedRange(right2.lo(), left2.hi(), (double)left2.ndv() * leftRatio, (double)right2.ndv() * rightRatio, leftHeight2 * leftRatio, rightHeight2 * rightRatio);
                                        }
                                    } else if (right2.lo() <= left2.lo() && right2.hi() <= left2.hi()) {
                                        if (right2.hi() == left2.lo()) {
                                            overlappedRange = new EstimationUtils.OverlappedRange(right2.hi(), right2.hi(), 1.0, 1.0, leftHeight2 / (double)left2.ndv(), rightHeight2 / (double)right2.ndv());
                                        } else {
                                            double leftRatio = (right2.hi() - left2.lo()) / (left2.hi() - left2.lo());
                                            double rightRatio = (right2.hi() - left2.lo()) / (right2.hi() - right2.lo());
                                            overlappedRange = new EstimationUtils.OverlappedRange(left2.lo(), right2.hi(), (double)left2.ndv() * leftRatio, (double)right2.ndv() * rightRatio, leftHeight2 * leftRatio, rightHeight2 * rightRatio);
                                        }
                                    } else if (right2.lo() >= left2.lo() && right2.hi() <= left2.hi()) {
                                        double leftRatio = (right2.hi() - right2.lo()) / (left2.hi() - left2.lo());
                                        overlappedRange = new EstimationUtils.OverlappedRange(right2.lo(), right2.hi(), (double)left2.ndv() * leftRatio, right2.ndv(), leftHeight2 * leftRatio, rightHeight2);
                                    } else {
                                        Predef$.MODULE$.assert(right2.lo() <= left2.lo() && right2.hi() >= left2.hi());
                                        double rightRatio = (left2.hi() - left2.lo()) / (right2.hi() - right2.lo());
                                        overlappedRange = new EstimationUtils.OverlappedRange(left2.lo(), left2.hi(), left2.ndv(), (double)right2.ndv() * rightRatio, leftHeight2, rightHeight2 * rightRatio);
                                    }
                                    EstimationUtils.OverlappedRange range = overlappedRange;
                                    boxedUnit = this.$outer.overlappedRanges$1.$plus$eq((Object)range);
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                return boxedUnit;
                            }
                            throw new MatchError(tuple24);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.lb$1 = lb$1;
                    }
                });
            }
            {
                this.leftHistogram$1 = leftHistogram$1;
                this.rightHistogram$1 = rightHistogram$1;
                this.lowerBound$2 = lowerBound$2;
                this.upperBound$2 = upperBound$2;
                this.overlappedRanges$1 = overlappedRanges$1;
                this.rightBins$1 = rightBins$1;
            }
        });
        return overlappedRanges;
    }

    public Tuple2<HistogramBin, Object> trimBin(HistogramBin bin, double height, double lowerBound, double upperBound) {
        Tuple2.mcDD.sp sp2;
        Tuple2.mcDD.sp sp3;
        if (bin.lo() <= lowerBound && bin.hi() >= upperBound) {
            sp3 = new Tuple2.mcDD.sp(lowerBound, upperBound);
        } else if (bin.lo() <= lowerBound && bin.hi() >= lowerBound) {
            sp3 = new Tuple2.mcDD.sp(lowerBound, bin.hi());
        } else if (bin.lo() <= upperBound && bin.hi() >= upperBound) {
            sp3 = new Tuple2.mcDD.sp(bin.lo(), upperBound);
        } else {
            Predef$.MODULE$.assert(bin.lo() >= lowerBound && bin.hi() <= upperBound);
            sp3 = sp2 = new Tuple2.mcDD.sp(bin.lo(), bin.hi());
        }
        if (sp2 != null) {
            Tuple2 tuple2;
            Tuple2.mcDD.sp sp4;
            double lo = sp2._1$mcD$sp();
            double hi = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp5 = sp4 = new Tuple2.mcDD.sp(lo, hi);
            double lo2 = sp5._1$mcD$sp();
            double hi2 = sp5._2$mcD$sp();
            if (hi2 == lo2) {
                tuple2 = new Tuple2((Object)new HistogramBin(lo2, hi2, 1L), (Object)BoxesRunTime.boxToDouble((double)(height / (double)bin.ndv())));
            } else {
                Predef$.MODULE$.assert(bin.hi() != bin.lo());
                double ratio = (hi2 - lo2) / (bin.hi() - bin.lo());
                tuple2 = new Tuple2((Object)new HistogramBin(lo2, hi2, (long)scala.math.package$.MODULE$.ceil((double)bin.ndv() * ratio)), (Object)BoxesRunTime.boxToDouble((double)(height * ratio)));
            }
            return tuple2;
        }
        throw new MatchError((Object)sp2);
    }

    private EstimationUtils$() {
        MODULE$ = this;
    }
}

