/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class StaticIPInfo {
    protected final String ip;
    protected final String user;
    protected final String netmask;
    protected final Set<String> nameservers;
    protected final String gateway;

    public StaticIPInfo(String ip, String user, String netmask, Iterable<String> nameservers, String gateway) {
        this.ip = (String)Preconditions.checkNotNull((Object)ip, (Object)"ip");
        this.user = (String)Preconditions.checkNotNull((Object)user, (Object)"user");
        this.netmask = (String)Preconditions.checkNotNull((Object)netmask, (Object)"netmask");
        this.nameservers = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(nameservers, (Object)"nameservers")));
        this.gateway = (String)Preconditions.checkNotNull((Object)gateway, (Object)"gateway");
    }

    @Nullable
    public String getAddress() {
        return this.ip;
    }

    public String getUser() {
        return this.user;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public Set<String> getNameservers() {
        return this.nameservers;
    }

    public String getGateway() {
        return this.gateway;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 31 * result + (this.nameservers == null ? 0 : ((Object)this.nameservers).hashCode());
        result = 31 * result + (this.netmask == null ? 0 : this.netmask.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticIPInfo other = (StaticIPInfo)obj;
        if (this.gateway == null ? other.gateway != null : !this.gateway.equals(other.gateway)) {
            return false;
        }
        if (this.nameservers == null ? other.nameservers != null : !((Object)this.nameservers).equals(other.nameservers)) {
            return false;
        }
        if (this.netmask == null ? other.netmask != null : !this.netmask.equals(other.netmask)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        return !(this.ip == null ? other.ip != null : !this.ip.equals(other.ip));
    }

    public String toString() {
        return "[ip=" + this.ip + ", user=" + this.user + ", netmask=" + this.netmask + ", nameservers=" + this.nameservers + ", gateway=" + this.gateway + "]";
    }

    public static class Builder {
        protected String ip;
        protected String user;
        protected String netmask;
        protected Set<String> nameservers = ImmutableSet.of();
        protected String gateway;

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder nameservers(Iterable<String> nameservers) {
            this.nameservers = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(nameservers, (Object)"nameservers")));
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public StaticIPInfo build() {
            return new StaticIPInfo(this.ip, this.user, this.netmask, this.nameservers, this.gateway);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
            result = 31 * result + (this.nameservers == null ? 0 : ((Object)this.nameservers).hashCode());
            result = 31 * result + (this.netmask == null ? 0 : this.netmask.hashCode());
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.gateway == null ? other.gateway != null : !this.gateway.equals(other.gateway)) {
                return false;
            }
            if (this.nameservers == null ? other.nameservers != null : !((Object)this.nameservers).equals(other.nameservers)) {
                return false;
            }
            if (this.netmask == null ? other.netmask != null : !this.netmask.equals(other.netmask)) {
                return false;
            }
            if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
                return false;
            }
            return !(this.ip == null ? other.ip != null : !this.ip.equals(other.ip));
        }
    }
}

