/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.config.DockerComputeServiceContextModule;
import org.jclouds.docker.config.DockerHttpApiModule;
import org.jclouds.docker.config.DockerParserModule;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value=ApiMetadata.class)
public class DockerApiMetadata
extends BaseHttpApiMetadata<DockerApi> {
    public static final String DOCKER_CA_CERT_PATH = "docker.cacert.path";
    public static final String DOCKER_CA_CERT_DATA = "docker.cacert.data";

    public Builder toBuilder() {
        return new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public DockerApiMetadata() {
        this(new Builder());
    }

    protected DockerApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.connection-timeout", "1200000");
        properties.setProperty("jclouds.image.login-user", "root:password");
        properties.setProperty("jclouds.template", "osFamily=UBUNTU,os64Bit=true");
        properties.setProperty(DOCKER_CA_CERT_PATH, "");
        properties.setProperty(DOCKER_CA_CERT_DATA, "");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<DockerApi, Builder> {
        protected Builder() {
            super(DockerApi.class);
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("docker")).name("Docker API")).identityName("Path or data for certificate .pem file")).credentialName("Path or data for key .pem file")).documentation(URI.create("https://docs.docker.com/reference/api/docker_remote_api/"))).version("1.16")).defaultEndpoint("https://127.0.0.1:2376")).defaultProperties(DockerApiMetadata.defaultProperties())).view(Reflection2.typeToken(ComputeServiceContext.class))).defaultModules((Set)ImmutableSet.of(DockerParserModule.class, DockerHttpApiModule.class, DockerComputeServiceContextModule.class));
        }

        public DockerApiMetadata build() {
            return new DockerApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            return this;
        }
    }
}

