/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.task;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeExecutionRejectedException;
import org.apache.ignite.compute.ComputeJobSibling;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.compute.ComputeTaskMapAsync;
import org.apache.ignite.compute.ComputeTaskName;
import org.apache.ignite.compute.ComputeTaskSessionFullSupport;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.TaskEvent;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridJobExecuteResponse;
import org.apache.ignite.internal.GridJobSiblingImpl;
import org.apache.ignite.internal.GridJobSiblingsRequest;
import org.apache.ignite.internal.GridJobSiblingsResponse;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskCancelRequest;
import org.apache.ignite.internal.GridTaskNameHashKey;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.GridTaskSessionRequest;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.compute.ComputeTaskCancelledCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.managers.systemview.walker.ComputeTaskViewWalker;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.task.GridTaskEventListener;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.processors.task.GridTaskWorker;
import org.apache.ignite.internal.util.GridConcurrentFactory;
import org.apache.ignite.internal.util.GridSpinReadWriteLock;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.spi.systemview.view.ComputeTaskView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridTaskProcessor
extends GridProcessorAdapter
implements IgniteChangeGlobalStateSupport {
    public static final String TASKS_VIEW = "tasks";
    public static final String TASKS_VIEW_DESC = "Running compute tasks";
    public static final String TOTAL_EXEC_TASKS = "TotalExecutedTasks";
    private static final long DISCO_TIMEOUT = 5000L;
    private static final Map<GridTaskThreadContextKey, Object> EMPTY_ENUM_MAP = new EnumMap<GridTaskThreadContextKey, Object>(GridTaskThreadContextKey.class);
    private final Marshaller marsh;
    private final ConcurrentMap<IgniteUuid, GridTaskWorker<?, ?>> tasks = GridConcurrentFactory.newMap();
    private boolean stopping;
    private boolean waiting;
    private final GridLocalEventListener discoLsnr;
    private final LongAdderMetric execTasks;
    private final ThreadLocal<Map<GridTaskThreadContextKey, Object>> thCtx = new ThreadLocal();
    private final GridSpinReadWriteLock lock = new GridSpinReadWriteLock();
    private volatile IgniteInternalCache<GridTaskNameHashKey, String> tasksMetaCache;
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final boolean isPersistenceEnabled;

    public GridTaskProcessor(GridKernalContext ctx) {
        super(ctx);
        this.marsh = ctx.config().getMarshaller();
        this.discoLsnr = new TaskDiscoveryListener();
        MetricRegistry sysreg = ctx.metric().registry("sys");
        this.execTasks = sysreg.longAdderMetric(TOTAL_EXEC_TASKS, "Total executed tasks.");
        ctx.systemView().registerView(TASKS_VIEW, TASKS_VIEW_DESC, new ComputeTaskViewWalker(), this.tasks.entrySet(), e -> new ComputeTaskView((IgniteUuid)e.getKey(), (GridTaskWorker)e.getValue()));
        this.isPersistenceEnabled = !ctx.clientNode() && GridCacheUtils.isPersistenceEnabled(ctx.config());
    }

    @Override
    public void start() {
        this.ctx.event().addLocalEventListener(this.discoLsnr, 12, 11);
        this.ctx.io().addMessageListener(GridTopic.TOPIC_JOB_SIBLINGS, (GridMessageListener)new JobSiblingsMessageListener());
        this.ctx.io().addMessageListener(GridTopic.TOPIC_TASK_CANCEL, (GridMessageListener)new TaskCancelMessageListener());
        this.ctx.io().addMessageListener(GridTopic.TOPIC_TASK, (GridMessageListener)new JobMessageListener(true));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started task processor.");
        }
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        if (!active) {
            return;
        }
        this.tasksMetaCache = this.ctx.security().enabled() && !this.ctx.isDaemon() ? this.ctx.cache().utilityCache() : null;
        this.startLatch.countDown();
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        IgniteClientDisconnectedCheckedException err = this.disconnectedError(reconnectFut);
        for (GridTaskWorker worker : this.tasks.values()) {
            worker.finishTask(null, err, false);
        }
    }

    private IgniteClientDisconnectedCheckedException disconnectedError(@Nullable IgniteFuture<?> reconnectFut) {
        return new IgniteClientDisconnectedCheckedException(reconnectFut != null ? reconnectFut : this.ctx.cluster().clientReconnectFuture(), "Failed to execute task, client node disconnected.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStop(boolean cancel) {
        boolean interrupted = false;
        while (true) {
            try {
                while (!this.lock.tryWriteLock(1L, TimeUnit.SECONDS)) {
                    LT.warn(this.log, "Still waiting to acquire write lock on stop");
                    U.sleep(50L);
                }
            }
            catch (InterruptedException | IgniteInterruptedCheckedException e) {
                LT.warn(this.log, "Stopping thread was interrupted while waiting for write lock (will wait anyway)");
                interrupted = true;
                continue;
            }
            break;
        }
        try {
            this.stopping = true;
            this.waiting = !cancel;
        }
        finally {
            this.lock.writeUnlock();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        this.startLatch.countDown();
        int size = this.tasks.size();
        if (size > 0) {
            if (cancel) {
                U.warn(this.log, "Will cancel unfinished tasks due to stopping of the grid [cnt=" + size + "]");
            } else {
                U.warn(this.log, "Will wait for all job responses from worker nodes before stopping grid.");
            }
            for (GridTaskWorker task : this.tasks.values()) {
                if (!cancel) {
                    try {
                        task.getTaskFuture().get();
                    }
                    catch (ComputeTaskCancelledCheckedException e) {
                        U.warn(this.log, e.getMessage());
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Task failed: " + task, e);
                    }
                    continue;
                }
                for (ClusterNode node : this.ctx.discovery().nodes(task.getSession().getTopology(), new IgnitePredicate[0])) {
                    if (!this.ctx.localNodeId().equals(node.id())) continue;
                    this.ctx.job().masterLeaveLocal(task.getSession().getId());
                }
                task.cancel();
                ComputeTaskCancelledCheckedException ex = new ComputeTaskCancelledCheckedException("Task cancelled due to stopping of the grid: " + task);
                task.finishTask(null, ex, false);
            }
            U.join(this.tasks.values(), this.log);
        }
        this.ctx.event().removeLocalEventListener(this.discoLsnr, new int[0]);
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_JOB_SIBLINGS);
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_TASK_CANCEL);
        if (!cancel) {
            this.lock.writeLock();
            try {
                this.waiting = false;
            }
            finally {
                this.lock.writeUnlock();
            }
        }
        assert (this.tasks.isEmpty());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished executing task processor onKernalStop() callback.");
        }
    }

    private IgniteInternalCache<GridTaskNameHashKey, String> taskMetaCache() {
        assert (this.ctx.security().enabled());
        if (this.tasksMetaCache == null) {
            U.awaitQuiet(this.startLatch);
        }
        return this.tasksMetaCache;
    }

    @Override
    public void stop(boolean cancel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped task processor.");
        }
    }

    public void setThreadContext(GridTaskThreadContextKey key, Object val) {
        assert (key != null);
        assert (val != null);
        Map<GridTaskThreadContextKey, Object> map = this.thCtx.get();
        if (map == null) {
            map = new EnumMap<GridTaskThreadContextKey, Object>(GridTaskThreadContextKey.class);
            this.thCtx.set(map);
        }
        map.put(key, val);
    }

    public void setThreadContextIfNotNull(GridTaskThreadContextKey key, @Nullable Object val) {
        if (val != null) {
            this.setThreadContext(key, val);
        }
    }

    @Nullable
    public <T> T getThreadContext(GridTaskThreadContextKey key) {
        assert (key != null);
        Map<GridTaskThreadContextKey, Object> map = this.thCtx.get();
        return (T)(map == null ? null : map.get((Object)key));
    }

    public Collection<GridDeployment> getUsedDeployments() {
        return F.viewReadOnly(this.tasks.values(), new C1<GridTaskWorker<?, ?>, GridDeployment>(){

            @Override
            public GridDeployment apply(GridTaskWorker<?, ?> w) {
                return w.getDeployment();
            }
        }, new IgnitePredicate[0]);
    }

    public Map<String, GridDeployment> getUsedDeploymentMap() {
        HashMap<String, GridDeployment> deps = new HashMap<String, GridDeployment>();
        for (GridTaskWorker w : this.tasks.values()) {
            GridTaskSessionImpl ses = w.getSession();
            deps.put(ses.getTaskClassName(), w.getDeployment());
            if (ses.getTaskName() == null || !ses.getTaskClassName().equals(ses.getTaskName())) continue;
            deps.put(ses.getTaskName(), w.getDeployment());
        }
        return deps;
    }

    public <T, R> ComputeTaskInternalFuture<R> execute(Class<? extends ComputeTask<T, R>> taskCls, @Nullable T arg) {
        return this.execute(taskCls, arg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> ComputeTaskInternalFuture<R> execute(Class<? extends ComputeTask<T, R>> taskCls, @Nullable T arg, @Nullable String execName) {
        assert (taskCls != null);
        this.lock.readLock();
        try {
            if (this.stopping) {
                throw new IllegalStateException("Failed to execute task due to grid shutdown: " + taskCls);
            }
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.startTask(null, taskCls, null, IgniteUuid.fromUuid(this.ctx.localNodeId()), arg, false, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    public <T, R> ComputeTaskInternalFuture<R> execute(ComputeTask<T, R> task, @Nullable T arg) {
        return this.execute(task, arg, false, null);
    }

    public <T, R> ComputeTaskInternalFuture<R> execute(ComputeTask<T, R> task, @Nullable T arg, String execName) {
        return this.execute(task, arg, false, execName);
    }

    public <T, R> ComputeTaskInternalFuture<R> execute(ComputeTask<T, R> task, @Nullable T arg, boolean sys) {
        return this.execute(task, arg, sys, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> ComputeTaskInternalFuture<R> execute(ComputeTask<T, R> task, @Nullable T arg, boolean sys, @Nullable String execName) {
        this.lock.readLock();
        try {
            if (this.stopping) {
                throw new IllegalStateException("Failed to execute task due to grid shutdown: " + task);
            }
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.startTask(null, null, task, IgniteUuid.fromUuid(this.ctx.localNodeId()), arg, sys, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    public String resolveTaskName(int taskNameHash) {
        assert (!this.isPersistenceEnabled || !this.ctx.cache().context().database().checkpointLockIsHeldByThread()) : "Resolving a task name should not be executed under the checkpoint lock.";
        if (taskNameHash == 0) {
            return null;
        }
        assert (this.ctx.security().enabled());
        try {
            return this.taskMetaCache().localPeek(new GridTaskNameHashKey(taskNameHash), null);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    public <T, R> ComputeTaskInternalFuture<R> execute(String taskName, @Nullable T arg) {
        return this.execute(taskName, arg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> ComputeTaskInternalFuture<R> execute(String taskName, @Nullable T arg, @Nullable String execName) {
        assert (taskName != null);
        this.lock.readLock();
        try {
            if (this.stopping) {
                throw new IllegalStateException("Failed to execute task due to grid shutdown: " + taskName);
            }
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.startTask(taskName, null, null, IgniteUuid.fromUuid(this.ctx.localNodeId()), arg, false, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    private <T, R> ComputeTaskInternalFuture<R> startTask(@Nullable String taskName, @Nullable Class<?> taskCls, @Nullable ComputeTask<T, R> task, IgniteUuid sesId, @Nullable T arg, boolean sys, @Nullable String execName) {
        ComputeTaskInternalFuture fut;
        block52: {
            long startTime;
            Long timeout;
            long timeout0;
            long endTime;
            assert (sesId != null);
            String taskClsName = task != null ? (task instanceof GridPeerDeployAware ? ((GridPeerDeployAware)((Object)task)).deployClass().getName() : task.getClass().getName()) : (taskCls != null ? taskCls.getName() : taskName);
            Map<GridTaskThreadContextKey, Object> map = this.thCtx.get();
            if (map == null) {
                map = EMPTY_ENUM_MAP;
            } else {
                this.thCtx.set(null);
            }
            if (map.get((Object)GridTaskThreadContextKey.TC_SKIP_AUTH) == null) {
                this.ctx.security().authorize(taskClsName, SecurityPermission.TASK_EXECUTE);
            }
            if ((endTime = (timeout0 = (timeout = (Long)map.get((Object)GridTaskThreadContextKey.TC_TIMEOUT)) == null || timeout == 0L ? Long.MAX_VALUE : timeout) + (startTime = U.currentTimeMillis())) < 0L) {
                endTime = Long.MAX_VALUE;
            }
            IgniteCheckedException deployEx = null;
            GridDeployment dep = null;
            if (taskName != null) {
                assert (taskCls == null);
                assert (task == null);
                try {
                    dep = this.ctx.deploy().getDeployment(taskName);
                    if (dep == null) {
                        throw new IgniteDeploymentCheckedException("Unknown task name or failed to auto-deploy task (was task (re|un)deployed?): " + taskName);
                    }
                    IgniteBiTuple<Class<?>, Throwable> cls = dep.deployedClass(taskName, new String[0]);
                    if (cls.get1() == null) {
                        throw new IgniteDeploymentCheckedException("Unknown task name or failed to auto-deploy task (was task (re|un)deployed?) [taskName=" + taskName + ", dep=" + dep + ']', cls.get2());
                    }
                    taskCls = cls.get1();
                    if (!ComputeTask.class.isAssignableFrom(taskCls)) {
                        throw new IgniteCheckedException("Failed to auto-deploy task (deployed class is not a task) [taskName=" + taskName + ", depCls=" + taskCls + ']');
                    }
                }
                catch (IgniteCheckedException e) {
                    deployEx = e;
                }
            } else if (taskCls != null) {
                assert (task == null);
                try {
                    dep = this.ctx.deploy().deploy(taskCls, U.detectClassLoader(taskCls));
                    if (dep == null) {
                        throw new IgniteDeploymentCheckedException("Failed to auto-deploy task (was task (re|un)deployed?): " + taskCls);
                    }
                    taskName = this.taskName(dep, taskCls, map);
                }
                catch (IgniteCheckedException e) {
                    taskName = taskCls.getName();
                    deployEx = e;
                }
            } else if (task != null) {
                try {
                    ClassLoader ldr;
                    Class<?> cls;
                    if (task instanceof GridPeerDeployAware) {
                        GridPeerDeployAware depAware = (GridPeerDeployAware)((Object)task);
                        cls = depAware.deployClass();
                        ldr = depAware.classLoader();
                        taskCls = cls;
                    } else {
                        taskCls = task.getClass();
                        assert (ComputeTask.class.isAssignableFrom(taskCls));
                        cls = task.getClass();
                        ldr = U.detectClassLoader(cls);
                    }
                    dep = this.ctx.deploy().deploy(cls, ldr);
                    if (dep == null) {
                        throw new IgniteDeploymentCheckedException("Failed to auto-deploy task (was task (re|un)deployed?): " + cls);
                    }
                    taskName = this.taskName(dep, taskCls, map);
                }
                catch (IgniteCheckedException e) {
                    taskName = task.getClass().getName();
                    deployEx = e;
                }
            }
            assert (taskName != null);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Task deployment: " + dep);
            }
            boolean fullSup = dep != null && taskCls != null && dep.annotation(taskCls, ComputeTaskSessionFullSupport.class) != null;
            Collection<UUID> top = null;
            IgnitePredicate topPred = (IgnitePredicate)map.get((Object)GridTaskThreadContextKey.TC_SUBGRID_PREDICATE);
            if (topPred == null) {
                Collection nodes = (Collection)map.get((Object)GridTaskThreadContextKey.TC_SUBGRID);
                top = nodes != null ? F.nodeIds(nodes) : null;
            }
            boolean internal = false;
            if (dep == null || taskCls == null) {
                assert (deployEx != null);
            } else {
                internal = dep.internalTask(task, taskCls);
            }
            GridTaskSessionImpl ses = this.ctx.session().createTaskSession(sesId, this.ctx.localNodeId(), taskName, dep, taskCls == null ? null : taskCls.getName(), top, topPred, startTime, endTime, Collections.emptyList(), Collections.emptyMap(), fullSup, internal, execName);
            fut = new ComputeTaskInternalFuture(ses, this.ctx);
            IgniteCheckedException securityEx = null;
            if (this.ctx.security().enabled() && deployEx == null && !dep.internalTask(task, taskCls)) {
                try {
                    this.saveTaskMetadata(taskName);
                }
                catch (IgniteCheckedException e) {
                    securityEx = e;
                }
            }
            if (deployEx == null && securityEx == null) {
                if (dep == null || !dep.acquire()) {
                    this.handleException(new IgniteDeploymentCheckedException("Task not deployed: " + ses.getTaskName()), fut);
                } else {
                    GridTaskWorker taskWorker = new GridTaskWorker(this.ctx, arg, ses, fut, taskCls, task, dep, new TaskEventListener(), map, SecurityUtils.securitySubjectId(this.ctx));
                    GridTaskWorker taskWorker0 = this.tasks.putIfAbsent(sesId, taskWorker);
                    assert (taskWorker0 == null) : "Session ID is not unique: " + sesId;
                    if (this.ctx.event().isRecordable(26) && dep.visorManagementTask(task, taskCls)) {
                        VisorTaskArgument visorTaskArgument = (VisorTaskArgument)arg;
                        TaskEvent evt = new TaskEvent(this.ctx.discovery().localNode(), visorTaskArgument != null && visorTaskArgument.getArgument() != null ? visorTaskArgument.getArgument().toString() : "[]", 26, ses.getId(), taskCls == null ? null : taskCls.getSimpleName(), "VisorManagementTask", false, SecurityUtils.securitySubjectId(this.ctx));
                        this.ctx.event().record(evt);
                    }
                    if (!this.ctx.clientDisconnected()) {
                        if (dep.annotation(taskCls, ComputeTaskMapAsync.class) != null) {
                            try {
                                if (sys) {
                                    this.ctx.pools().getSystemExecutorService().execute(taskWorker);
                                    break block52;
                                }
                                this.ctx.pools().getExecutorService().execute(taskWorker);
                            }
                            catch (RejectedExecutionException e) {
                                this.tasks.remove(sesId);
                                this.release(dep);
                                this.handleException(new ComputeExecutionRejectedException("Failed to execute task due to thread pool execution rejection: " + taskName, e), fut);
                            }
                        } else {
                            taskWorker.run();
                        }
                    } else {
                        taskWorker.finishTask(null, this.disconnectedError(null));
                    }
                }
            } else if (deployEx != null) {
                this.handleException(deployEx, fut);
            } else {
                this.handleException(securityEx, fut);
            }
        }
        return fut;
    }

    @Nullable
    public <R> ComputeTaskInternalFuture<R> taskFuture(IgniteUuid sesId) {
        GridTaskWorker taskWorker = (GridTaskWorker)this.tasks.get(sesId);
        return taskWorker != null ? taskWorker.getTaskFuture() : null;
    }

    public <R> Map<IgniteUuid, ComputeTaskFuture<R>> taskFutures() {
        HashMap<IgniteUuid, ComputeTaskFuture<R>> res = U.newHashMap(this.tasks.size());
        for (GridTaskWorker taskWorker : this.tasks.values()) {
            ComputeTaskInternalFuture fut = taskWorker.getTaskFuture();
            res.put(fut.getTaskSession().getId(), fut.publicFuture());
        }
        return res;
    }

    private String taskName(GridDeployment dep, Class<?> cls, Map<GridTaskThreadContextKey, Object> map) throws IgniteCheckedException {
        String taskName;
        assert (dep != null);
        assert (cls != null);
        assert (map != null);
        ComputeTaskName ann = dep.annotation(cls, ComputeTaskName.class);
        if (ann != null) {
            taskName = ann.value();
            if (F.isEmpty(taskName)) {
                throw new IgniteCheckedException("Task name specified by @ComputeTaskName annotation cannot be empty for class: " + cls);
            }
        } else {
            taskName = map.containsKey((Object)GridTaskThreadContextKey.TC_TASK_NAME) ? (String)map.get((Object)GridTaskThreadContextKey.TC_TASK_NAME) : cls.getName();
        }
        return taskName;
    }

    private void saveTaskMetadata(String taskName) throws IgniteCheckedException {
        if (this.ctx.isDaemon()) {
            return;
        }
        assert (this.ctx.security().enabled());
        int nameHash = taskName.hashCode();
        if (nameHash == 0) {
            nameHash = 1;
        }
        GridTaskNameHashKey key = new GridTaskNameHashKey(nameHash);
        IgniteInternalCache<GridTaskNameHashKey, String> tasksMetaCache = this.taskMetaCache();
        String existingName = tasksMetaCache.get(key);
        if (existingName == null) {
            existingName = tasksMetaCache.getAndPutIfAbsent(key, taskName);
        }
        if (existingName != null && !F.eq(existingName, taskName)) {
            throw new IgniteCheckedException("Task name hash collision for security-enabled node [taskName=" + taskName + ", existing taskName=" + existingName + ']');
        }
    }

    private void release(GridDeployment dep) {
        assert (dep != null);
        dep.release();
        if (dep.obsolete()) {
            this.ctx.resource().onUndeployed(dep);
        }
    }

    private <R> void handleException(Throwable ex, ComputeTaskInternalFuture<R> fut) {
        assert (ex != null);
        assert (fut != null);
        fut.onDone(ex);
    }

    public void setAttributes(GridTaskSessionImpl ses, Map<?, ?> attrs) throws IgniteCheckedException {
        long timeout = ses.getEndTime() - U.currentTimeMillis();
        if (timeout <= 0L) {
            U.warn(this.log, "Task execution timed out (remote session attributes won't be set): " + ses);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Setting session attribute(s) from task or future: " + ses);
        }
        this.sendSessionAttributes(attrs, ses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSessionAttributes(Map<?, ?> attrs, GridTaskSessionImpl ses) throws IgniteCheckedException {
        UUID nodeId;
        GridJobSiblingImpl sib;
        assert (attrs != null);
        assert (ses != null);
        Collection<ComputeJobSibling> siblings = ses.getJobSiblings();
        GridIoManager commMgr = this.ctx.io();
        long timeout = ses.getEndTime() - U.currentTimeMillis();
        if (timeout <= 0L) {
            U.warn(this.log, "Session attributes won't be set due to task timeout: " + attrs);
            return;
        }
        HashSet<UUID> rcvrs = new HashSet<UUID>();
        UUID locNodeId = this.ctx.localNodeId();
        GridTaskSessionImpl gridTaskSessionImpl = ses;
        synchronized (gridTaskSessionImpl) {
            if (ses.isClosed()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Setting session attributes on closed session (will ignore): " + ses);
                }
                return;
            }
            ses.setInternal(attrs);
            for (ComputeJobSibling s : siblings) {
                sib = (GridJobSiblingImpl)s;
                nodeId = sib.nodeId();
                if (nodeId.equals(locNodeId) || sib.isJobDone() || rcvrs.contains(nodeId)) continue;
                rcvrs.add(nodeId);
            }
        }
        if (this.ctx.event().isRecordable(24)) {
            TaskEvent evt = new TaskEvent(this.ctx.discovery().localNode(), "Changed attributes: " + attrs, 24, ses.getId(), ses.getTaskName(), ses.getTaskClassName(), false, null);
            this.ctx.event().record(evt);
        }
        IgniteCheckedException ex = null;
        for (ComputeJobSibling s : ses.getJobSiblings()) {
            ClusterNode node;
            sib = (GridJobSiblingImpl)s;
            nodeId = sib.nodeId();
            if (!rcvrs.remove(nodeId) || (node = this.ctx.discovery().node(nodeId)) == null) continue;
            boolean loc = node.id().equals(this.ctx.localNodeId()) && !this.ctx.config().isMarshalLocalJobs();
            GridTaskSessionRequest req = new GridTaskSessionRequest(ses.getId(), null, loc ? null : U.marshal(this.marsh, attrs), attrs);
            try {
                commMgr.sendOrderedMessage(node, sib.jobTopic(), req, (byte)2, timeout, false);
            }
            catch (IgniteCheckedException e) {
                ClusterNode clusterNode = node = e instanceof ClusterTopologyCheckedException ? null : this.ctx.discovery().node(nodeId);
                if (node != null) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        U.warn(this.log, "Got interrupted while sending session attributes.");
                    }
                    node = this.ctx.discovery().node(nodeId);
                }
                String err = "Failed to send session attribute request message to node (normal case if node left grid) [node=" + node + ", req=" + req + ']';
                if (node != null) {
                    U.warn(this.log, err);
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug(err);
                }
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processJobExecuteResponse(UUID nodeId, GridJobExecuteResponse msg) {
        assert (nodeId != null);
        assert (msg != null);
        this.lock.readLock();
        try {
            GridTaskWorker task = (GridTaskWorker)this.tasks.get(msg.getSessionId());
            if (this.stopping && !this.waiting) {
                U.warn(this.log, "Received job execution response while stopping grid (will ignore): " + msg + GridTaskProcessor.tryResolveTaskName(task));
                return;
            }
            if (task == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received job execution response for unknown task (was task already reduced?): " + msg);
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received grid job response message [msg=" + msg + ", nodeId=" + nodeId + ']');
            }
            task.onResponse(msg);
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTaskSessionRequest(UUID nodeId, GridTaskSessionRequest msg) {
        assert (nodeId != null);
        assert (msg != null);
        this.lock.readLock();
        try {
            GridTaskWorker task = (GridTaskWorker)this.tasks.get(msg.getSessionId());
            if (this.stopping && !this.waiting) {
                U.warn(this.log, "Received task session request while stopping grid (will ignore): " + msg + GridTaskProcessor.tryResolveTaskName(task));
                return;
            }
            if (task == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received task session request for unknown task (was task already reduced?): " + msg);
                }
                return;
            }
            boolean loc = this.ctx.localNodeId().equals(nodeId) && !this.ctx.config().isMarshalLocalJobs();
            Map attrs = loc ? msg.getAttributes() : (Map)U.unmarshal(this.marsh, msg.getAttributesBytes(), U.resolveClassLoader(task.getTask().getClass().getClassLoader(), this.ctx.config()));
            GridTaskSessionImpl ses = task.getSession();
            this.sendSessionAttributes(attrs, ses);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to deserialize session request: " + msg, e);
        }
        finally {
            this.lock.readUnlock();
        }
    }

    public void onCancelled(IgniteUuid sesId) {
        assert (sesId != null);
        this.lock.readLock();
        try {
            GridTaskWorker task = (GridTaskWorker)this.tasks.get(sesId);
            if (this.stopping && !this.waiting) {
                U.warn(this.log, "Attempt to cancel task while stopping grid (will ignore): " + sesId + GridTaskProcessor.tryResolveTaskName(task));
                return;
            }
            if (task == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Attempt to cancel unknown task (was task already reduced?): " + sesId);
                }
                return;
            }
            task.finishTask(null, new ComputeTaskCancelledCheckedException("Task was cancelled."), true);
        }
        finally {
            this.lock.readUnlock();
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        this.onKernalStart(true);
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        this.onKernalStop(true);
    }

    public void resetMetrics() {
        this.execTasks.reset();
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> Task processor memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']', new Object[0]);
        X.println(">>>  tasksSize: " + this.tasks.size(), new Object[0]);
    }

    @NotNull
    private static String tryResolveTaskName(@Nullable GridTaskWorker<?, ?> task) {
        return task != null && task.getSession() != null ? ", task name: " + task.getSession().getTaskName() : "";
    }

    private class TaskCancelMessageListener
    implements GridMessageListener {
        private TaskCancelMessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            assert (msg != null);
            if (!(msg instanceof GridTaskCancelRequest)) {
                U.warn(GridTaskProcessor.this.log, "Received unexpected message instead of task cancel request: " + msg);
                return;
            }
            GridTaskCancelRequest req = (GridTaskCancelRequest)msg;
            GridTaskProcessor.this.lock.readLock();
            try {
                GridTaskWorker gridTaskWorker = (GridTaskWorker)GridTaskProcessor.this.tasks.get(req.sessionId());
                if (GridTaskProcessor.this.stopping && !GridTaskProcessor.this.waiting) {
                    U.warn(GridTaskProcessor.this.log, "Received task cancel request while stopping grid (will ignore): " + msg + GridTaskProcessor.tryResolveTaskName(gridTaskWorker));
                    return;
                }
                if (gridTaskWorker != null) {
                    try {
                        gridTaskWorker.getTaskFuture().cancel();
                    }
                    catch (IgniteCheckedException e) {
                        GridTaskProcessor.this.log.warning("Failed to cancel task: " + gridTaskWorker.getTask(), e);
                    }
                }
            }
            finally {
                GridTaskProcessor.this.lock.readUnlock();
            }
        }
    }

    private class JobSiblingsMessageListener
    implements GridMessageListener {
        private JobSiblingsMessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            if (!(msg instanceof GridJobSiblingsRequest)) {
                U.warn(GridTaskProcessor.this.log, "Received unexpected message instead of siblings request: " + msg);
                return;
            }
            GridTaskProcessor.this.lock.readLock();
            try {
                Collection<ComputeJobSibling> siblings;
                GridJobSiblingsRequest req = (GridJobSiblingsRequest)msg;
                GridTaskWorker worker = (GridTaskWorker)GridTaskProcessor.this.tasks.get(req.sessionId());
                if (GridTaskProcessor.this.stopping && !GridTaskProcessor.this.waiting) {
                    U.warn(GridTaskProcessor.this.log, "Received job siblings request while stopping grid (will ignore): " + msg + GridTaskProcessor.tryResolveTaskName(worker));
                    return;
                }
                if (worker != null) {
                    try {
                        siblings = worker.getSession().getJobSiblings();
                    }
                    catch (IgniteException e) {
                        U.error(GridTaskProcessor.this.log, "Failed to get job siblings [request=" + msg + ", ses=" + worker.getSession() + ']', e);
                        siblings = null;
                    }
                } else {
                    if (GridTaskProcessor.this.log.isDebugEnabled()) {
                        GridTaskProcessor.this.log.debug("Received job siblings request for unknown or finished task (will ignore): " + msg);
                    }
                    siblings = null;
                }
                try {
                    Object topic = req.topic();
                    if (topic == null) {
                        assert (req.topicBytes() != null);
                        topic = U.unmarshal(GridTaskProcessor.this.marsh, req.topicBytes(), U.resolveClassLoader(GridTaskProcessor.this.ctx.config()));
                    }
                    boolean loc = GridTaskProcessor.this.ctx.localNodeId().equals(nodeId);
                    GridTaskProcessor.this.ctx.io().sendToCustomTopic(nodeId, topic, (Message)new GridJobSiblingsResponse(loc ? siblings : null, loc ? null : U.marshal(GridTaskProcessor.this.marsh, siblings)), (byte)2);
                }
                catch (IgniteCheckedException e) {
                    U.error(GridTaskProcessor.this.log, "Failed to send job sibling response.", e);
                }
            }
            finally {
                GridTaskProcessor.this.lock.readUnlock();
            }
        }
    }

    private class TaskDiscoveryListener
    implements GridLocalEventListener {
        private TaskDiscoveryListener() {
        }

        @Override
        public void onEvent(Event evt) {
            assert (evt.type() == 12 || evt.type() == 11);
            final UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
            GridTaskProcessor.this.ctx.closure().runLocalSafe((Runnable)new GridPlainRunnable(){

                @Override
                public void run() {
                    if (!GridTaskProcessor.this.lock.tryReadLock()) {
                        return;
                    }
                    try {
                        for (GridTaskWorker task : GridTaskProcessor.this.tasks.values()) {
                            task.onNodeLeft(nodeId);
                        }
                    }
                    finally {
                        GridTaskProcessor.this.lock.readUnlock();
                    }
                }
            }, false);
        }
    }

    private class JobMessageListener
    implements GridMessageListener {
        private final boolean jobResOnly;

        private JobMessageListener(boolean jobResOnly) {
            this.jobResOnly = jobResOnly;
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            if (msg instanceof GridJobExecuteResponse) {
                GridTaskProcessor.this.processJobExecuteResponse(nodeId, (GridJobExecuteResponse)msg);
            } else if (this.jobResOnly) {
                U.warn(GridTaskProcessor.this.log, "Received message of type other than job response: " + msg);
            } else if (msg instanceof GridTaskSessionRequest) {
                GridTaskProcessor.this.processTaskSessionRequest(nodeId, (GridTaskSessionRequest)msg);
            } else {
                U.warn(GridTaskProcessor.this.log, "Received message of unknown type: " + msg);
            }
        }
    }

    private class TaskEventListener
    implements GridTaskEventListener {
        private final GridMessageListener msgLsnr;

        private TaskEventListener() {
            this.msgLsnr = new JobMessageListener(false);
        }

        @Override
        public void onTaskStarted(GridTaskWorker<?, ?> worker) {
            if (worker.endTime() < Long.MAX_VALUE) {
                GridTaskProcessor.this.ctx.timeout().addTimeoutObject(worker);
            }
        }

        @Override
        public void onJobSend(GridTaskWorker<?, ?> worker, GridJobSiblingImpl sib) {
            if (worker.getSession().isFullSupport()) {
                GridTaskProcessor.this.ctx.io().addMessageListener(sib.taskTopic(), this.msgLsnr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJobFailover(GridTaskWorker<?, ?> worker, GridJobSiblingImpl sib, UUID nodeId) {
            GridIoManager ioMgr = GridTaskProcessor.this.ctx.io();
            if (worker.getSession().isFullSupport()) {
                ioMgr.removeMessageListener(sib.taskTopic(), this.msgLsnr);
                GridTaskSessionImpl gridTaskSessionImpl = worker.getSession();
                synchronized (gridTaskSessionImpl) {
                    sib.nodeId(nodeId);
                }
                ioMgr.addMessageListener(sib.taskTopic(), this.msgLsnr);
            } else {
                GridTaskSessionImpl gridTaskSessionImpl = worker.getSession();
                synchronized (gridTaskSessionImpl) {
                    sib.nodeId(nodeId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJobFinished(GridTaskWorker<?, ?> worker, GridJobSiblingImpl sib) {
            GridTaskSessionImpl gridTaskSessionImpl = worker.getSession();
            synchronized (gridTaskSessionImpl) {
                sib.onJobDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTaskFinished(GridTaskWorker<?, ?> worker) {
            GridTaskSessionImpl ses = worker.getSession();
            if (ses.isFullSupport()) {
                GridTaskSessionImpl gridTaskSessionImpl = worker.getSession();
                synchronized (gridTaskSessionImpl) {
                    worker.getSession().onClosed();
                }
                GridTaskProcessor.this.ctx.checkpoint().onSessionEnd(ses, false);
                GridTaskProcessor.this.ctx.session().removeSession(ses.getId());
            }
            boolean rmv = GridTaskProcessor.this.tasks.remove(worker.getTaskSessionId(), worker);
            assert (rmv);
            if (worker.endTime() < Long.MAX_VALUE) {
                GridTaskProcessor.this.ctx.timeout().removeTimeoutObject(worker);
            }
            GridTaskProcessor.this.release(worker.getDeployment());
            if (!worker.isInternal()) {
                GridTaskProcessor.this.execTasks.increment();
            }
            if (ses.isFullSupport()) {
                try {
                    for (ComputeJobSibling sibling : worker.getSession().getJobSiblings()) {
                        GridJobSiblingImpl s = (GridJobSiblingImpl)sibling;
                        GridTaskProcessor.this.ctx.io().removeMessageListener(s.taskTopic(), this.msgLsnr);
                    }
                }
                catch (IgniteException e) {
                    U.error(GridTaskProcessor.this.log, "Failed to unregister job communication message listeners and counters.", e);
                }
            }
            if (GridTaskProcessor.this.ctx.performanceStatistics().enabled()) {
                GridTaskProcessor.this.ctx.performanceStatistics().task(ses.getId(), ses.getTaskName(), ses.getStartTime(), U.currentTimeMillis() - ses.getStartTime(), worker.affPartId());
            }
        }
    }
}

