/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.security.Security;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.security.sandbox.AccessControllerSandbox;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;
import org.apache.ignite.internal.processors.security.sandbox.NoOpSandbox;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.jetbrains.annotations.Nullable;

public class IgniteSecurityProcessor
implements IgniteSecurity,
GridProcessor {
    private static final String FAILED_OBTAIN_SEC_CTX_MSG = "Failed to obtain a security context.";
    public static final String ATTR_GRID_SEC_PROC_CLASS = "grid.security.processor.class";
    private static final AtomicInteger SANDBOXED_NODES_COUNTER = new AtomicInteger();
    private final ThreadLocal<SecurityContext> curSecCtx = new ThreadLocal();
    private final GridKernalContext ctx;
    private final GridSecurityProcessor secPrc;
    private final JdkMarshaller marsh;
    private final IgniteLogger log;
    private final Map<UUID, SecurityContext> secCtxs = new ConcurrentHashMap<UUID, SecurityContext>();
    private IgniteSandbox sandbox;
    private volatile SecurityContext dfltSecCtx;
    private final OperationSecurityContext dfltOpCtx = new OperationSecurityContext(this, null){

        @Override
        public void close() {
        }
    };

    static boolean hasSandboxedNodes() {
        return SANDBOXED_NODES_COUNTER.get() > 0;
    }

    public IgniteSecurityProcessor(GridKernalContext ctx, GridSecurityProcessor secPrc) {
        assert (ctx != null);
        assert (secPrc != null);
        this.ctx = ctx;
        this.secPrc = secPrc;
        this.marsh = MarshallerUtils.jdkMarshaller(ctx.igniteInstanceName());
        this.log = ctx.log(this.getClass());
    }

    @Override
    public OperationSecurityContext withContext(SecurityContext secCtx) {
        boolean isCurCtxDflt;
        assert (secCtx != null);
        SecurityContext dflt = this.dfltSecCtx;
        SecurityContext cur = this.curSecCtx.get();
        boolean isNewCtxDflt = secCtx == dflt;
        boolean bl = isCurCtxDflt = cur == null;
        if (isCurCtxDflt && isNewCtxDflt) {
            return this.dfltOpCtx;
        }
        this.curSecCtx.set(isNewCtxDflt ? null : secCtx);
        return new OperationSecurityContext(this, isCurCtxDflt ? null : cur);
    }

    @Override
    public OperationSecurityContext withContext(UUID subjId) {
        try {
            ClusterNode node = Optional.ofNullable(this.ctx.discovery().node(subjId)).orElseGet(() -> this.ctx.discovery().historicalNode(subjId));
            SecurityContext res = node == null ? this.secPrc.securityContext(subjId) : (this.dfltSecCtx.subject().id().equals(subjId) ? this.dfltSecCtx : this.secCtxs.computeIfAbsent(subjId, uuid -> SecurityUtils.nodeSecurityContext(this.marsh, U.resolveClassLoader(this.ctx.config()), node)));
            if (res == null) {
                throw new IllegalStateException("Failed to find security context for subject with given ID : " + subjId);
            }
            return this.withContext(res);
        }
        catch (Throwable e) {
            this.log.error(FAILED_OBTAIN_SEC_CTX_MSG, e);
            throw e;
        }
    }

    void restoreDefaultContext() {
        this.curSecCtx.set(null);
    }

    @Override
    public boolean isDefaultContext() {
        return this.curSecCtx.get() == null;
    }

    @Override
    public SecurityContext securityContext() {
        SecurityContext res = this.curSecCtx.get();
        return res == null ? this.dfltSecCtx : res;
    }

    @Override
    public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) throws IgniteCheckedException {
        return this.secPrc.authenticateNode(node, cred);
    }

    @Override
    public boolean isGlobalNodeAuthentication() {
        return this.secPrc.isGlobalNodeAuthentication();
    }

    @Override
    public SecurityContext authenticate(AuthenticationContext ctx) throws IgniteCheckedException {
        return this.secPrc.authenticate(ctx);
    }

    @Override
    public Collection<SecuritySubject> authenticatedSubjects() throws IgniteCheckedException {
        return this.secPrc.authenticatedSubjects();
    }

    @Override
    public SecuritySubject authenticatedSubject(UUID subjId) throws IgniteCheckedException {
        return this.secPrc.authenticatedSubject(subjId);
    }

    @Override
    public void onSessionExpired(UUID subjId) {
        this.secPrc.onSessionExpired(subjId);
    }

    @Override
    public void authorize(String name, SecurityPermission perm) throws SecurityException {
        SecurityContext secCtx = this.securityContext();
        assert (secCtx != null);
        this.secPrc.authorize(name, perm, secCtx);
    }

    @Override
    public IgniteSandbox sandbox() {
        return this.sandbox;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.addNodeAttribute(ATTR_GRID_SEC_PROC_CLASS, this.secPrc.getClass().getName());
        this.secPrc.start();
        if (SecurityUtils.hasSecurityManager() && this.secPrc.sandboxEnabled()) {
            this.sandbox = new AccessControllerSandbox(this.ctx, this);
            this.updatePackageAccessProperty();
        } else {
            if (this.secPrc.sandboxEnabled()) {
                this.log.warning("GridSecurityProcessor#sandboxEnabled returns true, but system SecurityManager is not defined, that may be a cause of security lack when IgniteCompute or IgniteCache operations perform.");
            }
            this.sandbox = new NoOpSandbox();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePackageAccessProperty() {
        AtomicInteger atomicInteger = SANDBOXED_NODES_COUNTER;
        synchronized (atomicInteger) {
            if (SANDBOXED_NODES_COUNTER.getAndIncrement() == 0) {
                String packAccess = Security.getProperty("package.access");
                if (!F.isEmpty(packAccess)) {
                    if (!packAccess.contains("org.apache.ignite.internal")) {
                        Security.setProperty("package.access", packAccess + ',' + "org.apache.ignite.internal");
                    }
                } else {
                    Security.setProperty("package.access", "org.apache.ignite.internal");
                }
            }
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.clearPackageAccessProperty();
        this.secPrc.stop(cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPackageAccessProperty() {
        if (SecurityUtils.hasSecurityManager() && this.secPrc.sandboxEnabled()) {
            AtomicInteger atomicInteger = SANDBOXED_NODES_COUNTER;
            synchronized (atomicInteger) {
                if (SANDBOXED_NODES_COUNTER.decrementAndGet() == 0) {
                    String packAccess = Security.getProperty("package.access");
                    if (packAccess.equals("org.apache.ignite.internal")) {
                        Security.setProperty("package.access", null);
                    } else if (packAccess.contains(",org.apache.ignite.internal")) {
                        Security.setProperty("package.access", packAccess.replace(",org.apache.ignite.internal", ""));
                    }
                }
            }
        }
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        this.ctx.event().addDiscoveryEventListener((evt, discoCache) -> this.secCtxs.remove(evt.eventNode().id()), 12, 11);
        this.secPrc.onKernalStart(active);
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.secPrc.onKernalStop(cancel);
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        this.secPrc.collectJoiningNodeData(dataBag);
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        this.secPrc.collectGridNodeData(dataBag);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        this.secPrc.onGridDataReceived(data);
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        this.secPrc.onJoiningNodeDataReceived(data);
    }

    @Override
    public void printMemoryStats() {
        this.secPrc.printMemoryStats();
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        IgniteNodeValidationResult res = this.validateSecProcClass(node);
        return res != null ? res : this.secPrc.validateNode(node);
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        IgniteNodeValidationResult res = this.validateSecProcClass(node);
        return res != null ? res : this.secPrc.validateNode(node, discoData);
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return this.secPrc.discoveryDataType();
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        this.secPrc.onDisconnected(reconnectFut);
    }

    @Override
    @Nullable
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        return this.secPrc.onReconnected(clusterRestarted);
    }

    @Override
    public void createUser(String login, char[] pwd) throws IgniteCheckedException {
        this.secPrc.createUser(login, pwd);
    }

    @Override
    public void alterUser(String login, char[] pwd) throws IgniteCheckedException {
        this.secPrc.alterUser(login, pwd);
    }

    @Override
    public void dropUser(String login) throws IgniteCheckedException {
        this.secPrc.dropUser(login);
    }

    @Override
    public void onLocalJoin() {
        this.dfltSecCtx = SecurityUtils.nodeSecurityContext(this.marsh, U.resolveClassLoader(this.ctx.config()), this.ctx.discovery().localNode());
    }

    private IgniteNodeValidationResult validateSecProcClass(ClusterNode node) {
        String rmtCls = (String)node.attribute(ATTR_GRID_SEC_PROC_CLASS);
        String locCls = this.secPrc.getClass().getName();
        if (!F.eq(locCls, rmtCls)) {
            return new IgniteNodeValidationResult(node.id(), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", this.ctx.localNodeId(), node.id(), locCls, rmtCls), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", node.id(), this.ctx.localNodeId(), rmtCls, locCls));
        }
        return null;
    }

    public GridSecurityProcessor securityProcessor() {
        return this.secPrc;
    }
}

