/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairAbstractFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.transactions.TransactionState;

public class GridNearReadRepairFuture
extends GridNearReadRepairAbstractFuture {
    public GridNearReadRepairFuture(AffinityTopologyVersion topVer, GridCacheContext ctx, Collection<KeyCacheObject> keys, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, IgniteInternalTx tx) {
        super(topVer, ctx, keys, readThrough, taskName, deserializeBinary, recovery, expiryPlc, tx);
        assert (ctx.transactional()) : "Atomic cache should not be recovered using this future";
    }

    @Override
    protected void reduce() {
        HashMap<KeyCacheObject, T2<EntryGetResult, Object>> newestMap = new HashMap<KeyCacheObject, T2<EntryGetResult, Object>>();
        HashMap<KeyCacheObject, EntryGetResult> fixedMap = new HashMap<KeyCacheObject, EntryGetResult>();
        for (GridPartitionedGetFuture fut : this.futs.values()) {
            for (Map.Entry entry : ((Map)fut.result()).entrySet()) {
                KeyCacheObject key = (KeyCacheObject)entry.getKey();
                EntryGetResult candidateRes = (EntryGetResult)entry.getValue();
                Object candidateVal = this.ctx.unwrapBinaryIfNeeded(candidateRes.value(), !this.deserializeBinary, false, null);
                newestMap.putIfAbsent(key, new T2<EntryGetResult, Object>(candidateRes, candidateVal));
                T2 newest = (T2)newestMap.get(key);
                EntryGetResult newestRes = (EntryGetResult)newest.get1();
                Object newestVal = newest.get2();
                int verCompareRes = newestRes.version().compareTo(candidateRes.version());
                if (verCompareRes < 0) {
                    newestMap.put(key, new T2<EntryGetResult, Object>(candidateRes, candidateVal));
                    fixedMap.put(key, candidateRes);
                    continue;
                }
                if (verCompareRes > 0) {
                    fixedMap.put(key, newestRes);
                    continue;
                }
                if (newestVal.equals(candidateVal)) continue;
                fixedMap.put(key, candidateRes);
            }
        }
        if (!fixedMap.isEmpty()) {
            this.tx.finishFuture().listen(future -> {
                TransactionState state = this.tx.state();
                if (state == TransactionState.COMMITTED) {
                    this.recordConsistencyViolation(fixedMap.keySet(), fixedMap);
                }
            });
        }
        this.onDone(fixedMap);
    }
}

