/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtTxPrepareResponse
extends GridDistributedTxPrepareResponse {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=IgniteTxKey.class)
    private Collection<IgniteTxKey> nearEvicted;
    private IgniteUuid futId;
    private int miniId;
    @GridDirectMap(keyType=Integer.class, valueType=int[].class)
    private Map<Integer, int[]> invalidParts;
    @GridDirectCollection(value=GridCacheEntryInfo.class)
    private List<GridCacheEntryInfo> preloadEntries;

    public GridDhtTxPrepareResponse() {
    }

    public GridDhtTxPrepareResponse(int part, GridCacheVersion xid, IgniteUuid futId, int miniId, boolean addDepInfo) {
        super(part, xid, addDepInfo);
        assert (futId != null);
        assert (miniId != 0);
        this.futId = futId;
        this.miniId = miniId;
    }

    public GridDhtTxPrepareResponse(int part, GridCacheVersion xid, IgniteUuid futId, int miniId, Throwable err, boolean addDepInfo) {
        super(part, xid, err, addDepInfo);
        assert (futId != null);
        assert (miniId != 0);
        this.futId = futId;
        this.miniId = miniId;
    }

    public Collection<IgniteTxKey> nearEvicted() {
        return this.nearEvicted;
    }

    public void nearEvicted(Collection<IgniteTxKey> nearEvicted) {
        this.nearEvicted = nearEvicted;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public int miniId() {
        return this.miniId;
    }

    Map<Integer, int[]> invalidPartitionsByCacheId() {
        return this.invalidParts;
    }

    public void invalidPartitionsByCacheId(Map<Integer, Set<Integer>> invalidPartsByCacheId) {
        this.invalidParts = CU.convertInvalidPartitions(invalidPartsByCacheId);
    }

    Collection<GridCacheEntryInfo> preloadEntries() {
        return this.preloadEntries == null ? Collections.emptyList() : this.preloadEntries;
    }

    public void addPreloadEntry(GridCacheEntryInfo info) {
        assert (info.cacheId() != 0);
        if (this.preloadEntries == null) {
            this.preloadEntries = new ArrayList<GridCacheEntryInfo>();
        }
        this.preloadEntries.add(info);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        GridCacheContext cctx;
        super.prepareMarshal(ctx);
        if (this.nearEvicted != null) {
            for (IgniteTxKey key : this.nearEvicted) {
                cctx = ctx.cacheContext(key.cacheId());
                if (cctx == null) continue;
                key.prepareMarshal(cctx);
            }
        }
        if (this.preloadEntries != null) {
            for (GridCacheEntryInfo info : this.preloadEntries) {
                cctx = ctx.cacheContext(info.cacheId());
                info.marshal(cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        GridCacheContext cctx;
        super.finishUnmarshal(ctx, ldr);
        if (this.nearEvicted != null) {
            for (IgniteTxKey key : this.nearEvicted) {
                cctx = ctx.cacheContext(key.cacheId());
                key.finishUnmarshal(cctx, ldr);
            }
        }
        if (this.preloadEntries != null) {
            for (GridCacheEntryInfo info : this.preloadEntries) {
                cctx = ctx.cacheContext(info.cacheId());
                info.unmarshal(cctx, ldr);
            }
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 11: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeMap("invalidParts", this.invalidParts, MessageCollectionItemType.INT, MessageCollectionItemType.INT_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeCollection("nearEvicted", this.nearEvicted, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeCollection("preloadEntries", this.preloadEntries, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 11: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.invalidParts = reader.readMap("invalidParts", MessageCollectionItemType.INT, MessageCollectionItemType.INT_ARR, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.nearEvicted = reader.readCollection("nearEvicted", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.preloadEntries = (List)reader.readCollection("preloadEntries", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxPrepareResponse.class);
    }

    @Override
    public short directType() {
        return 35;
    }

    @Override
    public byte fieldsCount() {
        return 16;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxPrepareResponse.class, this, "super", (Object)super.toString());
    }
}

