/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheCompressionManager;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.CacheDefaultBinaryAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateContainsValue;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateHasValue;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateNoValue;
import org.apache.ignite.internal.processors.cache.CacheEntrySerializablePredicate;
import org.apache.ignite.internal.processors.cache.CacheEvictionManager;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.CacheWeakQueryIteratorsHolder;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.EntryGetWithTtlResult;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheDeploymentManager;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheEventManager;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.cache.GridCacheIoManager;
import org.apache.ignite.internal.processors.cache.GridCacheLogger;
import org.apache.ignite.internal.processors.cache.GridCacheManager;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.datastructures.CacheDataStructuresManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTransactionalCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtColocatedCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTransactionalCache;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrManager;
import org.apache.ignite.internal.processors.cache.jta.CacheJtaManagerAdapter;
import org.apache.ignite.internal.processors.cache.local.GridLocalCache;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryManager;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.CacheVersionConflictResolver;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheManager;
import org.apache.ignite.internal.processors.plugin.CachePluginManager;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAddQueryEntityOperation;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.GPC;
import org.apache.ignite.internal.util.typedef.internal.GPR;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridCacheContext<K, V>
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<String, String>> stash = new ThreadLocal<IgniteBiTuple<String, String>>(){

        @Override
        protected IgniteBiTuple<String, String> initialValue() {
            return new IgniteBiTuple<String, String>();
        }
    };
    private static final GridCacheVersion[] EMPTY_VERSION = new GridCacheVersion[0];
    public static final boolean DFLT_READ_LOAD_BALANCING = true;
    private GridKernalContext ctx;
    private GridCacheSharedContext<K, V> sharedCtx;
    private CacheGroupContext grp;
    private IgniteLogger log;
    private volatile CacheConfiguration cacheCfg;
    private GridCacheAffinityManager affMgr;
    private GridCacheEventManager evtMgr;
    private GridCacheQueryManager<K, V> qryMgr;
    private CacheContinuousQueryManager contQryMgr;
    private CacheEvictionManager evictMgr;
    private CacheDataStructuresManager dataStructuresMgr;
    private GridCacheTtlManager ttlMgr;
    private CacheStoreManager storeMgr;
    private CacheCompressionManager compressMgr;
    private GridCacheDrManager drMgr;
    private CacheConflictResolutionManager rslvrMgr;
    private CachePluginManager pluginMgr;
    private List<GridCacheManager<K, V>> mgrs = new LinkedList<GridCacheManager<K, V>>();
    private GridCacheGateway<K, V> gate;
    private GridCacheAdapter<K, V> cache;
    private ClusterNode locNode;
    private ThreadLocal<CacheOperationContext> opCtxPerCall = new ThreadLocal();
    private String cacheName;
    private int cacheId;
    private Integer cacheIdBoxed;
    private CacheType cacheType;
    private byte plc;
    private ExpiryPolicy expiryPlc;
    private CacheWeakQueryIteratorsHolder<Map.Entry<K, V>> itHolder;
    private volatile boolean affNode;
    private CacheVersionConflictResolver conflictRslvr;
    private CacheObjectContext cacheObjCtx;
    private CountDownLatch startLatch = new CountDownLatch(1);
    private volatile AffinityTopologyVersion locStartTopVer;
    private volatile IgniteUuid dynamicDeploymentId;
    private boolean updatesAllowed;
    private boolean depEnabled;
    private boolean deferredDel;
    private volatile boolean rebalanceStartedEvtSent;
    private volatile boolean rebalanceStoppedEvtSent;
    private volatile boolean statisticsEnabled;
    private final boolean readLoadBalancingEnabled = IgniteSystemProperties.getBoolean("IGNITE_READ_LOAD_BALANCING", true);
    private boolean readFromBackup = true;
    private volatile String locMacs;
    private volatile boolean recoveryMode;
    private final boolean disableTriggeringCacheInterceptorOnConflict = Boolean.parseBoolean(System.getProperty("IGNITE_DISABLE_TRIGGERING_CACHE_INTERCEPTOR_ON_CONFLICT", "false"));
    private AtomicReference<IgniteInternalFuture<Boolean>> lastRmvAllJobFut = new AtomicReference();

    public GridCacheContext() {
    }

    public GridCacheContext(GridKernalContext ctx, GridCacheSharedContext sharedCtx, CacheConfiguration cacheCfg, CacheGroupContext grp, CacheType cacheType, AffinityTopologyVersion locStartTopVer, IgniteUuid deploymentId, boolean affNode, boolean updatesAllowed, boolean statisticsEnabled, boolean recoveryMode, CacheCompressionManager compressMgr, GridCacheEventManager evtMgr, CacheStoreManager storeMgr, CacheEvictionManager evictMgr, GridCacheQueryManager<K, V> qryMgr, CacheContinuousQueryManager contQryMgr, CacheDataStructuresManager dataStructuresMgr, GridCacheTtlManager ttlMgr, GridCacheDrManager drMgr, CacheConflictResolutionManager<K, V> rslvrMgr, CachePluginManager pluginMgr, GridCacheAffinityManager affMgr, PlatformCacheManager platformMgr) {
        assert (ctx != null);
        assert (sharedCtx != null);
        assert (cacheCfg != null);
        assert (locStartTopVer != null) : cacheCfg.getName();
        assert (compressMgr != null);
        assert (grp != null);
        assert (evtMgr != null);
        assert (storeMgr != null);
        assert (evictMgr != null);
        assert (qryMgr != null);
        assert (contQryMgr != null);
        assert (affMgr != null);
        assert (dataStructuresMgr != null);
        assert (ttlMgr != null);
        assert (rslvrMgr != null);
        assert (pluginMgr != null);
        this.ctx = ctx;
        this.sharedCtx = sharedCtx;
        this.cacheCfg = cacheCfg;
        this.grp = grp;
        this.cacheType = cacheType;
        this.locStartTopVer = locStartTopVer;
        this.affNode = affNode;
        this.updatesAllowed = updatesAllowed;
        this.depEnabled = ctx.deploy().enabled() && !this.cacheObjects().isBinaryEnabled(cacheCfg);
        this.compressMgr = this.add(compressMgr);
        this.evtMgr = this.add(evtMgr);
        this.storeMgr = this.add(storeMgr);
        this.evictMgr = this.add(evictMgr);
        this.qryMgr = this.add(qryMgr);
        this.contQryMgr = this.add(contQryMgr);
        this.dataStructuresMgr = this.add(dataStructuresMgr);
        this.ttlMgr = this.add(ttlMgr);
        this.drMgr = this.add(drMgr);
        this.rslvrMgr = this.add(rslvrMgr);
        this.pluginMgr = this.add(pluginMgr);
        this.affMgr = this.add(affMgr);
        this.add(platformMgr);
        this.log = ctx.log(this.getClass());
        this.gate = new GridCacheGateway(this);
        this.cacheName = cacheCfg.getName();
        this.cacheId = CU.cacheId(this.cacheName);
        this.cacheIdBoxed = this.cacheId;
        this.plc = cacheType.ioPolicy();
        Factory factory = cacheCfg.getExpiryPolicyFactory();
        ExpiryPolicy expiryPolicy = this.expiryPlc = factory != null ? (ExpiryPolicy)factory.create() : null;
        if (this.expiryPlc instanceof EternalExpiryPolicy) {
            this.expiryPlc = null;
        }
        this.itHolder = new CacheWeakQueryIteratorsHolder(this.log);
        this.readFromBackup = cacheCfg.isReadFromBackup();
        this.dynamicDeploymentId = deploymentId;
        this.recoveryMode = recoveryMode;
        this.statisticsEnabled(statisticsEnabled);
        assert (this.kernalContext().recoveryMode() == recoveryMode);
        if (!recoveryMode) {
            this.locMacs = (String)this.localNode().attribute("org.apache.ignite.macs");
            assert (this.locMacs != null);
        }
    }

    public void finishRecovery(AffinityTopologyVersion topVer, DynamicCacheDescriptor clusterWideDesc) {
        assert (this.recoveryMode) : this;
        this.recoveryMode = false;
        this.locStartTopVer = topVer;
        this.locMacs = (String)this.localNode().attribute("org.apache.ignite.macs");
        assert (this.locMacs != null);
        this.statisticsEnabled = clusterWideDesc.cacheConfiguration().isStatisticsEnabled();
        this.dynamicDeploymentId = clusterWideDesc.deploymentId();
    }

    public boolean isRecoveryMode() {
        return this.recoveryMode;
    }

    public int groupId() {
        return this.grp.groupId();
    }

    public CacheGroupContext group() {
        return this.grp;
    }

    public IgniteUuid dynamicDeploymentId() {
        return this.dynamicDeploymentId;
    }

    void initConflictResolver() {
        this.conflictRslvr = this.rslvrMgr.conflictResolver();
    }

    public boolean affinityNode() {
        return this.affNode;
    }

    public boolean isReplicatedAffinityNode() {
        return this.isReplicated() && this.affinityNode();
    }

    public void awaitStarted() throws IgniteCheckedException {
        U.await(this.startLatch);
        GridCachePreloader prldr = this.preloader();
        if (prldr != null) {
            prldr.startFuture().get();
        }
    }

    public boolean started() {
        if (this.startLatch.getCount() != 0L) {
            return false;
        }
        GridCachePreloader prldr = this.preloader();
        return prldr == null || prldr.startFuture().isDone();
    }

    public void onStarted() {
        this.startLatch.countDown();
    }

    public AffinityTopologyVersion startTopologyVersion() {
        assert (this.locStartTopVer != null) : this.name();
        return this.locStartTopVer;
    }

    @Nullable
    public ExpiryPolicy expiry() {
        return this.expiryPlc;
    }

    @Nullable
    public ExpiryPolicy expiryForTxEntry(IgniteTxEntry txEntry) {
        ExpiryPolicy plc = txEntry.expiry();
        return plc != null ? plc : this.expiryPlc;
    }

    @Nullable
    private <T extends GridCacheManager<K, V>> T add(@Nullable T mgr) {
        if (mgr != null) {
            this.mgrs.add(mgr);
        }
        return mgr;
    }

    public List<GridCacheManager<K, V>> managers() {
        return this.mgrs;
    }

    public GridCacheSharedContext<K, V> shared() {
        return this.sharedCtx;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public Integer cacheIdBoxed() {
        return this.cacheIdBoxed;
    }

    public boolean systemTx() {
        return this.cacheType == CacheType.UTILITY || (this.cacheType == CacheType.INTERNAL || this.cacheType == CacheType.DATA_STRUCTURES) && this.transactional();
    }

    public boolean userCache() {
        return this.cacheType.userCache();
    }

    public boolean dataStructuresCache() {
        return this.cacheType == CacheType.DATA_STRUCTURES;
    }

    public byte ioPolicy() {
        return this.plc;
    }

    public void cache(GridCacheAdapter<K, V> cache) {
        this.cache = cache;
        this.deferredDel = cache.isDht() || cache.isDhtAtomic() || cache.isColocated() || cache.isNear() && cache.configuration().getAtomicityMode() == CacheAtomicityMode.ATOMIC;
    }

    public GridLocalCache<K, V> local() {
        return (GridLocalCache)this.cache;
    }

    public boolean isDht() {
        return this.cache != null && this.cache.isDht();
    }

    public boolean isDhtAtomic() {
        return this.cache != null && this.cache.isDhtAtomic();
    }

    public boolean isColocated() {
        return this.cache != null && this.cache.isColocated();
    }

    public boolean isNear() {
        return this.cache != null && this.cache.isNear();
    }

    public boolean isLocal() {
        return this.cache != null && this.cache.isLocal();
    }

    public boolean isReplicated() {
        return this.config().getCacheMode() == CacheMode.REPLICATED;
    }

    public boolean isPartitioned() {
        return this.config().getCacheMode() == CacheMode.PARTITIONED;
    }

    public boolean isDrEnabled() {
        return this.dr().enabled();
    }

    public boolean isQueryEnabled() {
        return !F.isEmpty(this.config().getQueryEntities());
    }

    public boolean deferredDelete() {
        return this.deferredDel;
    }

    public void incrementPublicSize(GridCacheMapEntry e) {
        assert (this.deferredDelete());
        assert (e != null);
        assert (!e.isInternal()) : e;
        this.cache.incrementSize(e);
    }

    public void decrementPublicSize(GridCacheMapEntry e) {
        assert (this.deferredDelete());
        assert (e != null);
        assert (!e.isInternal()) : e;
        this.cache.decrementSize(e);
    }

    public GridDhtCacheAdapter<K, V> dht() {
        return (GridDhtCacheAdapter)this.cache;
    }

    public GridDhtTransactionalCacheAdapter<K, V> dhtTx() {
        return (GridDhtTransactionalCacheAdapter)this.cache;
    }

    public GridDhtColocatedCache<K, V> colocated() {
        return (GridDhtColocatedCache)this.cache;
    }

    public GridNearCacheAdapter<K, V> near() {
        return (GridNearCacheAdapter)this.cache;
    }

    public GridNearTransactionalCache<K, V> nearTx() {
        return (GridNearTransactionalCache)this.cache;
    }

    public GridCacheGateway<K, V> gate() {
        return this.gate;
    }

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    public IgniteEx grid() {
        return this.ctx.grid();
    }

    public String igniteInstanceName() {
        return this.ctx.igniteInstanceName();
    }

    public String name() {
        return this.cacheName;
    }

    public DataRegion dataRegion() {
        return this.grp.dataRegion();
    }

    public IgniteTxKey txKey(KeyCacheObject key) {
        return new IgniteTxKey(key, this.cacheId);
    }

    public void checkSecurity(SecurityPermission op) throws SecurityException {
        if (CU.isSystemCache(this.name())) {
            return;
        }
        this.ctx.security().authorize(this.name(), op);
    }

    public GridCachePreloader preloader() {
        return this.cache().preloader();
    }

    public UUID nodeId() {
        return this.ctx.localNodeId();
    }

    public boolean rebalanceEnabled() {
        return this.grp.rebalanceEnabled();
    }

    public boolean atomic() {
        return this.config().getAtomicityMode() == CacheAtomicityMode.ATOMIC;
    }

    public boolean transactional() {
        CacheConfiguration cfg = this.config();
        return cfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL || cfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
    }

    public boolean transactionalSnapshot() {
        return this.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
    }

    public boolean disableTriggeringCacheInterceptorOnConflict() {
        return this.disableTriggeringCacheInterceptorOnConflict;
    }

    public ClusterNode localNode() {
        if (this.locNode == null) {
            this.locNode = this.ctx.discovery().localNode();
        }
        return this.locNode;
    }

    public UUID localNodeId() {
        return this.ctx.localNodeId();
    }

    public boolean isLocalNode(ClusterNode n) {
        assert (n != null);
        return this.localNode().id().equals(n.id());
    }

    public boolean isLocalNode(UUID id) {
        assert (id != null);
        return this.localNode().id().equals(id);
    }

    @Nullable
    public ClusterNode node(UUID nodeId) {
        assert (nodeId != null);
        return this.ctx.discovery().node(nodeId);
    }

    public GridDhtPartitionTopology topology() {
        return this.grp.topology();
    }

    public GridDhtCacheAdapter dhtCache() {
        GridCacheAdapter<K, V> cache = this.cache;
        if (cache == null) {
            throw new IllegalStateException("Cache stopped: " + this.cacheName);
        }
        return this.isNear() ? ((GridNearCacheAdapter)cache).dht() : this.dht();
    }

    public GridDhtTopologyFuture topologyVersionFuture() {
        GridCacheAdapter<K, V> cache = this.cache;
        if (cache == null) {
            throw new IllegalStateException("Cache stopped: " + this.cacheName);
        }
        assert (cache.isNear() || cache.isDht() || cache.isColocated() || cache.isDhtAtomic()) : cache;
        return this.topology(cache).topologyVersionFuture();
    }

    private GridDhtPartitionTopology topology(GridCacheAdapter<K, V> cache) {
        return cache.isNear() ? ((GridNearCacheAdapter)cache).dht().topology() : ((GridDhtCacheAdapter)cache).topology();
    }

    public Marshaller marshaller() {
        return this.ctx.config().getMarshaller();
    }

    public IgniteLogger logger(String ctgr) {
        return new GridCacheLogger(this, ctgr);
    }

    public IgniteLogger logger(Class<?> cls) {
        return this.logger(cls.getName());
    }

    public IgniteConfiguration gridConfig() {
        return this.ctx.config();
    }

    public GridIoManager gridIO() {
        return this.ctx.io();
    }

    public GridTimeoutProcessor time() {
        return this.ctx.timeout();
    }

    public GridDeploymentManager gridDeploy() {
        return this.ctx.deploy();
    }

    public GridEventStorageManager gridEvents() {
        return this.ctx.event();
    }

    public GridClosureProcessor closures() {
        return this.ctx.closure();
    }

    public GridDiscoveryManager discovery() {
        return this.ctx.discovery();
    }

    public GridCacheAdapter<K, V> cache() {
        return this.cache;
    }

    public CacheConfiguration config() {
        CacheConfiguration res = this.cacheCfg;
        if (res == null) {
            throw new IllegalStateException(new CacheStoppedException(this.name()));
        }
        return res;
    }

    public boolean writeToStoreFromDht() {
        return this.store().isLocal() || this.config().isWriteBehindEnabled();
    }

    public IgniteTxManager tm() {
        return this.sharedCtx.tm();
    }

    public GridCacheVersionManager versions() {
        return this.sharedCtx.versions();
    }

    public GridCacheMvccManager mvcc() {
        return this.sharedCtx.mvcc();
    }

    public GridCacheEventManager events() {
        return this.evtMgr;
    }

    public GridCacheAffinityManager affinity() {
        return this.affMgr;
    }

    public GridCacheQueryManager<K, V> queries() {
        return this.qryMgr;
    }

    public CacheContinuousQueryManager continuousQueries() {
        return this.contQryMgr;
    }

    public CacheWeakQueryIteratorsHolder<Map.Entry<K, V>> itHolder() {
        return this.itHolder;
    }

    public CacheStoreManager store() {
        return this.storeMgr;
    }

    public GridCacheDeploymentManager<K, V> deploy() {
        return this.sharedCtx.deploy();
    }

    public GridCacheIoManager io() {
        return this.sharedCtx.io();
    }

    public CacheEvictionManager evicts() {
        return this.evictMgr;
    }

    public CacheDataStructuresManager dataStructures() {
        return this.dataStructuresMgr;
    }

    public GridCacheDrManager dr() {
        return this.drMgr;
    }

    public IgniteCacheOffheapManager offheap() {
        return this.grp.offheap();
    }

    public GridCacheTtlManager ttl() {
        return this.ttlMgr;
    }

    public CacheJtaManagerAdapter jta() {
        return this.sharedCtx.jta();
    }

    public CachePluginManager plugin() {
        return this.pluginMgr;
    }

    public boolean putIfAbsentFilter(@Nullable CacheEntryPredicate[] p) {
        if (p == null || p.length == 0) {
            return false;
        }
        for (CacheEntryPredicate p0 : p) {
            if (!(p0 instanceof CacheEntrySerializablePredicate) || !(((CacheEntrySerializablePredicate)p0).predicate() instanceof CacheEntryPredicateNoValue)) continue;
            return true;
        }
        return false;
    }

    public CacheEntryPredicate noVal() {
        return new CacheEntrySerializablePredicate(new CacheEntryPredicateNoValue());
    }

    public CacheEntryPredicate hasVal() {
        return new CacheEntrySerializablePredicate(new CacheEntryPredicateHasValue());
    }

    public CacheEntryPredicate equalsVal(V val) {
        return new CacheEntryPredicateContainsValue(this.toCacheObject(val));
    }

    public GridCacheVersion[] emptyVersion() {
        return EMPTY_VERSION;
    }

    public CacheCompressionManager compress() {
        return this.compressMgr;
    }

    public void cacheObjectContext(CacheObjectContext cacheObjCtx) {
        this.cacheObjCtx = cacheObjCtx;
    }

    public IgnitePredicate<Cache.Entry<K, V>>[] vararg(IgnitePredicate<Cache.Entry<K, V>> p) {
        IgnitePredicate<Cache.Entry<K, V>>[] ignitePredicateArray;
        if (p == null) {
            ignitePredicateArray = CU.empty();
        } else {
            IgnitePredicate[] ignitePredicateArray2 = new IgnitePredicate[1];
            ignitePredicateArray = ignitePredicateArray2;
            ignitePredicateArray2[0] = p;
        }
        return ignitePredicateArray;
    }

    public <E> boolean isAll(E e, @Nullable IgnitePredicate<? super E>[] p) throws IgniteCheckedException {
        if (F.isEmpty(p)) {
            return true;
        }
        try {
            boolean pass = F.isAll(e, p);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Evaluated filters for entry [pass=" + pass + ", entry=" + e + ", filters=" + Arrays.toString(p) + ']');
            }
            return pass;
        }
        catch (RuntimeException ex) {
            throw U.cast(ex);
        }
    }

    public boolean isAll(GridCacheEntryEx e, CacheEntryPredicate[] p) throws IgniteCheckedException {
        if (p == null || p.length == 0) {
            return true;
        }
        try {
            for (CacheEntryPredicate p0 : p) {
                if (p0 == null || p0.apply(e)) continue;
                return false;
            }
        }
        catch (RuntimeException ex) {
            throw U.cast(ex);
        }
        return true;
    }

    public boolean isAllLocked(GridCacheEntryEx e, CacheEntryPredicate[] p) throws IgniteCheckedException {
        if (p == null || p.length == 0) {
            return true;
        }
        try {
            for (CacheEntryPredicate p0 : p) {
                if (p0 == null) continue;
                p0.entryLocked(true);
                if (p0.apply(e)) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (RuntimeException ex) {
            throw U.cast(ex);
        }
        finally {
            for (CacheEntryPredicate p0 : p) {
                if (p0 == null) continue;
                p0.entryLocked(false);
            }
        }
        return true;
    }

    public void operationContextPerCall(@Nullable CacheOperationContext opCtx) {
        if (this.nearContext()) {
            this.dht().near().context().opCtxPerCall.set(opCtx);
        } else {
            this.opCtxPerCall.set(opCtx);
        }
    }

    public CacheOperationContext operationContextPerCall() {
        return this.nearContext() ? this.dht().near().context().opCtxPerCall.get() : this.opCtxPerCall.get();
    }

    public boolean skipStore() {
        if (this.nearContext()) {
            return this.dht().near().context().skipStore();
        }
        CacheOperationContext opCtx = this.opCtxPerCall.get();
        return opCtx != null && opCtx.skipStore();
    }

    private boolean nearContext() {
        return this.isDht() || this.isDhtAtomic() && this.dht().near() != null;
    }

    public Runnable projectSafe(final Runnable r) {
        assert (r != null);
        final CacheOperationContext opCtx = this.operationContextPerCall();
        if (opCtx == null) {
            return r;
        }
        return new GPR(){

            @Override
            public void run() {
                CacheOperationContext old = GridCacheContext.this.operationContextPerCall();
                GridCacheContext.this.operationContextPerCall(opCtx);
                try {
                    r.run();
                }
                finally {
                    GridCacheContext.this.operationContextPerCall(old);
                }
            }
        };
    }

    public <T> Callable<T> projectSafe(final Callable<T> r) {
        assert (r != null);
        final CacheOperationContext opCtx = this.operationContextPerCall();
        if (opCtx == null) {
            return r;
        }
        return new GPC<T>(){

            @Override
            public T call() throws Exception {
                CacheOperationContext old = GridCacheContext.this.operationContextPerCall();
                GridCacheContext.this.operationContextPerCall(opCtx);
                try {
                    Object v = r.call();
                    return v;
                }
                finally {
                    GridCacheContext.this.operationContextPerCall(old);
                }
            }
        };
    }

    public boolean deploymentEnabled() {
        return this.depEnabled;
    }

    public boolean readThrough() {
        return this.config().isReadThrough() && !this.skipStore();
    }

    public boolean readThroughConfigured() {
        return this.store().configured() && this.config().isReadThrough();
    }

    public boolean loadPreviousValue() {
        return this.config().isLoadPreviousValue();
    }

    public boolean writeThrough() {
        return this.config().isWriteThrough() && !this.skipStore();
    }

    public boolean isInvalidate() {
        return this.config().isInvalidate();
    }

    public boolean syncCommit() {
        return this.config().getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_SYNC;
    }

    public boolean syncRollback() {
        return this.config().getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_SYNC;
    }

    public boolean syncPrimary() {
        return this.config().getWriteSynchronizationMode() == CacheWriteSynchronizationMode.PRIMARY_SYNC;
    }

    public void dhtMap(UUID nearNodeId, AffinityTopologyVersion topVer, GridDhtCacheEntry entry, GridCacheVersion explicitLockVer, IgniteLogger log, Map<ClusterNode, List<GridDhtCacheEntry>> dhtMap, @Nullable Map<ClusterNode, List<GridDhtCacheEntry>> nearMap) throws GridCacheEntryRemovedException {
        assert (!AffinityTopologyVersion.NONE.equals(topVer));
        List<ClusterNode> dhtNodes = this.dht().topology().nodes(entry.partition(), topVer);
        if (log.isDebugEnabled()) {
            log.debug("Mapping entry to DHT nodes [nodes=" + U.nodeIds(dhtNodes) + ", entry=" + entry + ']');
        }
        Collection<ClusterNode> dhtRemoteNodes = F.view(dhtNodes, F.remoteNodes(this.nodeId()));
        this.map(entry, dhtRemoteNodes, dhtMap);
        Collection<ClusterNode> nearRemoteNodes = null;
        if (nearMap != null) {
            Collection<UUID> readers = entry.readers();
            Collection<ClusterNode> nearNodes = null;
            if (!F.isEmpty(readers)) {
                nearNodes = this.discovery().nodes(readers, F0.notEqualTo(nearNodeId));
                if (log.isDebugEnabled()) {
                    log.debug("Mapping entry to near nodes [nodes=" + U.nodeIds(nearNodes) + ", entry=" + entry + ']');
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Entry has no near readers: " + entry);
            }
            if (nearNodes != null && !nearNodes.isEmpty()) {
                nearRemoteNodes = F.view(nearNodes, F.notIn(dhtNodes));
                this.map(entry, nearRemoteNodes, nearMap);
            }
        }
        if (explicitLockVer != null) {
            ArrayList<ClusterNode> dhtNodeIds = new ArrayList<ClusterNode>(dhtRemoteNodes);
            ArrayList<ClusterNode> nearNodeIds = F.isEmpty(nearRemoteNodes) ? null : new ArrayList<ClusterNode>(nearRemoteNodes);
            entry.mappings(explicitLockVer, dhtNodeIds, nearNodeIds);
        }
    }

    public void dhtMap(GridDhtCacheEntry entry, GridCacheVersion explicitLockVer, IgniteLogger log, Map<ClusterNode, List<GridDhtCacheEntry>> dhtMap, Map<ClusterNode, List<GridDhtCacheEntry>> nearMap) throws GridCacheEntryRemovedException {
        assert (explicitLockVer != null);
        GridCacheMvccCandidate cand = entry.candidate(explicitLockVer);
        if (cand != null) {
            Collection<ClusterNode> dhtNodes = cand.mappedDhtNodes();
            if (log.isDebugEnabled()) {
                log.debug("Mapping explicit lock to DHT nodes [nodes=" + U.nodeIds(dhtNodes) + ", entry=" + entry + ']');
            }
            Collection<ClusterNode> nearNodes = cand.mappedNearNodes();
            this.map(entry, dhtNodes, dhtMap);
            if (nearNodes != null && !nearNodes.isEmpty()) {
                this.map(entry, nearNodes, nearMap);
            }
        }
    }

    private void map(GridDhtCacheEntry entry, Iterable<ClusterNode> nodes, Map<ClusterNode, List<GridDhtCacheEntry>> map) {
        if (nodes != null) {
            for (ClusterNode n : nodes) {
                List<GridDhtCacheEntry> entries = map.get(n);
                if (entries == null) {
                    entries = new LinkedList<GridDhtCacheEntry>();
                    map.put(n, entries);
                }
                entries.add(entry);
            }
        }
    }

    public boolean conflictNeedResolve() {
        return this.conflictRslvr != null;
    }

    public GridCacheVersionConflictContext<K, V> conflictResolve(GridCacheVersionedEntryEx<K, V> oldEntry, GridCacheVersionedEntryEx<K, V> newEntry, boolean atomicVerComp) throws IgniteCheckedException {
        assert (this.conflictRslvr != null) : "Should not reach this place.";
        GridCacheVersionConflictContext<K, V> ctx = this.conflictRslvr.resolve(this.cacheObjCtx, oldEntry, newEntry, atomicVerComp);
        if (ctx.isManualResolve()) {
            this.drMgr.onReceiveCacheConflictResolved(ctx.isUseNew(), ctx.isUseOld(), ctx.isMerge());
        }
        return ctx;
    }

    public byte dataCenterId() {
        return this.dr().dataCenterId();
    }

    public void onDeferredDelete(GridCacheEntryEx entry, GridCacheVersion ver) {
        assert (entry != null);
        assert (!entry.lockedByCurrentThread()) : entry;
        assert (ver != null);
        assert (this.deferredDelete()) : this.cache;
        this.cache.onDeferredDelete(entry, ver);
    }

    public boolean cancelRemove(@Nullable IgniteBiTuple<Boolean, ?> interceptorRes) {
        if (interceptorRes != null) {
            if (interceptorRes.get1() == null) {
                U.warn(this.log, "CacheInterceptor must not return null as cancellation flag value from 'onBeforeRemove' method.");
                return false;
            }
            return interceptorRes.get1();
        }
        U.warn(this.log, "CacheInterceptor must not return null from 'onBeforeRemove' method.");
        return false;
    }

    public IgniteCacheObjectProcessor cacheObjects() {
        return this.kernalContext().cacheObjects();
    }

    public boolean binaryMarshaller() {
        return this.marshaller() instanceof BinaryMarshaller;
    }

    public boolean keepBinary() {
        CacheOperationContext opCtx = this.operationContextPerCall();
        return opCtx != null && opCtx.isKeepBinary();
    }

    public boolean needValueCopy() {
        return this.affNode && this.config().isCopyOnRead();
    }

    @Nullable
    public <T> T unwrapTemporary(@Nullable Object obj) {
        return (T)this.cacheObjects().unwrapTemporary(this, obj);
    }

    public Collection<Object> unwrapBinariesIfNeeded(Collection<Object> col, boolean keepBinary) {
        return CacheObjectUtils.unwrapBinariesIfNeeded(this.cacheObjCtx, col, keepBinary);
    }

    public Object unwrapBinaryIfNeeded(Object o, boolean keepBinary, @Nullable ClassLoader ldr) {
        return this.unwrapBinaryIfNeeded(o, keepBinary, true, ldr);
    }

    public Object unwrapBinaryIfNeeded(Object o, boolean keepBinary, boolean cpy, @Nullable ClassLoader ldr) {
        return this.cacheObjCtx.unwrapBinaryIfNeeded(o, keepBinary, cpy, ldr);
    }

    public Map unwrapInvokeResult(@Nullable Map<Object, EntryProcessorResult> resMap, final boolean keepBinary) {
        return F.viewReadOnly(resMap, new C1<EntryProcessorResult, EntryProcessorResult>(){

            @Override
            public EntryProcessorResult apply(EntryProcessorResult res) {
                CacheInvokeResult invokeRes;
                if (res instanceof CacheInvokeResult && (invokeRes = (CacheInvokeResult)res).result() != null) {
                    res = CacheInvokeResult.fromResult(GridCacheContext.this.unwrapBinaryIfNeeded(invokeRes.result(), keepBinary, false, null));
                }
                return res;
            }
        }, new IgnitePredicate[0]);
    }

    public CacheObjectContext cacheObjectContext() {
        return this.cacheObjCtx;
    }

    @Nullable
    public CacheObject toCacheObject(@Nullable Object obj) {
        assert (this.validObjectForCache(obj)) : obj;
        return this.cacheObjects().toCacheObject(this.cacheObjCtx, obj, true, this.grp.isTopologyLocked());
    }

    public KeyCacheObject toCacheKeyObject(Object obj) {
        assert (this.validObjectForCache(obj)) : obj;
        return this.cacheObjects().toCacheKeyObject(this.cacheObjCtx, this, obj, true);
    }

    private boolean validObjectForCache(Object obj) {
        return obj == null || !CU.isUtilityCache(this.cacheName) || this.ctx.marshallerContext().isSystemType(obj.getClass().getName());
    }

    public KeyCacheObject toCacheKeyObject(byte[] bytes) throws IgniteCheckedException {
        Object obj = this.ctx.cacheObjects().unmarshal(this.cacheObjCtx, bytes, this.deploy().localLoader());
        return this.cacheObjects().toCacheKeyObject(this.cacheObjCtx, this, obj, false);
    }

    public void validateKeyAndValue(KeyCacheObject key, CacheObject val) throws IgniteCheckedException {
        if (val == null) {
            return;
        }
        if (!this.isQueryEnabled()) {
            return;
        }
        try {
            this.ctx.query().validateKeyAndValue(this.cacheObjCtx, key, val);
        }
        catch (RuntimeException e) {
            throw U.cast(e);
        }
    }

    public <K1, V1> void addResult(Map<K1, V1> map, KeyCacheObject key, CacheObject val, boolean skipVals, boolean keepCacheObjects, boolean deserializeBinary, boolean cpy, GridCacheVersion ver, long expireTime, long ttl, @Nullable ClassLoader ldr) {
        this.addResult(map, key, val, skipVals, keepCacheObjects, deserializeBinary, cpy, null, ver, expireTime, ttl, ver != null, ldr);
    }

    public <K1, V1> void addResult(Map<K1, V1> map, KeyCacheObject key, EntryGetResult getRes, boolean skipVals, boolean keepCacheObjects, boolean deserializeBinary, boolean cpy, boolean needVer) {
        this.addResult(map, key, (CacheObject)getRes.value(), skipVals, keepCacheObjects, deserializeBinary, cpy, getRes, null, 0L, 0L, needVer, null);
    }

    public <K1, V1> void addResult(Map<K1, V1> map, KeyCacheObject key, CacheObject val, boolean skipVals, boolean keepCacheObjects, boolean deserializeBinary, boolean cpy, @Nullable EntryGetResult getRes, GridCacheVersion ver, long expireTime, long ttl, boolean needVer, @Nullable ClassLoader ldr) {
        assert (key != null);
        assert (val != null || skipVals);
        if (!keepCacheObjects) {
            Boolean val0;
            Object key0 = this.unwrapBinaryIfNeeded(key, !deserializeBinary, cpy, ldr);
            Boolean bl = skipVals ? Boolean.valueOf(true) : (val0 = this.unwrapBinaryIfNeeded(val, !deserializeBinary, cpy, ldr));
            assert (key0 != null) : key;
            assert (val0 != null) : val;
            V1 v = this.createValue(ver, expireTime, ttl, val0, getRes, needVer);
            map.put(key0, v);
        } else {
            Serializable val0 = skipVals ? Boolean.valueOf(true) : val;
            V1 v = this.createValue(ver, expireTime, ttl, val0, getRes, needVer);
            map.put(key, v);
        }
    }

    private <V1> V1 createValue(GridCacheVersion ver, long expireTime, long ttl, Object val, @Nullable EntryGetResult getRes, boolean needVer) {
        Object v;
        if (!needVer) {
            v = val;
        } else if (getRes == null) {
            v = expireTime != 0L || ttl != 0L ? new EntryGetWithTtlResult(val, ver, false, expireTime, ttl) : new EntryGetResult(val, ver, false);
        } else {
            getRes.value(val);
            v = getRes;
        }
        return (V1)v;
    }

    public boolean updatesAllowed() {
        return this.updatesAllowed;
    }

    public void cleanup() {
        this.cache = null;
        this.cacheCfg = null;
        this.evictMgr = null;
        this.qryMgr = null;
        this.dataStructuresMgr = null;
        this.cacheObjCtx = null;
        if (this.expiryPlc instanceof Closeable) {
            U.closeQuiet((Closeable)this.expiryPlc);
        }
        this.mgrs.clear();
    }

    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Cache memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ", cache=" + this.name() + ']', new Object[0]);
        this.cache().printMemoryStats();
        LinkedList<GridCacheManager<K, V>> printed = new LinkedList<GridCacheManager<K, V>>();
        for (GridCacheManager<K, V> mgr : this.managers()) {
            mgr.printMemoryStats();
            printed.add(mgr);
        }
        if (this.isNear()) {
            for (GridCacheManager<K, V> mgr : this.near().dht().context().managers()) {
                if (printed.contains(mgr)) continue;
                mgr.printMemoryStats();
            }
        }
    }

    public Collection<KeyCacheObject> cacheKeysView(Collection<?> keys) {
        return F.viewReadOnly(keys, new C1<Object, KeyCacheObject>(){

            @Override
            public KeyCacheObject apply(Object key) {
                if (key == null) {
                    throw new NullPointerException("Null key.");
                }
                return GridCacheContext.this.toCacheKeyObject(key);
            }
        }, new IgnitePredicate[0]);
    }

    public boolean reserveForFastLocalGet(int part, AffinityTopologyVersion topVer) {
        boolean result;
        boolean bl = result = this.affinityNode() && this.rebalanceEnabled() && this.checkAndReservePartition(part, topVer);
        assert (!result || !this.group().persistenceEnabled() || this.topology().partitionState(this.localNodeId(), part) == GridDhtPartitionState.OWNING) : "result=" + result + ", persistenceEnabled=" + this.group().persistenceEnabled() + ", partitionState=" + (Object)((Object)this.topology().partitionState(this.localNodeId(), part)) + ", replicated=" + this.isReplicated() + ", part=" + part;
        return result;
    }

    public void releaseForFastLocalGet(int part, AffinityTopologyVersion topVer) {
        assert (this.affinityNode());
        if (!this.isReplicated() || this.group().persistenceEnabled()) {
            GridDhtLocalPartition locPart = this.topology().localPartition(part, topVer, false);
            assert (locPart != null && locPart.state() == GridDhtPartitionState.OWNING) : "partition evicted after reserveForFastLocalGet [part=" + part + ", locPart=" + locPart + ", topVer=" + topVer + ']';
            locPart.release();
        }
    }

    public boolean readNoEntry(@Nullable IgniteCacheExpiryPolicy expiryPlc, boolean readers) {
        return this.mvccEnabled() || !this.config().isOnheapCacheEnabled() && !readers && expiryPlc == null;
    }

    public boolean mvccEnabled() {
        return this.grp.mvccEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndReservePartition(int part, AffinityTopologyVersion topVer) {
        assert (this.affinityNode());
        GridDhtPartitionTopology top = this.topology();
        if (this.isReplicated() && !this.group().persistenceEnabled()) {
            boolean rebFinished = top.rebalanceFinished(topVer);
            if (rebFinished) {
                return true;
            }
            GridDhtLocalPartition locPart = top.localPartition(part, topVer, false, false);
            return locPart != null && locPart.state() == GridDhtPartitionState.OWNING;
        }
        GridDhtLocalPartition locPart = top.localPartition(part, topVer, false, false);
        if (locPart != null && locPart.reserve()) {
            boolean canRead = true;
            try {
                boolean bl = canRead = locPart.state() == GridDhtPartitionState.OWNING;
                return bl;
            }
            finally {
                if (!canRead) {
                    locPart.release();
                }
            }
        }
        return false;
    }

    public boolean recordEvent(int type) {
        if (this.isReplicated()) {
            if (type == 80) {
                if (!this.rebalanceStartedEvtSent) {
                    this.rebalanceStartedEvtSent = true;
                    return true;
                }
                return false;
            }
            if (type == 81) {
                if (!this.rebalanceStoppedEvtSent) {
                    this.rebalanceStoppedEvtSent = true;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ClusterNode selectAffinityNodeBalanced(List<ClusterNode> affNodes, Set<ClusterNode> invalidNodes, int partId, boolean canRemap, boolean forcePrimary) {
        if (!this.readLoadBalancingEnabled) {
            if (!canRemap && !forcePrimary) {
                for (ClusterNode node : affNodes) {
                    if (!this.ctx.discovery().alive(node) || invalidNodes.contains(node)) continue;
                    return node;
                }
                return null;
            }
            ClusterNode first = affNodes.get(0);
            return !invalidNodes.contains(first) ? first : null;
        }
        if (!this.readFromBackup || forcePrimary) {
            ClusterNode first = affNodes.get(0);
            return !invalidNodes.contains(first) ? first : null;
        }
        assert (this.locMacs != null);
        int r = ThreadLocalRandom.current().nextInt(affNodes.size());
        ClusterNode n0 = null;
        for (ClusterNode node : affNodes) {
            if ((canRemap || this.discovery().alive(node)) && !invalidNodes.contains(node)) {
                if (this.locMacs.equals(node.attribute("org.apache.ignite.macs"))) {
                    return node;
                }
                if (r >= 0 || n0 == null) {
                    n0 = node;
                }
            }
            --r;
        }
        return n0;
    }

    public void prepareAffinityField(BinaryObjectBuilder builder) {
        CacheDefaultBinaryAffinityKeyMapper mapper;
        BinaryField field;
        assert (this.binaryMarshaller());
        assert (builder instanceof BinaryObjectBuilderImpl);
        BinaryObjectBuilderImpl builder0 = (BinaryObjectBuilderImpl)builder;
        if (!this.cacheObjCtx.customAffinityMapper() && (field = (mapper = (CacheDefaultBinaryAffinityKeyMapper)this.cacheObjCtx.defaultAffMapper()).affinityKeyField(builder0.typeId())) != null) {
            String fieldName = field.name();
            builder0.affinityFieldName(fieldName);
        }
    }

    public boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void statisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        if (this.isNear()) {
            this.near().dht().context().statisticsEnabled = statisticsEnabled;
        }
    }

    public boolean hasContinuousQueryListeners(@Nullable IgniteInternalTx tx) {
        return this.grp.sharedGroup() ? this.grp.hasContinuousQueryCaches() : this.contQryMgr.notifyContinuousQueries(tx) && !F.isEmpty(this.contQryMgr.updateListeners(false, false));
    }

    public void onSchemaAddQueryEntity(SchemaAddQueryEntityOperation op) {
        this.onSchemaAddQueryEntity(op.entities(), op.schemaName(), op.isSqlEscape(), op.queryParallelism());
    }

    public void onSchemaAddQueryEntity(Collection<QueryEntity> entities, String sqlSchema, boolean isSqlEscape, int qryParallelism) {
        CacheConfiguration oldCfg = this.cacheCfg;
        if (oldCfg != null) {
            this.cacheCfg = GridCacheUtils.patchCacheConfiguration(oldCfg, entities, sqlSchema, isSqlEscape, qryParallelism);
        }
        if (this.qryMgr != null) {
            this.qryMgr.enable();
        }
    }

    public AtomicReference<IgniteInternalFuture<Boolean>> lastRemoveAllJobFut() {
        return this.lastRmvAllJobFut;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.igniteInstanceName());
        U.writeString(out, this.name());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<String, String> t = stash.get();
        t.set1(U.readString(in));
        t.set2(U.readString(in));
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<String, String> t = stash.get();
            IgniteKernal grid = IgnitionEx.localIgnite();
            GridCacheAdapter cache = grid.internalCache(t.get2());
            if (cache == null) {
                throw new IllegalStateException("Failed to find cache for name: " + t.get2());
            }
            GridCacheContext gridCacheContext = cache.context();
            return gridCacheContext;
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return "GridCacheContext: " + this.name();
    }
}

