/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import javax.cache.configuration.Factory;
import org.apache.ignite.internal.util.TransientSerializable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

@TransientSerializable(methodName="transientSerializableFields")
public class TransactionConfiguration
implements Serializable {
    private static final IgniteProductVersion TX_PME_TIMEOUT_SINCE = IgniteProductVersion.fromString("2.5.1");
    private static final IgniteProductVersion DEADLOCK_TIMEOUT_SINCE = IgniteProductVersion.fromString("2.7.3");
    private static final long serialVersionUID = 0L;
    public static final boolean DFLT_TX_SERIALIZABLE_ENABLED = false;
    public static final TransactionConcurrency DFLT_TX_CONCURRENCY = TransactionConcurrency.PESSIMISTIC;
    public static final TransactionIsolation DFLT_TX_ISOLATION = TransactionIsolation.REPEATABLE_READ;
    public static final long DFLT_TRANSACTION_TIMEOUT = 0L;
    public static final long TX_TIMEOUT_ON_PARTITION_MAP_EXCHANGE = 0L;
    public static final long DFLT_DEADLOCK_TIMEOUT = 10000L;
    public static final int DFLT_PESSIMISTIC_TX_LOG_LINGER = 10000;
    private boolean txSerEnabled = false;
    private TransactionIsolation dfltIsolation = DFLT_TX_ISOLATION;
    private TransactionConcurrency dfltConcurrency = DFLT_TX_CONCURRENCY;
    private long dfltTxTimeout = 0L;
    private volatile long txTimeoutOnPartitionMapExchange = 0L;
    private long deadlockTimeout = 10000L;
    @Deprecated
    private int pessimisticTxLogSize;
    @Deprecated
    private int pessimisticTxLogLinger = 10000;
    private String tmLookupClsName;
    private Factory txManagerFactory;
    private boolean useJtaSync;

    public TransactionConfiguration() {
    }

    public TransactionConfiguration(TransactionConfiguration cfg) {
        this.dfltConcurrency = cfg.getDefaultTxConcurrency();
        this.dfltIsolation = cfg.getDefaultTxIsolation();
        this.dfltTxTimeout = cfg.getDefaultTxTimeout();
        this.txTimeoutOnPartitionMapExchange = cfg.getTxTimeoutOnPartitionMapExchange();
        this.deadlockTimeout = cfg.getDeadlockTimeout();
        this.pessimisticTxLogLinger = cfg.getPessimisticTxLogLinger();
        this.pessimisticTxLogSize = cfg.getPessimisticTxLogSize();
        this.txSerEnabled = cfg.isTxSerializableEnabled();
        this.tmLookupClsName = cfg.getTxManagerLookupClassName();
        this.txManagerFactory = cfg.getTxManagerFactory();
        this.useJtaSync = cfg.isUseJtaSynchronization();
    }

    @Deprecated
    public boolean isTxSerializableEnabled() {
        return this.txSerEnabled;
    }

    @Deprecated
    public TransactionConfiguration setTxSerializableEnabled(boolean txSerEnabled) {
        this.txSerEnabled = txSerEnabled;
        return this;
    }

    public TransactionConcurrency getDefaultTxConcurrency() {
        return this.dfltConcurrency;
    }

    public TransactionConfiguration setDefaultTxConcurrency(TransactionConcurrency dfltConcurrency) {
        this.dfltConcurrency = dfltConcurrency;
        return this;
    }

    public TransactionIsolation getDefaultTxIsolation() {
        return this.dfltIsolation;
    }

    public TransactionConfiguration setDefaultTxIsolation(TransactionIsolation dfltIsolation) {
        this.dfltIsolation = dfltIsolation;
        return this;
    }

    public long getDefaultTxTimeout() {
        return this.dfltTxTimeout;
    }

    public TransactionConfiguration setDefaultTxTimeout(long dfltTxTimeout) {
        this.dfltTxTimeout = dfltTxTimeout;
        return this;
    }

    public long getTxTimeoutOnPartitionMapExchange() {
        return this.txTimeoutOnPartitionMapExchange;
    }

    public TransactionConfiguration setTxTimeoutOnPartitionMapExchange(long txTimeoutOnPartitionMapExchange) {
        this.txTimeoutOnPartitionMapExchange = txTimeoutOnPartitionMapExchange;
        return this;
    }

    @IgniteExperimental
    public long getDeadlockTimeout() {
        return this.deadlockTimeout;
    }

    @IgniteExperimental
    public TransactionConfiguration setDeadlockTimeout(long deadlockTimeout) {
        this.deadlockTimeout = deadlockTimeout;
        return this;
    }

    @Deprecated
    public int getPessimisticTxLogSize() {
        return this.pessimisticTxLogSize;
    }

    @Deprecated
    public TransactionConfiguration setPessimisticTxLogSize(int pessimisticTxLogSize) {
        this.pessimisticTxLogSize = pessimisticTxLogSize;
        return this;
    }

    @Deprecated
    public int getPessimisticTxLogLinger() {
        return this.pessimisticTxLogLinger;
    }

    @Deprecated
    public TransactionConfiguration setPessimisticTxLogLinger(int pessimisticTxLogLinger) {
        this.pessimisticTxLogLinger = pessimisticTxLogLinger;
        return this;
    }

    @Deprecated
    public String getTxManagerLookupClassName() {
        return this.tmLookupClsName;
    }

    @Deprecated
    public TransactionConfiguration setTxManagerLookupClassName(String tmLookupClsName) {
        this.tmLookupClsName = tmLookupClsName;
        return this;
    }

    public <T> Factory<T> getTxManagerFactory() {
        return this.txManagerFactory;
    }

    public <T> TransactionConfiguration setTxManagerFactory(Factory<T> factory) {
        this.txManagerFactory = factory;
        return this;
    }

    public boolean isUseJtaSynchronization() {
        return this.useJtaSync;
    }

    public TransactionConfiguration setUseJtaSynchronization(boolean useJtaSync) {
        this.useJtaSync = useJtaSync;
        return this;
    }

    public String toString() {
        return S.toString(TransactionConfiguration.class, this);
    }

    private static String[] transientSerializableFields(IgniteProductVersion ver) {
        ArrayList<String> transients = new ArrayList<String>(2);
        if (TX_PME_TIMEOUT_SINCE.compareToIgnoreTimestamp(ver) >= 0) {
            transients.add("txTimeoutOnPartitionMapExchange");
        }
        if (DEADLOCK_TIMEOUT_SINCE.compareToIgnoreTimestamp(ver) >= 0) {
            transients.add("deadlockTimeout");
        }
        return transients.isEmpty() ? null : transients.toArray(new String[transients.size()]);
    }
}

