/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.internal.cache.query.RangeIndexQueryCriterion;
import org.apache.ignite.internal.util.typedef.internal.A;

public class IndexQueryCriteriaBuilder {
    public static IndexQueryCriterion eq(String field, Object val) {
        return IndexQueryCriteriaBuilder.between(field, val, val);
    }

    public static IndexQueryCriterion lt(String field, Object val) {
        A.notNullOrEmpty(field, "field");
        RangeIndexQueryCriterion c = new RangeIndexQueryCriterion(field, null, val);
        c.lowerIncl(true);
        c.upperNull(val == null);
        return c;
    }

    public static IndexQueryCriterion lte(String field, Object val) {
        A.notNullOrEmpty(field, "field");
        RangeIndexQueryCriterion c = new RangeIndexQueryCriterion(field, null, val);
        c.lowerIncl(true);
        c.upperIncl(true);
        c.upperNull(val == null);
        return c;
    }

    public static IndexQueryCriterion gt(String field, Object val) {
        A.notNullOrEmpty(field, "field");
        RangeIndexQueryCriterion c = new RangeIndexQueryCriterion(field, val, null);
        c.upperIncl(true);
        c.lowerNull(val == null);
        return c;
    }

    public static IndexQueryCriterion gte(String field, Object val) {
        A.notNullOrEmpty(field, "field");
        RangeIndexQueryCriterion c = new RangeIndexQueryCriterion(field, val, null);
        c.lowerIncl(true);
        c.upperIncl(true);
        c.lowerNull(val == null);
        return c;
    }

    public static IndexQueryCriterion between(String field, Object lower, Object upper) {
        A.notNullOrEmpty(field, "field");
        RangeIndexQueryCriterion c = new RangeIndexQueryCriterion(field, lower, upper);
        c.lowerIncl(true);
        c.upperIncl(true);
        c.lowerNull(lower == null);
        c.upperNull(upper == null);
        return c;
    }
}

