/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.google.gson.JsonObject;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.VariableImportances;

public class SharedTreeModelAttributes
extends ModelAttributes {
    private final VariableImportances _variableImportances;

    public <M extends SharedTreeMojoModel> SharedTreeModelAttributes(JsonObject modelJson, M model) {
        super(model, modelJson);
        this._variableImportances = this.extractVariableImportances(modelJson);
    }

    private VariableImportances extractVariableImportances(JsonObject modelJson) {
        Table table = ModelJsonReader.readTable(modelJson, "output.variable_importances");
        if (table == null) {
            return null;
        }
        double[] relativeVarimps = new double[table.rows()];
        String[] varNames = new String[table.rows()];
        int varImportanceCol = table.findColumnIndex("Relative Importance");
        int varNameCol = table.findColumnIndex("Variable");
        if (varImportanceCol == -1) {
            return null;
        }
        if (varNameCol == -1) {
            return null;
        }
        for (int i = 0; i < table.rows(); ++i) {
            relativeVarimps[i] = (Double)table.getCell(varImportanceCol, i);
            varNames[i] = (String)table.getCell(varNameCol, i);
        }
        return new VariableImportances(varNames, relativeVarimps);
    }

    public VariableImportances getVariableImportances() {
        return this._variableImportances;
    }
}

