/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.metric;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.metric.MetricCommandArg;
import org.apache.ignite.internal.commandline.systemview.SystemViewCommand;
import org.apache.ignite.internal.visor.metric.VisorMetricTask;
import org.apache.ignite.internal.visor.metric.VisorMetricTaskArg;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;

public class MetricCommand
extends AbstractCommand<VisorMetricTaskArg> {
    private VisorMetricTaskArg taskArg;
    private UUID nodeId;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try {
            Map res;
            try (GridClient client = Command.startClient(clientCfg);){
                res = (Map)TaskExecutor.executeTaskByNameOnNode(client, VisorMetricTask.class.getName(), this.taskArg, this.nodeId, clientCfg);
            }
            if (res != null) {
                List<List<?>> data = res.entrySet().stream().map(entry -> Arrays.asList(entry.getKey(), entry.getValue())).collect(Collectors.toList());
                SystemViewCommand.printTable(Arrays.asList("metric", "value"), Arrays.asList(VisorSystemViewTask.SimpleType.STRING, VisorSystemViewTask.SimpleType.STRING), data, log);
            } else {
                log.info("No metric with specified name was found [name=" + this.taskArg.name() + "]");
            }
            return res;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.nodeId = null;
        String metricName = null;
        while (argIter.hasNextSubArg()) {
            String arg = argIter.nextArg("Failed to read command argument.");
            MetricCommandArg cmdArg = CommandArgUtils.of(arg, MetricCommandArg.class);
            if (cmdArg == MetricCommandArg.NODE_ID) {
                String nodeIdArg = argIter.nextArg("ID of the node from which metric values should be obtained is expected.");
                try {
                    this.nodeId = UUID.fromString(nodeIdArg);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Failed to parse " + MetricCommandArg.NODE_ID + " command argument. String representation of \"java.util.UUID\" is exepected. For example: 123e4567-e89b-42d3-a456-556642440000", e);
                }
            }
            if (metricName != null) {
                throw new IllegalArgumentException("Multiple metric(metric registry) names are not supported.");
            }
            metricName = arg;
        }
        if (metricName == null) {
            throw new IllegalArgumentException("The name of a metric(metric registry) is expected.");
        }
        this.taskArg = new VisorMetricTaskArg(metricName);
    }

    @Override
    public VisorMetricTaskArg arg() {
        return this.taskArg;
    }

    @Override
    public void printUsage(Logger log) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("node_id", "ID of the node to get the metric values from. If not set, random node will be chosen.");
        params.put("name", "Name of the metric which value should be printed. If name of the metric registry is specified, value of all its metrics will be printed.");
        this.usage(log, "Print metric value:", CommandList.METRIC, params, CommandLogger.optional(MetricCommandArg.NODE_ID, "node_id"), "name");
    }

    @Override
    public String name() {
        return CommandList.METRIC.toCommandName();
    }
}

