/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.encryption;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.encryption.EncryptionSubcommands;
import org.apache.ignite.internal.visor.encryption.VisorChangeMasterKeyTask;

public class ChangeMasterKeyCommand
extends AbstractCommand<String> {
    private String argMasterKeyName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            String resMsg = (String)TaskExecutor.executeTaskByNameOnNode(client, VisorChangeMasterKeyTask.class.getName(), this.argMasterKeyName, null, clientCfg);
            log.info(resMsg);
            String string = resMsg;
            return string;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: the command will change the master key. Cache start and node join during the key change process is prohibited and will be rejected.";
    }

    @Override
    public String arg() {
        return this.argMasterKeyName;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.argMasterKeyName = argIter.nextArg("Expected master key name.");
    }

    @Override
    public void printUsage(Logger log) {
        this.usage(log, "Change the master key:", CommandList.ENCRYPTION, EncryptionSubcommands.CHANGE_MASTER_KEY.toString(), "newMasterKeyName");
    }

    @Override
    public String name() {
        return EncryptionSubcommands.CHANGE_MASTER_KEY.text().toUpperCase();
    }
}

