/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.catboost;

import ai.catboost.CatBoostError;
import ai.catboost.CatBoostModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ignite.ml.catboost.CatboostClassificationModel;
import org.apache.ignite.ml.inference.parser.ModelParser;
import org.apache.ignite.ml.math.primitives.vector.NamedVector;

public class CatboostClassificationModelParser
implements ModelParser<NamedVector, Double, CatboostClassificationModel> {
    private static final long serialVersionUID = -8425510352746936163L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CatboostClassificationModel parse(byte[] mdl) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(mdl);){
            CatboostClassificationModel catboostClassificationModel = new CatboostClassificationModel(CatBoostModel.loadModel((InputStream)inputStream));
            return catboostClassificationModel;
        }
        catch (CatBoostError | IOException e) {
            throw new RuntimeException("Failed to parse model " + e.getMessage(), e);
        }
    }
}

