/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.client;

import com.codahale.metrics.MetricSet;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.server.TransportChannelHandler;
import org.apache.spark.network.util.IOMode;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.NettyMemoryMetrics;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.base.Throwables;
import org.spark_project.guava.collect.Lists;

public class TransportClientFactory
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransportClientFactory.class);
    private final TransportContext context;
    private final TransportConf conf;
    private final List<TransportClientBootstrap> clientBootstraps;
    private final ConcurrentHashMap<SocketAddress, ClientPool> connectionPool;
    private final Random rand;
    private final int numConnectionsPerPeer;
    private final Class<? extends Channel> socketChannelClass;
    private EventLoopGroup workerGroup;
    private PooledByteBufAllocator pooledAllocator;
    private final NettyMemoryMetrics metrics;

    public TransportClientFactory(TransportContext context, List<TransportClientBootstrap> clientBootstraps) {
        this.context = Preconditions.checkNotNull(context);
        this.conf = context.getConf();
        this.clientBootstraps = Lists.newArrayList((Iterable)Preconditions.checkNotNull(clientBootstraps));
        this.connectionPool = new ConcurrentHashMap();
        this.numConnectionsPerPeer = this.conf.numConnectionsPerPeer();
        this.rand = new Random();
        IOMode ioMode = IOMode.valueOf(this.conf.ioMode());
        this.socketChannelClass = NettyUtils.getClientChannelClass(ioMode);
        this.workerGroup = NettyUtils.createEventLoop(ioMode, this.conf.clientThreads(), this.conf.getModuleName() + "-client");
        this.pooledAllocator = NettyUtils.createPooledByteBufAllocator(this.conf.preferDirectBufs(), false, this.conf.clientThreads());
        this.metrics = new NettyMemoryMetrics(this.pooledAllocator, this.conf.getModuleName() + "-client", this.conf);
    }

    public MetricSet getAllMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClient createClient(String remoteHost, int remotePort) throws IOException, InterruptedException {
        int clientIndex;
        TransportClient cachedClient;
        InetSocketAddress unresolvedAddress = InetSocketAddress.createUnresolved(remoteHost, remotePort);
        ClientPool clientPool = this.connectionPool.get(unresolvedAddress);
        if (clientPool == null) {
            this.connectionPool.putIfAbsent(unresolvedAddress, new ClientPool(this.numConnectionsPerPeer));
            clientPool = this.connectionPool.get(unresolvedAddress);
        }
        if ((cachedClient = clientPool.clients[clientIndex = this.rand.nextInt(this.numConnectionsPerPeer)]) != null && cachedClient.isActive()) {
            TransportChannelHandler handler;
            TransportChannelHandler transportChannelHandler = handler = (TransportChannelHandler)cachedClient.getChannel().pipeline().get(TransportChannelHandler.class);
            synchronized (transportChannelHandler) {
                handler.getResponseHandler().updateTimeOfLastRequest();
            }
            if (cachedClient.isActive()) {
                logger.trace("Returning cached connection to {}: {}", (Object)cachedClient.getSocketAddress(), (Object)cachedClient);
                return cachedClient;
            }
        }
        long preResolveHost = System.nanoTime();
        InetSocketAddress resolvedAddress = new InetSocketAddress(remoteHost, remotePort);
        long hostResolveTimeMs = (System.nanoTime() - preResolveHost) / 1000000L;
        if (hostResolveTimeMs > 2000L) {
            logger.warn("DNS resolution for {} took {} ms", (Object)resolvedAddress, (Object)hostResolveTimeMs);
        } else {
            logger.trace("DNS resolution for {} took {} ms", (Object)resolvedAddress, (Object)hostResolveTimeMs);
        }
        Object object = clientPool.locks[clientIndex];
        synchronized (object) {
            cachedClient = clientPool.clients[clientIndex];
            if (cachedClient != null) {
                if (cachedClient.isActive()) {
                    logger.trace("Returning cached connection to {}: {}", (Object)resolvedAddress, (Object)cachedClient);
                    return cachedClient;
                }
                logger.info("Found inactive connection to {}, creating a new one.", (Object)resolvedAddress);
            }
            clientPool.clients[clientIndex] = this.createClient(resolvedAddress);
            return clientPool.clients[clientIndex];
        }
    }

    public TransportClient createUnmanagedClient(String remoteHost, int remotePort) throws IOException, InterruptedException {
        InetSocketAddress address = new InetSocketAddress(remoteHost, remotePort);
        return this.createClient(address);
    }

    private TransportClient createClient(InetSocketAddress address) throws IOException, InterruptedException {
        logger.debug("Creating new connection to {}", (Object)address);
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(this.socketChannelClass)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.conf.connectionTimeoutMs())).option(ChannelOption.ALLOCATOR, (Object)this.pooledAllocator);
        if (this.conf.receiveBuf() > 0) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.conf.receiveBuf());
        }
        if (this.conf.sendBuf() > 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.conf.sendBuf());
        }
        final AtomicReference clientRef = new AtomicReference();
        final AtomicReference channelRef = new AtomicReference();
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                TransportChannelHandler clientHandler = TransportClientFactory.this.context.initializePipeline(ch);
                clientRef.set(clientHandler.getClient());
                channelRef.set(ch);
            }
        });
        long preConnect = System.nanoTime();
        ChannelFuture cf = bootstrap.connect((SocketAddress)address);
        if (!cf.await((long)this.conf.connectionTimeoutMs())) {
            throw new IOException(String.format("Connecting to %s timed out (%s ms)", address, this.conf.connectionTimeoutMs()));
        }
        if (cf.cause() != null) {
            throw new IOException(String.format("Failed to connect to %s", address), cf.cause());
        }
        TransportClient client = (TransportClient)clientRef.get();
        Channel channel = (Channel)channelRef.get();
        assert (client != null) : "Channel future completed successfully with null client";
        long preBootstrap = System.nanoTime();
        logger.debug("Connection to {} successful, running bootstraps...", (Object)address);
        try {
            for (TransportClientBootstrap clientBootstrap : this.clientBootstraps) {
                clientBootstrap.doBootstrap(client, channel);
            }
        }
        catch (Exception e) {
            long bootstrapTimeMs = (System.nanoTime() - preBootstrap) / 1000000L;
            logger.error("Exception while bootstrapping client after " + bootstrapTimeMs + " ms", (Throwable)e);
            client.close();
            throw Throwables.propagate(e);
        }
        long postBootstrap = System.nanoTime();
        logger.info("Successfully created connection to {} after {} ms ({} ms spent in bootstraps)", new Object[]{address, (postBootstrap - preConnect) / 1000000L, (postBootstrap - preBootstrap) / 1000000L});
        return client;
    }

    @Override
    public void close() {
        for (ClientPool clientPool : this.connectionPool.values()) {
            for (int i = 0; i < clientPool.clients.length; ++i) {
                TransportClient client = clientPool.clients[i];
                if (client == null) continue;
                clientPool.clients[i] = null;
                JavaUtils.closeQuietly(client);
            }
        }
        this.connectionPool.clear();
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
    }

    private static class ClientPool {
        TransportClient[] clients;
        Object[] locks;

        ClientPool(int size) {
            this.clients = new TransportClient[size];
            this.locks = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.locks[i] = new Object();
            }
        }
    }
}

